var geo;
var map;
var logo;
var legend;
var vpd;
var currentMarker = false;

function gmapload() {

		window.addEvent('keydown', function(e) {
			e = new Event(e);
			if (e.key == 'z' && e.shift == true && e.control == true) {
				console.log(map.getCenter());
				console.log(map.getZoom());
			};
		});


		map = new GMap2(document.getElementById("gmap"));


		// map.enableDoubleClickZoom();
		// map.enableScrollWheelZoom();
		map.disableScrollWheelZoom();

		logo = new GScreenOverlay('http://www.copanusa.com/products/wasp/images/gmap/wasp.png',
			new GScreenPoint(50, 0, 'pixels', 'fraction'),  // screenXY
		        new GScreenPoint(0, 0),  // overlayXY
		        new GScreenSize(190, 100)  // size on screen
		);

		legend = new GScreenOverlay('http://www.copanusa.com/products/wasp/images/gmap/legend.png',
			new GScreenPoint(230, 440, 'pixels', 'pixels'),  // screenXY
		        new GScreenPoint(0, 0),  // overlayXY
		        new GScreenSize(195, 40)  // size on screen
		);

		upcoming = new GIcon({
			image: 'http://maps.google.com/mapfiles/kml/pushpin/red-pushpin.png',
			shadow: 'http://maps.google.com/mapfiles/kml/pushpin/blue-pushpin_maps.shadow.png',
			iconSize: new GSize(32, 32),
			shadowSize: new GSize(59, 32),
			iconAnchor: new GPoint(8, 32),
			infoWindowAnchor: new GPoint(16, 0)
		});

		previous = new GIcon({
			image: 'http://maps.google.com/mapfiles/kml/pushpin/wht-pushpin.png',
			shadow: 'http://maps.google.com/mapfiles/kml/pushpin/blue-pushpin_maps.shadow.png',
			iconSize: new GSize(32, 32),
			shadowSize: new GSize(59, 32),
			iconAnchor: new GPoint(8, 32),
			infoWindowAnchor: new GPoint(16, 0)
		});

		vpdbuilding = new GIcon({
			image: '/images/vpd_building-trans.png',
			shadow: '/images/vpd_shadow-trans.png',
			iconSize: new GSize(41, 37),
			shadowSize: new GSize(41, 37),
			iconAnchor: new GPoint(22, 17),
			infoWindowAnchor: new GPoint(16, 0)
		});
				
		map.setCenter(new GLatLng(33.86770742906609, -117.55388259887695), 13);

		map.addControl(new GLargeMapControl());

		map.setMapType(G_PHYSICAL_MAP);
		map.addMapType(G_PHYSICAL_MAP);

		// map.addControl(new GMapTypeControl());

		// build markers array

		vpdmark = new GMarker(new GLatLng(33.851661,-117.536330), {icon: vpdbuilding});

		var vpdOverlay = function(marker, html) {
  			this.marker = marker;
			this.html = html;
		}

		vpdOverlay.prototype = new GOverlay();

		vpdOverlay.prototype.initialize = function(map) {
			var vpdtip = new Element('div', {
				'html': this.html,
				'id':	'vpdtip'
			});

 			offsetX = 140;
			offsetY = 130;

 			vpdtip.style.top = (map.fromLatLngToDivPixel(this.marker.getPoint()).y - offsetY) + 'px';
			vpdtip.style.left = (map.fromLatLngToDivPixel(this.marker.getPoint()).x - offsetX) + 'px';

			vpdtip.onclick = closeOverlay;

			this._map = map;
			this._div = vpdtip;

			map.getPane(G_MAP_FLOAT_PANE).appendChild(vpdtip);

		};

		vpdOverlay.prototype.remove = function(){
			this._div.parentNode.removeChild(this._div);
		};

		vpdOverlay.prototype.redraw = function() {

		};

		map.addOverlay(vpdmark);

		GEvent.addListener(vpdmark, 'click', function() {			
			if (typeof vpdOverlay !== 'undefined') {
				if (currentMarker) {
      					closeOverlay();
				}

				if (!this.overlay) {
					// just recording this for use in the closeOverlay function
					this.overlay = new vpdOverlay(this, '<h3>VISION photodesign inc.</h3><p>41775 Elm St. Suite 102<br/>Murrieta, CA 92562 USA</p><p>
												  
												  <a target="_blank" href="http://maps.google.com/maps?f=d&saddr=&daddr=VISION+photodesign&hl=en&geocode=&mra=ls&sll=33.85151,-117.536051&sspn=0.011672,0.017917&ie=UTF8&ll=33.851653,-117.53633&spn=0.011672,0.017917&z=16">get driving directions</a>
												  
												  </p>');
				}

				currentMarker = this;
				// map.panTo(new GLatLng(this.getPoint().lat(), this.getPoint().lng()));
				map.addOverlay(this.overlay);
				// this.hide();

 			} else {
    				vpdmark.openInfoWindowHtml('<p style="color: black">HTML!!!</p>');
  			}

		});

		function closeOverlay() {
  			if (currentMarker) {
    				map.removeOverlay(currentMarker.overlay);
  			}
		};


		// upcoming addresses

		/* markup[markup.length] = {
			"title": "Orlando, FL",
			"loc": "<em>- awaiting location confirmation -</em>",
			"address": "",
			"month": "August",
			"dates": "11 - 12",
			"contact": "",
			"gmark": new GMarker(new GLatLng(28.553154, -81.364438), {title: 'Orlando, FL', icon: upcoming})
		}; 

		*/


};

function myclick(i, type) {
        GEvent.trigger(type[i].gmark, "click");
};

function zoomhere(i, type) {
	type[i].gmark.closeInfoWindow();
	map.setCenter(type[i].gmark.getPoint());
	// alert(type[i].gmark.getPoint());
	map.setZoom(13);
	GEvent.trigger(type[i].gmark, "click");
};

function returnhere(i, type) {
	type[i].gmark.closeInfoWindow();
	map.returnToSavedPosition();
};

window.addEvent('domready', function(){
	gmapload();
	GEvent.addListener(map, "zoomend", closeOverlay);
	GEvent.trigger(vpdmark, "click");
});

function closeOverlay() {
  if (currentMarker) {
    map.removeOverlay(currentMarker.overlay);
    currentMarker.show();
  }
}
