<?php

function checkpage ($action, $cat, $subcat = null) {

	global $pages;

	if (is_null($cat)) {
		if (is_null($action)) {
			return 'default';	
		} else {
			if(strlen($pages['root']['pages'][$action]) == 0) {
					return 'bad';
			} else {
				if ($action == 'index') {
					return 'default';
				} else {
					return 'rootpage';
				};
			};
		};
	} else {
		// if(!$action) return 'bad';

		if(strlen($pages[$cat] == 0)) {
			return 'bad';
		} else {
			if(is_null($subcat)) {

				if(!$action) {
					return 'index';
				} else {
					if(strlen($pages[$cat]['pages'][$action]) == 0) {
						return 'bad';
					} else {
						if ($action == 'index') {
							return 'index';
						} else {
							return 'viewpage';
						};
					};
				};


			} else {

				if(strlen($pages[$cat]['subcats'][$subcat]) == 0) {
					return 'bad';
				} else {
					if(!$action) {
						return 'subindex';
					} else {
						if(strlen($pages[$cat]['subcats'][$subcat]['pages'][$action]) == 0) {
							return 'bad';
						} else {
							if ($action == 'index') {
								return 'index';
							} else {
								return 'subviewpage';
							};
						};
					};
				};
			};

		}; 
	};
};


function createnav() {
	global $pages, $cat, $subcat, $action;

	$actionfilter = ($action ? $action : 'index');

	$result .= '<ul class="main"><li><a class="pngfix" href="/">I.C. home</a></li></ul>';

	$catnavs = array_slice($pages, 1);

	foreach ($catnavs as $category => $value) {
		$result .= '<ul class="main toggle-master"><li><a href="/' . $category . '/" class="toggler">' . $value['settings']['friendly_name'] . '</a></li></ul>';
		$result .= '<div class="stretcher"' . (($category == $cat) ? ' id="selected"' : '') . '><ul>';

		foreach ($value['pages'] as $page => $details) {
			if (!$details['hide']) {
				$result .= '<li' . ((($page == $actionfilter) && ($category == $cat)) ? ' id="currentpage"' : '') . '><a href="/' . $category . '/' . $page . '.html">' . $details['navname'] . '</a></li>';
			};
		}

		$result .= '</ul></div>';
	};

	foreach ($pages['root']['pages'] as $page => $details) {
		if (!$details['hide']) {
			$result .= '<ul class="main single"' . (($page == $actionfilter) ? ' id="selected"' : '') . '>';
			$result .= '<li' . ((($page == $actionfilter)) ? ' id="currentpage"' : '') . '><a href="/' . $page . '.html">' . $details['navname'] . '</a></li>';
			$result .= '</ul>'; 
		};
	}; 

	return $result;
};

function timeback() {

	$hour = strftime("%H", strtotime("-3 hours"));
	$hourcase = $hour % 3;
	# $hourcase = "3";

	switch ($hourcase) {

		default:
		case "0":
			$result = "red";
		break;

		case "1":
			$result = "blue";
		break;

		case "2":
			$result = "olive";
		break;

	};

	return $result;
};
