/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class vNES
extends Applet
implements Runnable {
    boolean scale;
    boolean scanlines;
    boolean sound;
    boolean fps;
    boolean stereo;
    boolean nicesound;
    boolean timeemulation;
    boolean showsoundbuffer;
    int samplerate;
    int romSize;
    int progress;
    AppletUI gui;
    NES nes;
    ScreenView panelScreen;
    String rom = "";
    Font progressFont;
    Color bgColor = Color.black.darker().darker();
    boolean started = false;

    public void init() {
        this.readParams();
        System.gc();
        this.gui = new AppletUI(this);
        this.gui.init(false);
        Globals.appletMode = true;
        Globals.memoryFlushValue = 0;
        this.nes = this.gui.getNES();
        this.nes.enableSound(this.sound);
        this.nes.reset();
    }

    public void addScreenView() {
        this.panelScreen = (ScreenView)this.gui.getScreenView();
        this.panelScreen.setFPSEnabled(this.fps);
        this.panelScreen.enableFullScreen(false);
        this.setLayout(null);
        if (this.scale) {
            if (this.scanlines) {
                this.panelScreen.setScaleMode(4);
            } else {
                this.panelScreen.setScaleMode(3);
            }
            this.setSize(512, 480);
            this.setBounds(0, 0, 512, 480);
            this.panelScreen.setBounds(0, 0, 512, 480);
        } else {
            this.panelScreen.setBounds(0, 0, 256, 240);
        }
        this.setIgnoreRepaint(true);
        this.add(this.panelScreen);
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        this.progressFont = new Font("Tahoma", 1, 12);
        this.started = true;
        this.nes.loadRom(this.rom);
        if (this.nes.rom.isValid()) {
            this.addScreenView();
            Globals.timeEmulation = this.timeemulation;
            this.nes.ppu.showSoundBuffer = this.showsoundbuffer;
            System.out.println("vNES 2.03 (C) 2006-2008 Jamie Sanders");
            System.out.println("Get latest updates at www.virtualnes.com");
            System.out.println("Use of this program subject to GNU GPL, Version 3.");
            this.nes.getCpu().beginExecution();
        }
    }

    public void stop() {
        this.nes.stopEmulation();
        this.nes.getPapu().stop();
        this.destroy();
    }

    public void destroy() {
        if (this.nes != null && this.nes.getCpu().isRunning()) {
            this.stop();
        }
        if (this.nes != null) {
            this.nes.destroy();
        }
        if (this.gui != null) {
            this.gui.destroy();
        }
        this.gui = null;
        this.nes = null;
        this.panelScreen = null;
        this.rom = null;
        System.runFinalization();
        System.gc();
    }

    public void showLoadProgress(int n) {
        this.progress = n;
        this.paint(this.getGraphics());
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        if (!this.started) {
            return;
        }
        if (this.scale) {
            n2 = 512;
            n = 480;
        } else {
            n2 = 256;
            n = 240;
        }
        graphics.setColor(this.bgColor);
        graphics.fillRect(0, 0, n2, n);
        String string = this.progress < 10 ? "  " : (this.progress < 100 ? " " : "");
        String string2 = "vNES is Loading Game... " + string + this.progress + "%";
        graphics.setFont(this.progressFont);
        int n3 = graphics.getFontMetrics(this.progressFont).stringWidth(string2);
        int n4 = graphics.getFontMetrics(this.progressFont).getHeight();
        graphics.setFont(this.progressFont);
        graphics.setColor(Color.white);
        graphics.drawString(string2, n2 / 2 - n3 / 2, n / 2 - n4 / 2);
        graphics.drawString(string2, n2 / 2 - n3 / 2, n / 2 - n4 / 2);
        graphics.drawString("vNES \u00a9 2006-2008 Jamie Sanders", 12, 448);
        graphics.drawString("For updates and games, see www.virtualnes.com", 12, 464);
    }

    public void update(Graphics graphics) {
    }

    public void readParams() {
        String string = this.getParameter("rom");
        this.rom = string == null || string.equals("") ? "vnes.nes" : string;
        string = this.getParameter("scale");
        this.scale = string == null || string.equals("") ? false : string.equals("on");
        string = this.getParameter("sound");
        this.sound = string == null || string.equals("") ? true : string.equals("on");
        string = this.getParameter("stereo");
        this.stereo = string == null || string.equals("") ? true : string.equals("on");
        string = this.getParameter("scanlines");
        this.scanlines = string == null || string.equals("") ? false : string.equals("on");
        string = this.getParameter("fps");
        this.fps = string == null || string.equals("") ? false : string.equals("on");
        string = this.getParameter("nicesound");
        this.nicesound = string == null || string.equals("") ? true : string.equals("on");
        string = this.getParameter("timeemulation");
        this.timeemulation = string == null || string.equals("") ? true : string.equals("on");
        string = this.getParameter("showsoundbuffer");
        this.showsoundbuffer = string == null || string.equals("") ? false : string.equals("on");
        string = this.getParameter("romsize");
        if (string == null || string.equals("")) {
            this.romSize = -1;
        } else {
            try {
                this.romSize = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.romSize = -1;
            }
        }
    }
}

