/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WaveFileWriter {
    public static final int MAX_AMPLITUDE = Short.MAX_VALUE;
    int samplingFrequency;
    int sampleCount;
    int sampleBits;
    int channelCount;
    double sampleTime;
    ByteBuffer dataBuffer;
    RandomAccessFile raFile;
    File theFile;
    boolean fileValid;
    boolean stereo;
    byte[] buffer = new byte[44100];
    int bufferPos = 0;

    public WaveFileWriter(boolean bl) {
        this.stereo = bl;
    }

    public boolean isStereo() {
        return this.stereo;
    }

    public boolean openFile(String string) {
        this.fileValid = false;
        try {
            this.theFile = new File(string);
            if (this.theFile.exists()) {
                this.theFile.delete();
            }
            this.raFile = new RandomAccessFile(this.theFile, "rw");
            this.raFile.seek(44L);
            this.fileValid = true;
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void writeMonoSample(byte by, byte by2) {
        if (this.bufferPos + 1 >= this.buffer.length) {
            this.writeBuffer();
        }
        this.buffer[this.bufferPos] = by;
        this.buffer[this.bufferPos + 1] = by2;
        this.bufferPos += 2;
        ++this.sampleCount;
    }

    public void writeStereoSample(byte by, byte by2, byte by3, byte by4) {
        if (this.bufferPos + 3 >= this.buffer.length) {
            this.writeBuffer();
        }
        this.buffer[this.bufferPos] = by;
        this.buffer[this.bufferPos + 1] = by2;
        this.buffer[this.bufferPos + 2] = by3;
        this.buffer[this.bufferPos + 3] = by4;
        this.bufferPos += 4;
        ++this.sampleCount;
    }

    private void writeBuffer() {
        if (this.fileValid && this.bufferPos > 0) {
            try {
                this.raFile.write(this.buffer, 0, this.bufferPos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.bufferPos = 0;
    }

    public void writeHeader(int n, int n2, int n3) {
        this.writeBuffer();
        if (this.fileValid) {
            this.samplingFrequency = n;
            this.sampleBits = n2;
            this.channelCount = n3;
            try {
                this.raFile.seek(0L);
                this.raFile.write(this.makeHeader());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void closeFile() {
        if (this.fileValid) {
            this.writeBuffer();
            try {
                this.raFile.close();
                this.fileValid = false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public byte[] makeHeader() {
        ByteBuffer byteBuffer = new ByteBuffer(44, 1);
        byteBuffer.putCharAscii('R');
        byteBuffer.putCharAscii('I');
        byteBuffer.putCharAscii('F');
        byteBuffer.putCharAscii('F');
        byteBuffer.putInt(36 + this.channelCount * 2 * this.sampleCount);
        byteBuffer.putCharAscii('W');
        byteBuffer.putCharAscii('A');
        byteBuffer.putCharAscii('V');
        byteBuffer.putCharAscii('E');
        byteBuffer.putCharAscii('f');
        byteBuffer.putCharAscii('m');
        byteBuffer.putCharAscii('t');
        byteBuffer.putCharAscii(' ');
        byteBuffer.putInt(16);
        byteBuffer.putShort((short)1);
        byteBuffer.putShort((short)this.channelCount);
        byteBuffer.putInt(this.samplingFrequency);
        byteBuffer.putInt(this.samplingFrequency * (this.channelCount * 2));
        byteBuffer.putShort((short)(this.channelCount * 2));
        byteBuffer.putShort((short)this.sampleBits);
        byteBuffer.putCharAscii('d');
        byteBuffer.putCharAscii('a');
        byteBuffer.putCharAscii('t');
        byteBuffer.putCharAscii('a');
        byteBuffer.putInt(this.channelCount * this.sampleCount * 2);
        return byteBuffer.getBytes();
    }
}

