/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileWriter;

public class Tile {
    int[] pix;
    int fbIndex;
    int tIndex;
    int x;
    int y;
    int w;
    int h;
    int incX;
    int incY;
    int palIndex;
    int tpri;
    int c;
    public boolean initialized = false;
    public boolean[] opaque = new boolean[8];

    public Tile() {
        this.pix = new int[64];
    }

    public void setBuffer(short[] sArray) {
        this.y = 0;
        while (this.y < 8) {
            this.setScanline(this.y, sArray[this.y], sArray[this.y + 8]);
            ++this.y;
        }
    }

    public void setScanline(int n, short s, short s2) {
        this.initialized = true;
        this.tIndex = n << 3;
        this.x = 0;
        while (this.x < 8) {
            this.pix[this.tIndex + this.x] = (s >> 7 - this.x & 1) + ((s2 >> 7 - this.x & 1) << 1);
            if (this.pix[this.tIndex + this.x] == 0) {
                this.opaque[n] = false;
            }
            ++this.x;
        }
    }

    public void renderSimple(int n, int n2, int[] nArray, int n3, int[] nArray2) {
        this.tIndex = 0;
        this.fbIndex = (n2 << 8) + n;
        this.y = 8;
        while (this.y != 0) {
            this.x = 8;
            while (this.x != 0) {
                this.palIndex = this.pix[this.tIndex];
                if (this.palIndex != 0) {
                    nArray[this.fbIndex] = nArray2[this.palIndex + n3];
                }
                ++this.fbIndex;
                ++this.tIndex;
                --this.x;
            }
            this.fbIndex -= 8;
            this.fbIndex += 256;
            --this.y;
        }
    }

    public void renderSmall(int n, int n2, int[] nArray, int n3, int[] nArray2) {
        this.tIndex = 0;
        this.fbIndex = (n2 << 8) + n;
        this.y = 0;
        while (this.y < 4) {
            this.x = 0;
            while (this.x < 4) {
                this.c = nArray2[this.pix[this.tIndex] + n3] >> 2 & 0x3F3F3F;
                this.c += nArray2[this.pix[this.tIndex + 1] + n3] >> 2 & 0x3F3F3F;
                this.c += nArray2[this.pix[this.tIndex + 8] + n3] >> 2 & 0x3F3F3F;
                this.c += nArray2[this.pix[this.tIndex + 9] + n3] >> 2 & 0x3F3F3F;
                nArray[this.fbIndex] = this.c;
                ++this.fbIndex;
                this.tIndex += 2;
                ++this.x;
            }
            this.tIndex += 8;
            this.fbIndex += 252;
            ++this.y;
        }
    }

    public void render(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray, int n7, int[] nArray2, boolean bl, boolean bl2, int n8, int[] nArray3) {
        if (n5 < -7 || n5 >= 256 || n6 < -7 || n6 >= 240) {
            return;
        }
        this.w = n3 - n;
        this.h = n4 - n2;
        if (n5 < 0) {
            n -= n5;
        }
        if (n5 + n3 >= 256) {
            n3 = 256 - n5;
        }
        if (n6 < 0) {
            n2 -= n6;
        }
        if (n6 + n4 >= 240) {
            n4 = 240 - n6;
        }
        if (!bl && !bl2) {
            this.fbIndex = (n6 << 8) + n5;
            this.tIndex = 0;
            this.y = 0;
            while (this.y < 8) {
                this.x = 0;
                while (this.x < 8) {
                    if (this.x >= n && this.x < n3 && this.y >= n2 && this.y < n4) {
                        this.palIndex = this.pix[this.tIndex];
                        this.tpri = nArray3[this.fbIndex];
                        if (this.palIndex != 0 && n8 <= (this.tpri & 0xFF)) {
                            nArray[this.fbIndex] = nArray2[this.palIndex + n7];
                            nArray3[this.fbIndex] = this.tpri = this.tpri & 0xF00 | n8;
                        }
                    }
                    ++this.fbIndex;
                    ++this.tIndex;
                    ++this.x;
                }
                this.fbIndex -= 8;
                this.fbIndex += 256;
                ++this.y;
            }
        } else if (bl && !bl2) {
            this.fbIndex = (n6 << 8) + n5;
            this.tIndex = 7;
            this.y = 0;
            while (this.y < 8) {
                this.x = 0;
                while (this.x < 8) {
                    if (this.x >= n && this.x < n3 && this.y >= n2 && this.y < n4) {
                        this.palIndex = this.pix[this.tIndex];
                        this.tpri = nArray3[this.fbIndex];
                        if (this.palIndex != 0 && n8 <= (this.tpri & 0xFF)) {
                            nArray[this.fbIndex] = nArray2[this.palIndex + n7];
                            nArray3[this.fbIndex] = this.tpri = this.tpri & 0xF00 | n8;
                        }
                    }
                    ++this.fbIndex;
                    --this.tIndex;
                    ++this.x;
                }
                this.fbIndex -= 8;
                this.fbIndex += 256;
                this.tIndex += 16;
                ++this.y;
            }
        } else if (bl2 && !bl) {
            this.fbIndex = (n6 << 8) + n5;
            this.tIndex = 56;
            this.y = 0;
            while (this.y < 8) {
                this.x = 0;
                while (this.x < 8) {
                    if (this.x >= n && this.x < n3 && this.y >= n2 && this.y < n4) {
                        this.palIndex = this.pix[this.tIndex];
                        this.tpri = nArray3[this.fbIndex];
                        if (this.palIndex != 0 && n8 <= (this.tpri & 0xFF)) {
                            nArray[this.fbIndex] = nArray2[this.palIndex + n7];
                            nArray3[this.fbIndex] = this.tpri = this.tpri & 0xF00 | n8;
                        }
                    }
                    ++this.fbIndex;
                    ++this.tIndex;
                    ++this.x;
                }
                this.fbIndex -= 8;
                this.fbIndex += 256;
                this.tIndex -= 16;
                ++this.y;
            }
        } else {
            this.fbIndex = (n6 << 8) + n5;
            this.tIndex = 63;
            this.y = 0;
            while (this.y < 8) {
                this.x = 0;
                while (this.x < 8) {
                    if (this.x >= n && this.x < n3 && this.y >= n2 && this.y < n4) {
                        this.palIndex = this.pix[this.tIndex];
                        this.tpri = nArray3[this.fbIndex];
                        if (this.palIndex != 0 && n8 <= (this.tpri & 0xFF)) {
                            nArray[this.fbIndex] = nArray2[this.palIndex + n7];
                            nArray3[this.fbIndex] = this.tpri = this.tpri & 0xF00 | n8;
                        }
                    }
                    ++this.fbIndex;
                    --this.tIndex;
                    ++this.x;
                }
                this.fbIndex -= 8;
                this.fbIndex += 256;
                ++this.y;
            }
        }
    }

    public boolean isTransparent(int n, int n2) {
        return this.pix[(n2 << 3) + n] == 0;
    }

    public void dumpData(String string) {
        try {
            File file = new File(string);
            FileWriter fileWriter = new FileWriter(file);
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    fileWriter.write(Misc.hex8(this.pix[(i << 3) + j]).substring(1));
                }
                fileWriter.write("\r\n");
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stateSave(ByteBuffer byteBuffer) {
        int n;
        byteBuffer.putBoolean(this.initialized);
        for (n = 0; n < 8; ++n) {
            byteBuffer.putBoolean(this.opaque[n]);
        }
        for (n = 0; n < 64; ++n) {
            byteBuffer.putByte((byte)this.pix[n]);
        }
    }

    public void stateLoad(ByteBuffer byteBuffer) {
        int n;
        this.initialized = byteBuffer.readBoolean();
        for (n = 0; n < 8; ++n) {
            this.opaque[n] = byteBuffer.readBoolean();
        }
        for (n = 0; n < 64; ++n) {
            this.pix[n] = byteBuffer.readByte();
        }
    }
}

