/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class ScreenView
extends BufferView {
    private MyMouseAdapter mouse;
    private boolean notifyImageReady;
    private boolean fullScreenEnabled;

    public ScreenView(NES nES, int n, int n2) {
        super(nES, n, n2);
    }

    public void init() {
        if (this.mouse == null) {
            this.mouse = new MyMouseAdapter();
            this.addMouseListener(this.mouse);
        }
        this.fullScreenEnabled = true;
        super.init();
    }

    public void setNotifyImageReady(boolean bl) {
        this.notifyImageReady = bl;
    }

    public void enableFullScreen(boolean bl) {
        this.fullScreenEnabled = bl;
    }

    public void imageReady(boolean bl) {
        super.imageReady(bl);
        if (this.notifyImageReady) {
            this.nes.getGui().imageReady(bl);
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        long lastClickTime = 0L;

        private MyMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            ScreenView.this.setFocusable(true);
            ScreenView.this.requestFocus();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ScreenView.this.setFocusable(true);
            ScreenView.this.requestFocus();
            if (ScreenView.this.fullScreenEnabled && ScreenView.this.nes != null) {
                long l = System.currentTimeMillis();
                if (l - this.lastClickTime < 400L) {
                    ScreenView.this.nes.getGui().setFullScreen(true);
                }
                this.lastClickTime = l;
            }
            if (mouseEvent.getX() >= 0 && mouseEvent.getY() >= 0 && mouseEvent.getX() < 256 && mouseEvent.getY() < 240 && ScreenView.this.nes != null && ScreenView.this.nes.memMapper != null) {
                ScreenView.this.nes.memMapper.setMouseState(true, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (ScreenView.this.nes != null && ScreenView.this.nes.memMapper != null) {
                ScreenView.this.nes.memMapper.setMouseState(false, 0, 0);
            }
        }
    }
}

