/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RomInfoDlg
extends JDialog
implements ActionListener {
    NES nes;
    JLabel lblTitle;
    JLabel lbl_File;
    JLabel lbl_PrgRomCount;
    JLabel lbl_ChrRomCount;
    JLabel lbl_Mapper;
    JLabel lbl_Mirroring;
    JLabel lbl_BatteryRam;
    JLabel lbl_Trainer;
    JLabel lblFile;
    JLabel lblPrgRomCount;
    JLabel lblChrRomCount;
    JLabel lblMapper;
    JLabel lblMirroring;
    JLabel lblBatteryRam;
    JLabel lblTrainer;
    JPanel sepLine;
    JButton btnClose;

    public RomInfoDlg(NES nES) {
        this.setTitle("ROM Info");
        this.setModal(true);
        this.setSize(275, 340);
        this.initComponents();
    }

    private void initComponents() {
        Container container = this.getContentPane();
        container.setLayout(null);
        this.lblTitle = new JLabel("ROM Information");
        this.lblTitle.setFont(new Font("Arial", 1, 16));
        this.lblTitle.setBounds(68, 10, 150, 25);
        container.add(this.lblTitle);
        this.btnClose = new JButton("Close");
        this.btnClose.setBounds(80, 265, 100, 30);
        this.btnClose.addActionListener(this);
        container.add(this.btnClose);
        this.sepLine = new JPanel();
        this.sepLine.setSize(200, 1);
        this.sepLine.setBackground(Color.black);
        this.sepLine.setBounds(35, 38, 200, 1);
        container.add(this.sepLine);
        this.lbl_File = new JLabel("File name");
        this.lbl_PrgRomCount = new JLabel("PRG ROM Count");
        this.lbl_ChrRomCount = new JLabel("CHR Rom Count");
        this.lbl_Mapper = new JLabel("Mapper");
        this.lbl_Mirroring = new JLabel("Mirroring");
        this.lbl_BatteryRam = new JLabel("Battery RAM");
        this.lbl_Trainer = new JLabel("Trainer");
        this.lblFile = new JLabel();
        this.lblPrgRomCount = new JLabel();
        this.lblChrRomCount = new JLabel();
        this.lblMapper = new JLabel();
        this.lblMirroring = new JLabel();
        this.lblBatteryRam = new JLabel();
        this.lblTrainer = new JLabel();
        container.add(this.lblFile);
        container.add(this.lblPrgRomCount);
        container.add(this.lblChrRomCount);
        container.add(this.lblMapper);
        container.add(this.lblMirroring);
        container.add(this.lblBatteryRam);
        container.add(this.lblTrainer);
        container.add(this.lbl_File);
        container.add(this.lbl_PrgRomCount);
        container.add(this.lbl_ChrRomCount);
        container.add(this.lbl_Mapper);
        container.add(this.lbl_Mirroring);
        container.add(this.lbl_BatteryRam);
        container.add(this.lbl_Trainer);
        this.lblFile.setBounds(120, 45, 300, 25);
        this.lblMapper.setBounds(120, 75, 300, 25);
        this.lblPrgRomCount.setBounds(120, 105, 300, 25);
        this.lblChrRomCount.setBounds(120, 135, 300, 25);
        this.lblMirroring.setBounds(120, 165, 300, 25);
        this.lblBatteryRam.setBounds(120, 195, 300, 25);
        this.lblTrainer.setBounds(120, 225, 300, 25);
        this.lbl_File.setBounds(15, 45, 150, 25);
        this.lbl_Mapper.setBounds(15, 75, 150, 25);
        this.lbl_PrgRomCount.setBounds(15, 105, 150, 25);
        this.lbl_ChrRomCount.setBounds(15, 135, 150, 25);
        this.lbl_Mirroring.setBounds(15, 165, 150, 25);
        this.lbl_BatteryRam.setBounds(15, 195, 150, 25);
        this.lbl_Trainer.setBounds(15, 225, 150, 25);
        this.lbl_File.setForeground(Color.blue.darker());
        this.lbl_Mapper.setForeground(Color.blue.darker());
        this.lbl_PrgRomCount.setForeground(Color.blue.darker());
        this.lbl_ChrRomCount.setForeground(Color.blue.darker());
        this.lbl_Mirroring.setForeground(Color.blue.darker());
        this.lbl_BatteryRam.setForeground(Color.blue.darker());
        this.lbl_Trainer.setForeground(Color.blue.darker());
    }

    public void init(ROM rOM) {
        this.lblFile.setText(rOM.getFileName());
        this.lblMapper.setText(rOM.getMapperName());
        this.lblMapper.setForeground(rOM.mapperSupported() ? Color.green.darker() : Color.red.darker());
        this.lblPrgRomCount.setText("" + rOM.getRomBankCount());
        this.lblChrRomCount.setText("" + rOM.getVromBankCount());
        if (rOM.getMirroringType() == 3) {
            this.lblMirroring.setText("Single Screen");
        } else if (rOM.getMirroringType() == 0) {
            this.lblMirroring.setText("Vertical");
        } else if (rOM.getMirroringType() == 1) {
            this.lblMirroring.setText("Horizontal");
        } else if (rOM.getMirroringType() == 2) {
            this.lblMirroring.setText("Four Screen");
        } else if (rOM.getMirroringType() == 7) {
            this.lblMirroring.setText("CHR-ROM");
        } else {
            this.lblMirroring.setText("Unknown");
        }
        this.lblBatteryRam.setText(rOM.hasBatteryRam() ? "Yes" : "No");
        this.lblTrainer.setText(rOM.hasTrainer() ? "Yes" : "No");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public void destroy() {
        this.nes = null;
    }
}

