/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.RandomAccessFile;

public class ROM {
    public static final int VERTICAL_MIRRORING = 0;
    public static final int HORIZONTAL_MIRRORING = 1;
    public static final int FOURSCREEN_MIRRORING = 2;
    public static final int SINGLESCREEN_MIRRORING = 3;
    public static final int SINGLESCREEN_MIRRORING2 = 4;
    public static final int SINGLESCREEN_MIRRORING3 = 5;
    public static final int SINGLESCREEN_MIRRORING4 = 6;
    public static final int CHRROM_MIRRORING = 7;
    boolean failedSaveFile = false;
    boolean saveRamUpToDate = true;
    short[] header;
    short[][] rom;
    short[][] vrom;
    short[] saveRam;
    Tile[][] vromTile;
    NES nes;
    int romCount;
    int vromCount;
    int mirroring;
    boolean batteryRam;
    boolean trainer;
    boolean fourScreen;
    int mapperType;
    String fileName;
    RandomAccessFile raFile;
    boolean enableSave = true;
    boolean valid;
    static String[] mapperName = new String[92];
    static boolean[] mapperSupported = new boolean[92];

    public ROM(NES nES) {
        this.nes = nES;
        this.valid = false;
    }

    public void load(String string) {
        int n;
        int n2;
        int n3;
        this.fileName = string;
        FileLoader fileLoader = new FileLoader();
        short[] sArray = fileLoader.loadFile(string, this.nes.getGui());
        if (sArray == null || sArray.length == 0) {
            this.nes.gui.showErrorMsg("Unable to load ROM file.");
            this.valid = false;
        }
        this.header = new short[16];
        for (int i = 0; i < 16; ++i) {
            this.header[i] = sArray[i];
        }
        String string2 = new String(new byte[]{(byte)sArray[0], (byte)sArray[1], (byte)sArray[2], (byte)sArray[3]});
        if (!string2.equals("NES" + new String(new byte[]{26}))) {
            this.valid = false;
            return;
        }
        this.romCount = this.header[4];
        this.vromCount = this.header[5] * 2;
        this.mirroring = (this.header[6] & 1) != 0 ? 1 : 0;
        this.batteryRam = (this.header[6] & 2) != 0;
        this.trainer = (this.header[6] & 4) != 0;
        this.fourScreen = (this.header[6] & 8) != 0;
        this.mapperType = this.header[6] >> 4 | this.header[7] & 0xF0;
        if (this.batteryRam) {
            this.loadBatteryRam();
        }
        boolean bl = false;
        for (n3 = 8; n3 < 16; ++n3) {
            if (this.header[n3] == 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.mapperType &= 0xF;
        }
        this.rom = new short[this.romCount][16384];
        this.vrom = new short[this.vromCount][4096];
        this.vromTile = new Tile[this.vromCount][256];
        n3 = 16;
        for (n2 = 0; n2 < this.romCount; ++n2) {
            for (n = 0; n < 16384 && n3 + n < sArray.length; ++n) {
                this.rom[n2][n] = sArray[n3 + n];
            }
            n3 += 16384;
        }
        for (n2 = 0; n2 < this.vromCount; ++n2) {
            for (n = 0; n < 4096 && n3 + n < sArray.length; ++n) {
                this.vrom[n2][n] = sArray[n3 + n];
            }
            n3 += 4096;
        }
        for (n2 = 0; n2 < this.vromCount; ++n2) {
            for (n = 0; n < 256; ++n) {
                this.vromTile[n2][n] = new Tile();
            }
        }
        for (int i = 0; i < this.vromCount; ++i) {
            for (int j = 0; j < 4096; ++j) {
                n2 = j >> 4;
                n = j % 16;
                if (n < 8) {
                    this.vromTile[i][n2].setScanline(n, this.vrom[i][j], this.vrom[i][j + 8]);
                    continue;
                }
                this.vromTile[i][n2].setScanline(n - 8, this.vrom[i][j - 8], this.vrom[i][j]);
            }
        }
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getRomBankCount() {
        return this.romCount;
    }

    public int getVromBankCount() {
        return this.vromCount;
    }

    public short[] getHeader() {
        return this.header;
    }

    public short[] getRomBank(int n) {
        return this.rom[n];
    }

    public short[] getVromBank(int n) {
        return this.vrom[n];
    }

    public Tile[] getVromBankTiles(int n) {
        return this.vromTile[n];
    }

    public int getMirroringType() {
        if (this.fourScreen) {
            return 2;
        }
        if (this.mirroring == 0) {
            return 1;
        }
        return 0;
    }

    public int getMapperType() {
        return this.mapperType;
    }

    public String getMapperName() {
        if (this.mapperType >= 0 && this.mapperType < mapperName.length) {
            return mapperName[this.mapperType];
        }
        return "Unknown Mapper, " + this.mapperType;
    }

    public boolean hasBatteryRam() {
        return this.batteryRam;
    }

    public boolean hasTrainer() {
        return this.trainer;
    }

    public String getFileName() {
        File file = new File(this.fileName);
        return file.getName();
    }

    public boolean mapperSupported() {
        if (this.mapperType < mapperSupported.length && this.mapperType >= 0) {
            return mapperSupported[this.mapperType];
        }
        return false;
    }

    public MemoryMapper createMapper() {
        if (this.mapperSupported()) {
            switch (this.mapperType) {
                case 0: {
                    return new MapperDefault();
                }
                case 1: {
                    return new Mapper001();
                }
                case 2: {
                    return new Mapper002();
                }
                case 3: {
                    return new Mapper003();
                }
                case 4: {
                    return new Mapper004();
                }
                case 7: {
                    return new Mapper007();
                }
                case 9: {
                    return new Mapper009();
                }
                case 10: {
                    return new Mapper010();
                }
                case 11: {
                    return new Mapper011();
                }
                case 66: {
                    return new Mapper066();
                }
                case 68: {
                    return new Mapper068();
                }
                case 71: {
                    return new Mapper071();
                }
            }
        }
        this.nes.gui.showErrorMsg("Warning: Mapper not supported yet.");
        return new MapperDefault();
    }

    public void setSaveState(boolean bl) {
        if (bl && !this.batteryRam) {
            this.loadBatteryRam();
        }
    }

    public short[] getBatteryRam() {
        return this.saveRam;
    }

    private void loadBatteryRam() {
        Object object;
        try {
            object = new File("save/");
            if (!((File)object).exists()) {
                ((File)object).mkdir();
            }
        }
        catch (Exception exception) {
            return;
        }
        try {
            this.raFile = new RandomAccessFile("save/" + new File(this.fileName).getName() + ".sav", "rw");
            if (this.raFile.length() != 8192L) {
                this.raFile.setLength(8192L);
                this.saveRam = new short[8192];
            } else {
                object = new byte[8192];
                this.raFile.read((byte[])object);
                this.saveRam = new short[8192];
                for (int i = 0; i < 8192; ++i) {
                    this.saveRam[i] = (short)(object[i] & 0xFF);
                }
            }
            this.batteryRam = true;
            this.saveRamUpToDate = true;
            if (this.nes.getMemoryMapper() != null) {
                this.nes.getMemoryMapper().loadBatteryRam();
            }
            this.raFile.close();
        }
        catch (Exception exception) {
            this.failedSaveFile = true;
        }
    }

    public void writeBatteryRam(int n, short s) {
        if (!this.failedSaveFile && !this.batteryRam && this.enableSave) {
            this.loadBatteryRam();
        }
        if (this.batteryRam && this.enableSave && this.raFile != null) {
            this.saveRam[n - 24576] = s;
            this.saveRamUpToDate = false;
        }
    }

    public void closeRom() {
        if (this.batteryRam && !this.saveRamUpToDate) {
            try {
                this.raFile = new RandomAccessFile("save/" + new File(this.fileName).getName() + ".sav", "rw");
                byte[] byArray = new byte[8192];
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = (byte)this.saveRam[i];
                }
                this.raFile.setLength(8192L);
                this.raFile.seek(0L);
                this.raFile.write(byArray);
                this.raFile.close();
                this.saveRamUpToDate = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void destroy() {
        this.closeRom();
        this.nes = null;
    }

    static {
        for (int i = 0; i < 92; ++i) {
            ROM.mapperName[i] = "Unknown Mapper";
        }
        ROM.mapperName[0] = "Direct Access";
        ROM.mapperName[1] = "Nintendo MMC1";
        ROM.mapperName[2] = "UNROM";
        ROM.mapperName[3] = "CNROM";
        ROM.mapperName[4] = "Nintendo MMC3";
        ROM.mapperName[5] = "Nintendo MMC5";
        ROM.mapperName[6] = "FFE F4xxx";
        ROM.mapperName[7] = "AOROM";
        ROM.mapperName[8] = "FFE F3xxx";
        ROM.mapperName[9] = "Nintendo MMC2";
        ROM.mapperName[10] = "Nintendo MMC4";
        ROM.mapperName[11] = "Color Dreams Chip";
        ROM.mapperName[12] = "FFE F6xxx";
        ROM.mapperName[15] = "100-in-1 switch";
        ROM.mapperName[16] = "Bandai chip";
        ROM.mapperName[17] = "FFE F8xxx";
        ROM.mapperName[18] = "Jaleco SS8806 chip";
        ROM.mapperName[19] = "Namcot 106 chip";
        ROM.mapperName[20] = "Famicom Disk System";
        ROM.mapperName[21] = "Konami VRC4a";
        ROM.mapperName[22] = "Konami VRC2a";
        ROM.mapperName[23] = "Konami VRC2a";
        ROM.mapperName[24] = "Konami VRC6";
        ROM.mapperName[25] = "Konami VRC4b";
        ROM.mapperName[32] = "Irem G-101 chip";
        ROM.mapperName[33] = "Taito TC0190/TC0350";
        ROM.mapperName[34] = "32kB ROM switch";
        ROM.mapperName[64] = "Tengen RAMBO-1 chip";
        ROM.mapperName[65] = "Irem H-3001 chip";
        ROM.mapperName[66] = "GNROM switch";
        ROM.mapperName[67] = "SunSoft3 chip";
        ROM.mapperName[68] = "SunSoft4 chip";
        ROM.mapperName[69] = "SunSoft5 FME-7 chip";
        ROM.mapperName[71] = "Camerica chip";
        ROM.mapperName[78] = "Irem 74HC161/32-based";
        ROM.mapperName[91] = "Pirate HK-SF3 chip";
        ROM.mapperSupported[0] = true;
        ROM.mapperSupported[1] = true;
        ROM.mapperSupported[2] = true;
        ROM.mapperSupported[3] = true;
        ROM.mapperSupported[4] = true;
        ROM.mapperSupported[7] = true;
        ROM.mapperSupported[9] = true;
        ROM.mapperSupported[10] = true;
        ROM.mapperSupported[11] = true;
        ROM.mapperSupported[66] = true;
        ROM.mapperSupported[68] = true;
        ROM.mapperSupported[71] = true;
    }
}

