/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class PaletteTable {
    public static int[] curTable = new int[64];
    public static int[] origTable = new int[64];
    public static int[][] emphTable = new int[8][64];
    int currentEmph = -1;
    int currentHue;
    int currentSaturation;
    int currentLightness;
    int currentContrast;

    public boolean loadNTSCPalette() {
        return this.loadPalette("palettes/ntsc.txt");
    }

    public boolean loadPALPalette() {
        return this.loadPalette("palettes/pal.txt");
    }

    public boolean loadPalette(String string) {
        try {
            if (string.toLowerCase().endsWith("pal")) {
                int n;
                InputStream inputStream = this.getClass().getResourceAsStream(string);
                byte[] byArray = new byte[192];
                for (int i = 0; i < 64; i += inputStream.read(byArray, i, byArray.length - i)) {
                }
                int[] nArray = new int[192];
                for (n = 0; n < byArray.length; ++n) {
                    nArray[n] = byArray[n] & 0xFF;
                }
                for (n = 0; n < 64; ++n) {
                    int n2 = nArray[n * 3 + 0];
                    int n3 = nArray[n * 3 + 1];
                    int n4 = nArray[n * 3 + 2];
                    PaletteTable.origTable[n] = n2 | n3 << 8 | n4 << 16;
                }
            } else {
                InputStream inputStream = this.getClass().getResourceAsStream(string);
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string2 = bufferedReader.readLine();
                int n = 0;
                while (string2 != null) {
                    if (string2.startsWith("#")) {
                        String string3 = string2.substring(1, 3);
                        String string4 = string2.substring(3, 5);
                        String string5 = string2.substring(5, 7);
                        int n5 = Integer.decode("0x" + string3);
                        int n6 = Integer.decode("0x" + string4);
                        int n7 = Integer.decode("0x" + string5);
                        PaletteTable.origTable[n] = n5 | n6 << 8 | n7 << 16;
                        ++n;
                    }
                    string2 = bufferedReader.readLine();
                }
            }
            this.setEmphasis(0);
            this.makeTables();
            this.updatePalette();
            return true;
        }
        catch (Exception exception) {
            this.loadDefaultPalette();
            return false;
        }
    }

    public void makeTables() {
        for (int i = 0; i < 8; ++i) {
            float f = 1.0f;
            float f2 = 1.0f;
            float f3 = 1.0f;
            if ((i & 1) != 0) {
                f = 0.75f;
                f3 = 0.75f;
            }
            if ((i & 2) != 0) {
                f = 0.75f;
                f2 = 0.75f;
            }
            if ((i & 4) != 0) {
                f2 = 0.75f;
                f3 = 0.75f;
            }
            for (int j = 0; j < 64; ++j) {
                int n = origTable[j];
                int n2 = (int)((float)this.getRed(n) * f);
                int n3 = (int)((float)this.getGreen(n) * f2);
                int n4 = (int)((float)this.getBlue(n) * f3);
                PaletteTable.emphTable[i][j] = this.getRgb(n2, n3, n4);
            }
        }
    }

    public void setEmphasis(int n) {
        if (n != this.currentEmph) {
            this.currentEmph = n;
            for (int i = 0; i < 64; ++i) {
                PaletteTable.curTable[i] = emphTable[n][i];
            }
            this.updatePalette();
        }
    }

    public int getEntry(int n) {
        return curTable[n];
    }

    public int RGBtoHSL(int n, int n2, int n3) {
        float[] fArray = new float[3];
        fArray = Color.RGBtoHSB(n3, n2, n, fArray);
        fArray[0] = (float)((double)fArray[0] - Math.floor(fArray[0]));
        int n4 = 0;
        n4 |= (int)((double)fArray[0] * 255.0) << 16;
        n4 |= (int)((double)fArray[1] * 255.0) << 8;
        return n4 |= (int)((double)fArray[2] * 255.0);
    }

    public int RGBtoHSL(int n) {
        return this.RGBtoHSL(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    public int HSLtoRGB(int n, int n2, int n3) {
        return Color.HSBtoRGB((float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f);
    }

    public int HSLtoRGB(int n) {
        float f = (float)((double)(n >> 16 & 0xFF) / 255.0);
        float f2 = (float)((double)(n >> 8 & 0xFF) / 255.0);
        float f3 = (float)((double)(n & 0xFF) / 255.0);
        return Color.HSBtoRGB(f, f2, f3);
    }

    public int getHue(int n) {
        return n >> 16 & 0xFF;
    }

    public int getSaturation(int n) {
        return n >> 8 & 0xFF;
    }

    public int getLightness(int n) {
        return n & 0xFF;
    }

    public int getRed(int n) {
        return n >> 16 & 0xFF;
    }

    public int getGreen(int n) {
        return n >> 8 & 0xFF;
    }

    public int getBlue(int n) {
        return n & 0xFF;
    }

    public int getRgb(int n, int n2, int n3) {
        return n << 16 | n2 << 8 | n3;
    }

    public void updatePalette() {
        this.updatePalette(this.currentHue, this.currentSaturation, this.currentLightness, this.currentContrast);
    }

    public void updatePalette(int n, int n2, int n3, int n4) {
        if (n4 > 0) {
            n4 *= 4;
        }
        for (int i = 0; i < 64; ++i) {
            int n5 = this.RGBtoHSL(emphTable[this.currentEmph][i]);
            int n6 = this.getHue(n5) + n;
            int n7 = (int)((double)this.getSaturation(n5) * (1.0 + (double)((float)n2 / 256.0f)));
            int n8 = this.getLightness(n5);
            if (n6 < 0) {
                n6 += 255;
            }
            if (n7 < 0) {
                n7 = 0;
            }
            if (n8 < 0) {
                n8 = 0;
            }
            if (n6 > 255) {
                n6 -= 255;
            }
            if (n7 > 255) {
                n7 = 255;
            }
            if (n8 > 255) {
                n8 = 255;
            }
            int n9 = this.HSLtoRGB(n6, n7, n8);
            int n10 = this.getRed(n9);
            int n11 = this.getGreen(n9);
            int n12 = this.getBlue(n9);
            n10 = 128 + n3 + (int)((double)(n10 - 128) * (1.0 + (double)((float)n4 / 256.0f)));
            n11 = 128 + n3 + (int)((double)(n11 - 128) * (1.0 + (double)((float)n4 / 256.0f)));
            n12 = 128 + n3 + (int)((double)(n12 - 128) * (1.0 + (double)((float)n4 / 256.0f)));
            if (n10 < 0) {
                n10 = 0;
            }
            if (n11 < 0) {
                n11 = 0;
            }
            if (n12 < 0) {
                n12 = 0;
            }
            if (n10 > 255) {
                n10 = 255;
            }
            if (n11 > 255) {
                n11 = 255;
            }
            if (n12 > 255) {
                n12 = 255;
            }
            PaletteTable.curTable[i] = n9 = this.getRgb(n10, n11, n12);
        }
        this.currentHue = n;
        this.currentSaturation = n2;
        this.currentLightness = n3;
        this.currentContrast = n4;
    }

    public void loadDefaultPalette() {
        if (origTable == null) {
            origTable = new int[64];
        }
        PaletteTable.origTable[0] = this.getRgb(117, 117, 117);
        PaletteTable.origTable[1] = this.getRgb(39, 27, 143);
        PaletteTable.origTable[2] = this.getRgb(0, 0, 171);
        PaletteTable.origTable[3] = this.getRgb(71, 0, 159);
        PaletteTable.origTable[4] = this.getRgb(143, 0, 119);
        PaletteTable.origTable[5] = this.getRgb(171, 0, 19);
        PaletteTable.origTable[6] = this.getRgb(167, 0, 0);
        PaletteTable.origTable[7] = this.getRgb(127, 11, 0);
        PaletteTable.origTable[8] = this.getRgb(67, 47, 0);
        PaletteTable.origTable[9] = this.getRgb(0, 71, 0);
        PaletteTable.origTable[10] = this.getRgb(0, 81, 0);
        PaletteTable.origTable[11] = this.getRgb(0, 63, 23);
        PaletteTable.origTable[12] = this.getRgb(27, 63, 95);
        PaletteTable.origTable[13] = this.getRgb(0, 0, 0);
        PaletteTable.origTable[14] = this.getRgb(0, 0, 0);
        PaletteTable.origTable[15] = this.getRgb(0, 0, 0);
        PaletteTable.origTable[16] = this.getRgb(188, 188, 188);
        PaletteTable.origTable[17] = this.getRgb(0, 115, 239);
        PaletteTable.origTable[18] = this.getRgb(35, 59, 239);
        PaletteTable.origTable[19] = this.getRgb(131, 0, 243);
        PaletteTable.origTable[20] = this.getRgb(191, 0, 191);
        PaletteTable.origTable[21] = this.getRgb(231, 0, 91);
        PaletteTable.origTable[22] = this.getRgb(219, 43, 0);
        PaletteTable.origTable[23] = this.getRgb(203, 79, 15);
        PaletteTable.origTable[24] = this.getRgb(139, 115, 0);
        PaletteTable.origTable[25] = this.getRgb(0, 151, 0);
        PaletteTable.origTable[26] = this.getRgb(0, 171, 0);
        PaletteTable.origTable[27] = this.getRgb(0, 147, 59);
        PaletteTable.origTable[28] = this.getRgb(0, 131, 139);
        PaletteTable.origTable[29] = this.getRgb(0, 0, 0);
        PaletteTable.origTable[30] = this.getRgb(0, 0, 0);
        PaletteTable.origTable[31] = this.getRgb(0, 0, 0);
        PaletteTable.origTable[32] = this.getRgb(255, 255, 255);
        PaletteTable.origTable[33] = this.getRgb(63, 191, 255);
        PaletteTable.origTable[34] = this.getRgb(95, 151, 255);
        PaletteTable.origTable[35] = this.getRgb(167, 139, 253);
        PaletteTable.origTable[36] = this.getRgb(247, 123, 255);
        PaletteTable.origTable[37] = this.getRgb(255, 119, 183);
        PaletteTable.origTable[38] = this.getRgb(255, 119, 99);
        PaletteTable.origTable[39] = this.getRgb(255, 155, 59);
        PaletteTable.origTable[40] = this.getRgb(243, 191, 63);
        PaletteTable.origTable[41] = this.getRgb(131, 211, 19);
        PaletteTable.origTable[42] = this.getRgb(79, 223, 75);
        PaletteTable.origTable[43] = this.getRgb(88, 248, 152);
        PaletteTable.origTable[44] = this.getRgb(0, 235, 219);
        PaletteTable.origTable[45] = this.getRgb(0, 0, 0);
        PaletteTable.origTable[46] = this.getRgb(0, 0, 0);
        PaletteTable.origTable[47] = this.getRgb(0, 0, 0);
        PaletteTable.origTable[48] = this.getRgb(255, 255, 255);
        PaletteTable.origTable[49] = this.getRgb(171, 231, 255);
        PaletteTable.origTable[50] = this.getRgb(199, 215, 255);
        PaletteTable.origTable[51] = this.getRgb(215, 203, 255);
        PaletteTable.origTable[52] = this.getRgb(255, 199, 255);
        PaletteTable.origTable[53] = this.getRgb(255, 199, 219);
        PaletteTable.origTable[54] = this.getRgb(255, 191, 179);
        PaletteTable.origTable[55] = this.getRgb(255, 219, 171);
        PaletteTable.origTable[56] = this.getRgb(255, 231, 163);
        PaletteTable.origTable[57] = this.getRgb(227, 255, 163);
        PaletteTable.origTable[58] = this.getRgb(171, 243, 191);
        PaletteTable.origTable[59] = this.getRgb(179, 255, 207);
        PaletteTable.origTable[60] = this.getRgb(159, 255, 243);
        PaletteTable.origTable[61] = this.getRgb(0, 0, 0);
        PaletteTable.origTable[62] = this.getRgb(0, 0, 0);
        PaletteTable.origTable[63] = this.getRgb(0, 0, 0);
        this.setEmphasis(0);
        this.makeTables();
    }

    public void reset() {
        this.currentEmph = 0;
        this.currentHue = 0;
        this.currentSaturation = 0;
        this.currentLightness = 0;
        this.setEmphasis(0);
        this.updatePalette();
    }
}

