/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;

public class PPU {
    private NES nes;
    private HiResTimer timer;
    private Memory ppuMem;
    private Memory sprMem;
    boolean showSpr0Hit = false;
    boolean showSoundBuffer = false;
    boolean clipToTvSize = true;
    public int f_nmiOnVblank;
    public int f_spriteSize;
    public int f_bgPatternTable;
    public int f_spPatternTable;
    public int f_addrInc;
    public int f_nTblAddress;
    public int f_color;
    public int f_spVisibility;
    public int f_bgVisibility;
    public int f_spClipping;
    public int f_bgClipping;
    public int f_dispType;
    public int STATUS_VRAMWRITE = 4;
    public int STATUS_SLSPRITECOUNT = 5;
    public int STATUS_SPRITE0HIT = 6;
    public int STATUS_VBLANK = 7;
    int vramAddress;
    int vramTmpAddress;
    short vramBufferedReadValue;
    boolean firstWrite = true;
    int[] vramMirrorTable;
    int i;
    short sramAddress;
    int cntFV;
    int cntV;
    int cntH;
    int cntVT;
    int cntHT;
    int regFV;
    int regV;
    int regH;
    int regVT;
    int regHT;
    int regFH;
    int regS;
    int vblankAdd = 0;
    public int curX;
    public int scanline;
    public int lastRenderedScanline;
    public int mapperIrqCounter;
    public int[] sprX;
    public int[] sprY;
    public int[] sprTile;
    public int[] sprCol;
    public boolean[] vertFlip;
    public boolean[] horiFlip;
    public boolean[] bgPriority;
    public int spr0HitX;
    public int spr0HitY;
    boolean hitSpr0;
    public Tile[] ptTile;
    int[] ntable1 = new int[4];
    NameTable[] nameTable;
    int currentMirroring = -1;
    int[] sprPalette = new int[16];
    int[] imgPalette = new int[16];
    boolean scanlineAlreadyRendered;
    boolean requestEndFrame;
    boolean nmiOk;
    int nmiCounter;
    short tmp;
    boolean dummyCycleToggle;
    int address;
    int b1;
    int b2;
    int[] attrib = new int[32];
    int[] bgbuffer = new int[61440];
    int[] pixrendered = new int[61440];
    int[] spr0dummybuffer = new int[61440];
    int[] dummyPixPriTable = new int[61440];
    int[] oldFrame = new int[61440];
    int[] buffer;
    int[] tpix;
    boolean[] scanlineChanged = new boolean[240];
    boolean requestRenderAll = false;
    boolean validTileData;
    int att;
    Tile[] scantile = new Tile[32];
    Tile t;
    int curNt;
    int destIndex;
    int x;
    int y;
    int sx;
    int si;
    int ei;
    int tile;
    int col;
    int baseTile;
    int tscanoffset;
    int srcy1;
    int srcy2;
    int bufferSize;
    int available;
    int scale;
    public int cycles = 0;

    public PPU(NES nES) {
        this.nes = nES;
    }

    public void init() {
        int n;
        this.ppuMem = this.nes.getPpuMemory();
        this.sprMem = this.nes.getSprMemory();
        this.updateControlReg1(0);
        this.updateControlReg2(0);
        this.scanline = 0;
        this.timer = this.nes.getGui().getTimer();
        this.sprX = new int[64];
        this.sprY = new int[64];
        this.sprTile = new int[64];
        this.sprCol = new int[64];
        this.vertFlip = new boolean[64];
        this.horiFlip = new boolean[64];
        this.bgPriority = new boolean[64];
        if (this.ptTile == null) {
            this.ptTile = new Tile[512];
            for (n = 0; n < 512; ++n) {
                this.ptTile[n] = new Tile();
            }
        }
        this.nameTable = new NameTable[4];
        for (n = 0; n < 4; ++n) {
            this.nameTable[n] = new NameTable(32, 32, "Nt" + n);
        }
        this.vramMirrorTable = new int[32768];
        for (n = 0; n < 32768; ++n) {
            this.vramMirrorTable[n] = n;
        }
        this.lastRenderedScanline = -1;
        this.curX = 0;
        for (n = 0; n < this.oldFrame.length; ++n) {
            this.oldFrame[n] = -1;
        }
    }

    public void setMirroring(int n) {
        if (n == this.currentMirroring) {
            return;
        }
        this.currentMirroring = n;
        this.triggerRendering();
        if (this.vramMirrorTable == null) {
            this.vramMirrorTable = new int[32768];
        }
        for (int i = 0; i < 32768; ++i) {
            this.vramMirrorTable[i] = i;
        }
        this.defineMirrorRegion(16160, 16128, 32);
        this.defineMirrorRegion(16192, 16128, 32);
        this.defineMirrorRegion(16256, 16128, 32);
        this.defineMirrorRegion(16320, 16128, 32);
        this.defineMirrorRegion(12288, 8192, 3840);
        this.defineMirrorRegion(16384, 0, 16384);
        if (n == 1) {
            this.ntable1[0] = 0;
            this.ntable1[1] = 0;
            this.ntable1[2] = 1;
            this.ntable1[3] = 1;
            this.defineMirrorRegion(9216, 8192, 1024);
            this.defineMirrorRegion(11264, 10240, 1024);
        } else if (n == 0) {
            this.ntable1[0] = 0;
            this.ntable1[1] = 1;
            this.ntable1[2] = 0;
            this.ntable1[3] = 1;
            this.defineMirrorRegion(10240, 8192, 1024);
            this.defineMirrorRegion(11264, 9216, 1024);
        } else if (n == 3) {
            this.ntable1[0] = 0;
            this.ntable1[1] = 0;
            this.ntable1[2] = 0;
            this.ntable1[3] = 0;
            this.defineMirrorRegion(9216, 8192, 1024);
            this.defineMirrorRegion(10240, 8192, 1024);
            this.defineMirrorRegion(11264, 8192, 1024);
        } else if (n == 4) {
            this.ntable1[0] = 1;
            this.ntable1[1] = 1;
            this.ntable1[2] = 1;
            this.ntable1[3] = 1;
            this.defineMirrorRegion(9216, 9216, 1024);
            this.defineMirrorRegion(10240, 9216, 1024);
            this.defineMirrorRegion(11264, 9216, 1024);
        } else {
            this.ntable1[0] = 0;
            this.ntable1[1] = 1;
            this.ntable1[2] = 2;
            this.ntable1[3] = 3;
        }
    }

    private void defineMirrorRegion(int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            this.vramMirrorTable[n + i] = n2 + i;
        }
    }

    public void emulateCycles() {
        while (this.cycles > 0) {
            if (this.scanline - 21 == this.spr0HitY && this.curX == this.spr0HitX && this.f_spVisibility == 1) {
                this.setStatusFlag(this.STATUS_SPRITE0HIT, true);
            }
            if (this.requestEndFrame) {
                --this.nmiCounter;
                if (this.nmiCounter == 0) {
                    this.requestEndFrame = false;
                    this.startVBlank();
                }
            }
            ++this.curX;
            if (this.curX == 341) {
                this.curX = 0;
                this.endScanline();
            }
            --this.cycles;
        }
    }

    public void startVBlank() {
        this.nes.getCpu().requestIrq(1);
        if (this.lastRenderedScanline < 239 && !Globals.nsfMode) {
            this.renderFramePartially(this.nes.gui.getScreenView().getBuffer(), this.lastRenderedScanline + 1, 240 - this.lastRenderedScanline);
        }
        if (!Globals.guiIconified) {
            this.endFrame();
        }
        this.nes.getGui().getScreenView().imageReady(false);
        this.lastRenderedScanline = -1;
        if (!Globals.guiIconified || !Globals.nsfMode) {
            this.startFrame();
        }
        if (Globals.showPatterns) {
            this.renderPattern();
        }
        if (Globals.showPalettes) {
            this.renderPalettes();
        }
        if (Globals.showNameTables) {
            this.renderNameTables();
        }
    }

    public void endScanline() {
        if (this.scanline >= 19 + this.vblankAdd) {
            if (this.scanline == 19 + this.vblankAdd) {
                if (this.dummyCycleToggle) {
                    this.curX = 1;
                    this.dummyCycleToggle = !this.dummyCycleToggle;
                }
            } else if (this.scanline == 20 + this.vblankAdd) {
                this.setStatusFlag(this.STATUS_VBLANK, false);
                this.setStatusFlag(this.STATUS_SPRITE0HIT, false);
                this.hitSpr0 = false;
                this.spr0HitX = -1;
                this.spr0HitY = -1;
                if (this.f_bgVisibility == 1 || this.f_spVisibility == 1) {
                    this.cntFV = this.regFV;
                    this.cntV = this.regV;
                    this.cntH = this.regH;
                    this.cntVT = this.regVT;
                    this.cntHT = this.regHT;
                    if (this.f_bgVisibility == 1) {
                        this.renderBgScanline(this.buffer, 0);
                    }
                }
                if (this.f_bgVisibility == 1 && this.f_spVisibility == 1) {
                    this.checkSprite0(0);
                }
                if (this.f_bgVisibility == 1 || this.f_spVisibility == 1) {
                    this.nes.memMapper.clockIrqCounter();
                }
            } else if (this.scanline >= 21 + this.vblankAdd && this.scanline <= 260) {
                if (this.f_bgVisibility == 1) {
                    if (!this.scanlineAlreadyRendered) {
                        this.cntHT = this.regHT;
                        this.cntH = this.regH;
                        this.renderBgScanline(this.bgbuffer, this.scanline + 1 - 21);
                    }
                    this.scanlineAlreadyRendered = false;
                    if (!this.hitSpr0 && this.f_spVisibility == 1 && this.sprX[0] >= -7 && this.sprX[0] < 256 && this.sprY[0] + 1 <= this.scanline - this.vblankAdd + 1 - 21 && this.sprY[0] + 1 + (this.f_spriteSize == 0 ? 8 : 16) >= this.scanline - this.vblankAdd + 1 - 21 && this.checkSprite0(this.scanline + this.vblankAdd + 1 - 21)) {
                        this.hitSpr0 = true;
                    }
                }
                if (this.f_bgVisibility == 1 || this.f_spVisibility == 1) {
                    this.nes.memMapper.clockIrqCounter();
                }
            } else if (this.scanline == 261 + this.vblankAdd) {
                this.setStatusFlag(this.STATUS_VBLANK, true);
                this.requestEndFrame = true;
                this.nmiCounter = 9;
                this.scanline = -1;
            }
        }
        ++this.scanline;
        this.regsToAddress();
        this.cntsToAddress();
    }

    public void startFrame() {
        int[] nArray = this.nes.getGui().getScreenView().getBuffer();
        int n = 0;
        if (this.f_dispType == 0) {
            n = this.imgPalette[0];
        } else {
            switch (this.f_color) {
                case 0: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = 65280;
                }
                case 2: {
                    n = 0xFF0000;
                }
                case 3: {
                    n = 0;
                }
                case 4: {
                    n = 255;
                }
                default: {
                    n = 0;
                }
            }
        }
        if (!Globals.nsfMode) {
            int n2;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = n;
            }
            for (n2 = 0; n2 < this.pixrendered.length; ++n2) {
                this.pixrendered[n2] = 65;
            }
        }
    }

    public void endFrame() {
        int n;
        int n2;
        int[] nArray = this.nes.getGui().getScreenView().getBuffer();
        if (this.showSpr0Hit) {
            if (this.sprX[0] >= 0 && this.sprX[0] < 256 && this.sprY[0] >= 0 && this.sprY[0] < 240) {
                for (n2 = 0; n2 < 256; ++n2) {
                    nArray[(this.sprY[0] << 8) + n2] = 0xFF5555;
                }
                for (n2 = 0; n2 < 240; ++n2) {
                    nArray[(n2 << 8) + this.sprX[0]] = 0xFF5555;
                }
            }
            if (this.spr0HitX >= 0 && this.spr0HitX < 256 && this.spr0HitY >= 0 && this.spr0HitY < 240) {
                for (n2 = 0; n2 < 256; ++n2) {
                    nArray[(this.spr0HitY << 8) + n2] = 0x55FF55;
                }
                for (n2 = 0; n2 < 240; ++n2) {
                    nArray[(n2 << 8) + this.spr0HitX] = 0x55FF55;
                }
            }
        }
        if (Globals.nsfMode && !Globals.guiIconified) {
            NsfVisualization.drawVisualization((int[])nArray, (PAPU)this.nes.papu, (int)0xFFFF55, (int)64);
            this.y = 0;
            while (this.y < 240) {
                this.scanlineChanged[this.y] = true;
                ++this.y;
            }
        }
        if (this.clipToTvSize || this.f_bgClipping == 0 || this.f_spClipping == 0) {
            for (n2 = 0; n2 < 240; ++n2) {
                for (n = 0; n < 8; ++n) {
                    nArray[(n2 << 8) + n] = 0;
                }
            }
        }
        if (this.clipToTvSize) {
            for (n2 = 0; n2 < 240; ++n2) {
                for (n = 0; n < 8; ++n) {
                    nArray[(n2 << 8) + 255 - n] = 0;
                }
            }
        }
        if (this.clipToTvSize) {
            for (n2 = 0; n2 < 8; ++n2) {
                for (n = 0; n < 256; ++n) {
                    nArray[(n2 << 8) + n] = 0;
                    nArray[(239 - n2 << 8) + n] = 0;
                }
            }
        }
        if (this.showSoundBuffer && this.nes.getPapu().getLine() != null) {
            this.bufferSize = this.nes.getPapu().getLine().getBufferSize();
            this.available = this.nes.getPapu().getLine().available();
            this.scale = this.bufferSize / 256;
            for (n2 = 0; n2 < 4; ++n2) {
                this.scanlineChanged[n2] = true;
                for (n = 0; n < 256; ++n) {
                    nArray[n2 * 256 + n] = n >= this.available / this.scale ? 0xFFFFFF : 0;
                }
            }
        }
    }

    public void updateControlReg1(int n) {
        this.triggerRendering();
        this.f_nmiOnVblank = n >> 7 & 1;
        this.f_spriteSize = n >> 5 & 1;
        this.f_bgPatternTable = n >> 4 & 1;
        this.f_spPatternTable = n >> 3 & 1;
        this.f_addrInc = n >> 2 & 1;
        this.f_nTblAddress = n & 3;
        this.regV = n >> 1 & 1;
        this.regH = n & 1;
        this.regS = n >> 4 & 1;
    }

    public void updateControlReg2(int n) {
        this.triggerRendering();
        this.f_color = n >> 5 & 7;
        this.f_spVisibility = n >> 4 & 1;
        this.f_bgVisibility = n >> 3 & 1;
        this.f_spClipping = n >> 2 & 1;
        this.f_bgClipping = n >> 1 & 1;
        this.f_dispType = n & 1;
        if (this.f_dispType == 0) {
            this.nes.palTable.setEmphasis(this.f_color);
        }
        this.updatePalettes();
    }

    public void setStatusFlag(int n, boolean bl) {
        int n2 = 1 << n;
        int n3 = this.nes.getCpuMemory().load(8194);
        n3 = n3 & 255 - n2 | (bl ? n2 : 0);
        this.nes.getCpuMemory().write(8194, (short)n3);
    }

    public short readStatusRegister() {
        this.tmp = this.nes.getCpuMemory().load(8194);
        this.firstWrite = true;
        this.setStatusFlag(this.STATUS_VBLANK, false);
        return this.tmp;
    }

    public void writeSRAMAddress(short s) {
        this.sramAddress = s;
    }

    public short sramLoad() {
        short s = this.sprMem.load(this.sramAddress);
        return s;
    }

    public void sramWrite(short s) {
        this.sprMem.write(this.sramAddress, s);
        this.spriteRamWriteUpdate(this.sramAddress, s);
        this.sramAddress = (short)(this.sramAddress + 1);
        this.sramAddress = (short)(this.sramAddress % 256);
    }

    public void scrollWrite(short s) {
        this.triggerRendering();
        if (this.firstWrite) {
            this.regHT = s >> 3 & 0x1F;
            this.regFH = s & 7;
        } else {
            this.regFV = s & 7;
            this.regVT = s >> 3 & 0x1F;
        }
        this.firstWrite = !this.firstWrite;
    }

    public void writeVRAMAddress(int n) {
        if (this.firstWrite) {
            this.regFV = n >> 4 & 3;
            this.regV = n >> 3 & 1;
            this.regH = n >> 2 & 1;
            this.regVT = this.regVT & 7 | (n & 3) << 3;
        } else {
            this.triggerRendering();
            this.regVT = this.regVT & 0x18 | n >> 5 & 7;
            this.regHT = n & 0x1F;
            this.cntFV = this.regFV;
            this.cntV = this.regV;
            this.cntH = this.regH;
            this.cntVT = this.regVT;
            this.cntHT = this.regHT;
            this.checkSprite0(this.scanline - this.vblankAdd + 1 - 21);
        }
        this.firstWrite = !this.firstWrite;
        this.cntsToAddress();
        if (this.vramAddress < 8192) {
            this.nes.memMapper.latchAccess(this.vramAddress);
        }
    }

    public short vramLoad() {
        this.cntsToAddress();
        this.regsToAddress();
        if (this.vramAddress <= 16127) {
            short s = this.vramBufferedReadValue;
            this.vramBufferedReadValue = this.vramAddress < 8192 ? this.ppuMem.load(this.vramAddress) : this.mirroredLoad(this.vramAddress);
            if (this.vramAddress < 8192) {
                this.nes.memMapper.latchAccess(this.vramAddress);
            }
            this.vramAddress += this.f_addrInc == 1 ? 32 : 1;
            this.cntsFromAddress();
            this.regsFromAddress();
            return s;
        }
        short s = this.mirroredLoad(this.vramAddress);
        this.vramAddress += this.f_addrInc == 1 ? 32 : 1;
        this.cntsFromAddress();
        this.regsFromAddress();
        return s;
    }

    public void vramWrite(short s) {
        this.triggerRendering();
        this.cntsToAddress();
        this.regsToAddress();
        if (this.vramAddress >= 8192) {
            this.mirroredWrite(this.vramAddress, s);
        } else {
            this.writeMem(this.vramAddress, s);
            this.nes.memMapper.latchAccess(this.vramAddress);
        }
        this.vramAddress += this.f_addrInc == 1 ? 32 : 1;
        this.regsFromAddress();
        this.cntsFromAddress();
    }

    public void sramDMA(short s) {
        Memory memory = this.nes.getCpuMemory();
        int n = s * 256;
        for (int i = this.sramAddress; i < 256; ++i) {
            short s2 = memory.load(n + i);
            this.sprMem.write(i, s2);
            this.spriteRamWriteUpdate(i, s2);
        }
        this.nes.getCpu().haltCycles(513);
    }

    private void regsFromAddress() {
        this.address = this.vramTmpAddress >> 8 & 0xFF;
        this.regFV = this.address >> 4 & 7;
        this.regV = this.address >> 3 & 1;
        this.regH = this.address >> 2 & 1;
        this.regVT = this.regVT & 7 | (this.address & 3) << 3;
        this.address = this.vramTmpAddress & 0xFF;
        this.regVT = this.regVT & 0x18 | this.address >> 5 & 7;
        this.regHT = this.address & 0x1F;
    }

    private void cntsFromAddress() {
        this.address = this.vramAddress >> 8 & 0xFF;
        this.cntFV = this.address >> 4 & 3;
        this.cntV = this.address >> 3 & 1;
        this.cntH = this.address >> 2 & 1;
        this.cntVT = this.cntVT & 7 | (this.address & 3) << 3;
        this.address = this.vramAddress & 0xFF;
        this.cntVT = this.cntVT & 0x18 | this.address >> 5 & 7;
        this.cntHT = this.address & 0x1F;
    }

    private void regsToAddress() {
        this.b1 = (this.regFV & 7) << 4;
        this.b1 |= (this.regV & 1) << 3;
        this.b1 |= (this.regH & 1) << 2;
        this.b1 |= this.regVT >> 3 & 3;
        this.b2 = (this.regVT & 7) << 5;
        this.b2 |= this.regHT & 0x1F;
        this.vramTmpAddress = (this.b1 << 8 | this.b2) & Short.MAX_VALUE;
    }

    private void cntsToAddress() {
        this.b1 = (this.cntFV & 7) << 4;
        this.b1 |= (this.cntV & 1) << 3;
        this.b1 |= (this.cntH & 1) << 2;
        this.b1 |= this.cntVT >> 3 & 3;
        this.b2 = (this.cntVT & 7) << 5;
        this.b2 |= this.cntHT & 0x1F;
        this.vramAddress = (this.b1 << 8 | this.b2) & Short.MAX_VALUE;
    }

    private void incTileCounter(int n) {
        this.i = n;
        while (this.i != 0) {
            ++this.cntHT;
            if (this.cntHT == 32) {
                this.cntHT = 0;
                ++this.cntVT;
                if (this.cntVT >= 30) {
                    ++this.cntH;
                    if (this.cntH == 2) {
                        this.cntH = 0;
                        ++this.cntV;
                        if (this.cntV == 2) {
                            this.cntV = 0;
                            ++this.cntFV;
                            this.cntFV &= 7;
                        }
                    }
                }
            }
            --this.i;
        }
    }

    private short mirroredLoad(int n) {
        return this.ppuMem.load(this.vramMirrorTable[n]);
    }

    private void mirroredWrite(int n, short s) {
        if (n >= 16128 && n < 16160) {
            if (n == 16128 || n == 16144) {
                this.writeMem(16128, s);
                this.writeMem(16144, s);
            } else if (n == 16132 || n == 16148) {
                this.writeMem(16132, s);
                this.writeMem(16148, s);
            } else if (n == 16136 || n == 16152) {
                this.writeMem(16136, s);
                this.writeMem(16152, s);
            } else if (n == 16140 || n == 16156) {
                this.writeMem(16140, s);
                this.writeMem(16156, s);
            } else {
                this.writeMem(n, s);
            }
        } else if (n < this.vramMirrorTable.length) {
            this.writeMem(this.vramMirrorTable[n], s);
        }
    }

    public void triggerRendering() {
        if (this.scanline - this.vblankAdd >= 21 && this.scanline - this.vblankAdd <= 260) {
            this.renderFramePartially(this.buffer, this.lastRenderedScanline + 1, this.scanline - this.vblankAdd - 21 - this.lastRenderedScanline);
            this.lastRenderedScanline = this.scanline - this.vblankAdd - 21;
        }
    }

    private void renderFramePartially(int[] nArray, int n, int n2) {
        BufferView bufferView;
        if (this.f_spVisibility == 1 && !Globals.disableSprites) {
            this.renderSpritesPartially(n, n2, true);
        }
        if (this.f_bgVisibility == 1) {
            this.si = n << 8;
            this.ei = n + n2 << 8;
            if (this.ei > 61440) {
                this.ei = 61440;
            }
            this.destIndex = this.si;
            while (this.destIndex < this.ei) {
                if (this.pixrendered[this.destIndex] > 255) {
                    nArray[this.destIndex] = this.bgbuffer[this.destIndex];
                }
                ++this.destIndex;
            }
        }
        if (this.f_spVisibility == 1 && !Globals.disableSprites) {
            this.renderSpritesPartially(n, n2, false);
        }
        if ((bufferView = this.nes.getGui().getScreenView()).scalingEnabled() && !bufferView.useHWScaling() && !this.requestRenderAll) {
            if (n + n2 > 240) {
                n2 = 240 - n;
            }
            for (int i = n; i < n + n2; ++i) {
                int n3;
                this.scanlineChanged[i] = false;
                this.si = i << 8;
                int n4 = this.si + 256;
                for (n3 = this.si; n3 < n4; ++n3) {
                    if (nArray[n3] != this.oldFrame[n3]) {
                        this.scanlineChanged[i] = true;
                        break;
                    }
                    this.oldFrame[n3] = nArray[n3];
                }
                System.arraycopy(nArray, n3, this.oldFrame, n3, n4 - n3);
            }
        }
        this.validTileData = false;
    }

    private void renderBgScanline(int[] nArray, int n) {
        this.baseTile = this.regS == 0 ? 0 : 256;
        this.destIndex = (n << 8) - this.regFH;
        this.curNt = this.ntable1[this.cntV + this.cntV + this.cntH];
        this.cntHT = this.regHT;
        this.cntH = this.regH;
        this.curNt = this.ntable1[this.cntV + this.cntV + this.cntH];
        if (n < 240 && n - this.cntFV >= 0) {
            this.tscanoffset = this.cntFV << 3;
            this.y = n - this.cntFV;
            this.tile = 0;
            while (this.tile < 32) {
                if (n >= 0) {
                    if (this.validTileData) {
                        this.t = this.scantile[this.tile];
                        this.tpix = this.t.pix;
                        this.att = this.attrib[this.tile];
                    } else {
                        this.t = this.ptTile[this.baseTile + this.nameTable[this.curNt].getTileIndex(this.cntHT, this.cntVT)];
                        this.tpix = this.t.pix;
                        this.att = this.nameTable[this.curNt].getAttrib(this.cntHT, this.cntVT);
                        this.scantile[this.tile] = this.t;
                        this.attrib[this.tile] = this.att;
                    }
                    this.sx = 0;
                    this.x = (this.tile << 3) - this.regFH;
                    if (this.x > -8) {
                        if (this.x < 0) {
                            this.destIndex -= this.x;
                            this.sx = -this.x;
                        }
                        if (this.t.opaque[this.cntFV]) {
                            while (this.sx < 8) {
                                nArray[this.destIndex] = this.imgPalette[this.tpix[this.tscanoffset + this.sx] + this.att];
                                int n2 = this.destIndex++;
                                this.pixrendered[n2] = this.pixrendered[n2] | 0x100;
                                ++this.sx;
                            }
                        } else {
                            while (this.sx < 8) {
                                this.col = this.tpix[this.tscanoffset + this.sx];
                                if (this.col != 0) {
                                    nArray[this.destIndex] = this.imgPalette[this.col + this.att];
                                    int n3 = this.destIndex;
                                    this.pixrendered[n3] = this.pixrendered[n3] | 0x100;
                                }
                                ++this.destIndex;
                                ++this.sx;
                            }
                        }
                    }
                }
                ++this.cntHT;
                if (this.cntHT == 32) {
                    this.cntHT = 0;
                    ++this.cntH;
                    this.cntH %= 2;
                    this.curNt = this.ntable1[(this.cntV << 1) + this.cntH];
                }
                ++this.tile;
            }
            this.validTileData = true;
        }
        ++this.cntFV;
        if (this.cntFV == 8) {
            this.cntFV = 0;
            ++this.cntVT;
            if (this.cntVT == 30) {
                this.cntVT = 0;
                ++this.cntV;
                this.cntV %= 2;
                this.curNt = this.ntable1[(this.cntV << 1) + this.cntH];
            } else if (this.cntVT == 32) {
                this.cntVT = 0;
            }
            this.validTileData = false;
        }
    }

    private void renderSpritesPartially(int n, int n2, boolean bl) {
        this.buffer = this.nes.getGui().getScreenView().getBuffer();
        if (this.f_spVisibility == 1) {
            for (int i = 0; i < 64; ++i) {
                if (this.bgPriority[i] != bl || this.sprX[i] < 0 || this.sprX[i] >= 256 || this.sprY[i] + 8 < n || this.sprY[i] >= n + n2) continue;
                if (this.f_spriteSize == 0) {
                    this.srcy1 = 0;
                    this.srcy2 = 8;
                    if (this.sprY[i] < n) {
                        this.srcy1 = n - this.sprY[i] - 1;
                    }
                    if (this.sprY[i] + 8 > n + n2) {
                        this.srcy2 = n + n2 - this.sprY[i] + 1;
                    }
                    if (this.f_spPatternTable == 0) {
                        this.ptTile[this.sprTile[i]].render(0, this.srcy1, 8, this.srcy2, this.sprX[i], this.sprY[i] + 1, this.buffer, this.sprCol[i], this.sprPalette, this.horiFlip[i], this.vertFlip[i], i, this.pixrendered);
                        continue;
                    }
                    this.ptTile[this.sprTile[i] + 256].render(0, this.srcy1, 8, this.srcy2, this.sprX[i], this.sprY[i] + 1, this.buffer, this.sprCol[i], this.sprPalette, this.horiFlip[i], this.vertFlip[i], i, this.pixrendered);
                    continue;
                }
                int n3 = this.sprTile[i];
                if ((n3 & 1) != 0) {
                    n3 = this.sprTile[i] - 1 + 256;
                }
                this.srcy1 = 0;
                this.srcy2 = 8;
                if (this.sprY[i] < n) {
                    this.srcy1 = n - this.sprY[i] - 1;
                }
                if (this.sprY[i] + 8 > n + n2) {
                    this.srcy2 = n + n2 - this.sprY[i];
                }
                this.ptTile[n3 + (this.vertFlip[i] ? 1 : 0)].render(0, this.srcy1, 8, this.srcy2, this.sprX[i], this.sprY[i] + 1, this.buffer, this.sprCol[i], this.sprPalette, this.horiFlip[i], this.vertFlip[i], i, this.pixrendered);
                this.srcy1 = 0;
                this.srcy2 = 8;
                if (this.sprY[i] + 8 < n) {
                    this.srcy1 = n - (this.sprY[i] + 8 + 1);
                }
                if (this.sprY[i] + 16 > n + n2) {
                    this.srcy2 = n + n2 - (this.sprY[i] + 8);
                }
                this.ptTile[n3 + (this.vertFlip[i] ? 0 : 1)].render(0, this.srcy1, 8, this.srcy2, this.sprX[i], this.sprY[i] + 1 + 8, this.buffer, this.sprCol[i], this.sprPalette, this.horiFlip[i], this.vertFlip[i], i, this.pixrendered);
            }
        }
    }

    private boolean checkSprite0(int n) {
        block16: {
            int n2;
            int n3;
            block15: {
                this.spr0HitX = -1;
                this.spr0HitY = -1;
                int n4 = this.f_spPatternTable == 0 ? 0 : 256;
                n3 = this.sprX[0];
                n2 = this.sprY[0] + 1;
                if (this.f_spriteSize != 0) break block15;
                if (n2 > n || n2 + 8 <= n || n3 < -7 || n3 >= 256) break block16;
                Tile tile = this.ptTile[this.sprTile[0] + n4];
                int n5 = this.sprCol[0];
                boolean bl = this.bgPriority[0];
                int n6 = this.vertFlip[0] ? 7 - (n - n2) : n - n2;
                n6 *= 8;
                int n7 = n * 256 + n3;
                if (this.horiFlip[0]) {
                    for (int i = 7; i >= 0; --i) {
                        if (n3 >= 0 && n3 < 256 && n7 >= 0 && n7 < 61440 && this.pixrendered[n7] != 0 && tile.pix[n6 + i] != 0) {
                            this.spr0HitX = n7 % 256;
                            this.spr0HitY = n;
                            return true;
                        }
                        ++n3;
                        ++n7;
                    }
                } else {
                    for (int i = 0; i < 8; ++i) {
                        if (n3 >= 0 && n3 < 256 && n7 >= 0 && n7 < 61440 && this.pixrendered[n7] != 0 && tile.pix[n6 + i] != 0) {
                            this.spr0HitX = n7 % 256;
                            this.spr0HitY = n;
                            return true;
                        }
                        ++n3;
                        ++n7;
                    }
                }
                break block16;
            }
            if (n2 <= n && n2 + 16 > n && n3 >= -7 && n3 < 256) {
                Tile tile;
                int n8 = this.vertFlip[0] ? 15 - (n - n2) : n - n2;
                if (n8 < 8) {
                    tile = this.ptTile[this.sprTile[0] + (this.vertFlip[0] ? 1 : 0) + ((this.sprTile[0] & 1) != 0 ? 255 : 0)];
                } else {
                    tile = this.ptTile[this.sprTile[0] + (this.vertFlip[0] ? 0 : 1) + ((this.sprTile[0] & 1) != 0 ? 255 : 0)];
                    n8 = this.vertFlip[0] ? 15 - n8 : (n8 -= 8);
                }
                n8 *= 8;
                int n9 = this.sprCol[0];
                boolean bl = this.bgPriority[0];
                int n10 = n * 256 + n3;
                if (this.horiFlip[0]) {
                    for (int i = 7; i >= 0; --i) {
                        if (n3 >= 0 && n3 < 256 && n10 >= 0 && n10 < 61440 && this.pixrendered[n10] != 0 && tile.pix[n8 + i] != 0) {
                            this.spr0HitX = n10 % 256;
                            this.spr0HitY = n;
                            return true;
                        }
                        ++n3;
                        ++n10;
                    }
                } else {
                    for (int i = 0; i < 8; ++i) {
                        if (n3 >= 0 && n3 < 256 && n10 >= 0 && n10 < 61440 && this.pixrendered[n10] != 0 && tile.pix[n8 + i] != 0) {
                            this.spr0HitX = n10 % 256;
                            this.spr0HitY = n;
                            return true;
                        }
                        ++n3;
                        ++n10;
                    }
                }
            }
        }
        return false;
    }

    public void renderPattern() {
        BufferView bufferView = this.nes.getGui().getPatternView();
        int[] nArray = bufferView.getBuffer();
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    this.ptTile[n].renderSimple(i * 128 + k * 8, j * 8, nArray, 0, this.sprPalette);
                    ++n;
                }
            }
        }
        this.nes.getGui().getPatternView().imageReady(false);
    }

    public void renderNameTables() {
        int n;
        int n2;
        int[] nArray = this.nes.getGui().getNameTableView().getBuffer();
        this.baseTile = this.f_bgPatternTable == 0 ? 0 : 256;
        int n3 = 2;
        int n4 = 2;
        if (this.currentMirroring == 1) {
            n3 = 1;
        } else if (this.currentMirroring == 0) {
            n4 = 1;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                int n5 = this.ntable1[n2 * 2 + n];
                int n6 = n * 128;
                int n7 = n2 * 120;
                for (int i = 0; i < 30; ++i) {
                    for (int j = 0; j < 32; ++j) {
                        this.ptTile[this.baseTile + this.nameTable[n5].getTileIndex(j, i)].renderSmall(n6 + j * 4, n7 + i * 4, nArray, this.nameTable[n5].getAttrib(j, i), this.imgPalette);
                    }
                }
            }
        }
        if (this.currentMirroring == 1) {
            for (n2 = 0; n2 < 240; ++n2) {
                for (n = 0; n < 128; ++n) {
                    nArray[(n2 << 8) + 128 + n] = nArray[(n2 << 8) + n];
                }
            }
        } else if (this.currentMirroring == 0) {
            for (n2 = 0; n2 < 120; ++n2) {
                for (n = 0; n < 256; ++n) {
                    nArray[(n2 << 8) + 30720 + n] = nArray[(n2 << 8) + n];
                }
            }
        }
        this.nes.getGui().getNameTableView().imageReady(false);
    }

    private void renderPalettes() {
        int n;
        int n2;
        int n3;
        int[] nArray = this.nes.getGui().getImgPalView().getBuffer();
        for (n3 = 0; n3 < 16; ++n3) {
            for (n2 = 0; n2 < 16; ++n2) {
                for (n = 0; n < 16; ++n) {
                    nArray[n2 * 256 + n3 * 16 + n] = this.imgPalette[n3];
                }
            }
        }
        nArray = this.nes.getGui().getSprPalView().getBuffer();
        for (n3 = 0; n3 < 16; ++n3) {
            for (n2 = 0; n2 < 16; ++n2) {
                for (n = 0; n < 16; ++n) {
                    nArray[n2 * 256 + n3 * 16 + n] = this.sprPalette[n3];
                }
            }
        }
        this.nes.getGui().getImgPalView().imageReady(false);
        this.nes.getGui().getSprPalView().imageReady(false);
    }

    private void writeMem(int n, short s) {
        this.ppuMem.write(n, s);
        if (n < 8192) {
            this.ppuMem.write(n, s);
            this.patternWrite(n, s);
        } else if (n >= 8192 && n < 9152) {
            this.nameTableWrite(this.ntable1[0], n - 8192, s);
        } else if (n >= 9152 && n < 9216) {
            this.attribTableWrite(this.ntable1[0], n - 9152, s);
        } else if (n >= 9216 && n < 10176) {
            this.nameTableWrite(this.ntable1[1], n - 9216, s);
        } else if (n >= 10176 && n < 10240) {
            this.attribTableWrite(this.ntable1[1], n - 10176, s);
        } else if (n >= 10240 && n < 11200) {
            this.nameTableWrite(this.ntable1[2], n - 10240, s);
        } else if (n >= 11200 && n < 11264) {
            this.attribTableWrite(this.ntable1[2], n - 11200, s);
        } else if (n >= 11264 && n < 12224) {
            this.nameTableWrite(this.ntable1[3], n - 11264, s);
        } else if (n >= 12224 && n < 12288) {
            this.attribTableWrite(this.ntable1[3], n - 12224, s);
        } else if (n >= 16128 && n < 16160) {
            this.updatePalettes();
        }
    }

    public void updatePalettes() {
        int n;
        for (n = 0; n < 16; ++n) {
            this.imgPalette[n] = this.f_dispType == 0 ? this.nes.palTable.getEntry(this.ppuMem.load(16128 + n) & 0x3F) : this.nes.palTable.getEntry(this.ppuMem.load(16128 + n) & 0x20);
        }
        for (n = 0; n < 16; ++n) {
            this.sprPalette[n] = this.f_dispType == 0 ? this.nes.palTable.getEntry(this.ppuMem.load(16144 + n) & 0x3F) : this.nes.palTable.getEntry(this.ppuMem.load(16144 + n) & 0x20);
        }
    }

    public void patternWrite(int n, short s) {
        int n2 = n / 16;
        int n3 = n % 16;
        if (n3 < 8) {
            this.ptTile[n2].setScanline(n3, s, this.ppuMem.load(n + 8));
        } else {
            this.ptTile[n2].setScanline(n3 - 8, this.ppuMem.load(n - 8), s);
        }
    }

    public void patternWrite(int n, short[] sArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            int n4 = n + i >> 4;
            int n5 = (n + i) % 16;
            if (n5 < 8) {
                this.ptTile[n4].setScanline(n5, sArray[n2 + i], this.ppuMem.load(n + 8 + i));
                continue;
            }
            this.ptTile[n4].setScanline(n5 - 8, this.ppuMem.load(n - 8 + i), sArray[n2 + i]);
        }
    }

    public void invalidateFrameCache() {
        for (int i = 0; i < 240; ++i) {
            this.scanlineChanged[i] = true;
        }
        Arrays.fill(this.oldFrame, -1);
        this.requestRenderAll = true;
    }

    public void nameTableWrite(int n, int n2, short s) {
        this.nameTable[n].writeTileIndex(n2, s);
        this.checkSprite0(this.scanline + 1 - this.vblankAdd - 21);
    }

    public void attribTableWrite(int n, int n2, short s) {
        this.nameTable[n].writeAttrib(n2, s);
    }

    public void spriteRamWriteUpdate(int n, short s) {
        int n2 = n / 4;
        if (n2 == 0) {
            this.checkSprite0(this.scanline + 1 - this.vblankAdd - 21);
        }
        if (n % 4 == 0) {
            this.sprY[n2] = s;
        } else if (n % 4 == 1) {
            this.sprTile[n2] = s;
        } else if (n % 4 == 2) {
            this.vertFlip[n2] = (s & 0x80) != 0;
            this.horiFlip[n2] = (s & 0x40) != 0;
            this.bgPriority[n2] = (s & 0x20) != 0;
            this.sprCol[n2] = (s & 3) << 2;
        } else if (n % 4 == 3) {
            this.sprX[n2] = s;
        }
    }

    public void doNMI() {
        this.setStatusFlag(this.STATUS_VBLANK, true);
        this.nes.getCpu().requestIrq(1);
    }

    public int statusRegsToInt() {
        int n = 0;
        n = this.f_nmiOnVblank | this.f_spriteSize << 1 | this.f_bgPatternTable << 2 | this.f_spPatternTable << 3 | this.f_addrInc << 4 | this.f_nTblAddress << 5 | this.f_color << 6 | this.f_spVisibility << 7 | this.f_bgVisibility << 8 | this.f_spClipping << 9 | this.f_bgClipping << 10 | this.f_dispType << 11;
        return n;
    }

    public void statusRegsFromInt(int n) {
        this.f_nmiOnVblank = n & 1;
        this.f_spriteSize = n >> 1 & 1;
        this.f_bgPatternTable = n >> 2 & 1;
        this.f_spPatternTable = n >> 3 & 1;
        this.f_addrInc = n >> 4 & 1;
        this.f_nTblAddress = n >> 5 & 1;
        this.f_color = n >> 6 & 1;
        this.f_spVisibility = n >> 7 & 1;
        this.f_bgVisibility = n >> 8 & 1;
        this.f_spClipping = n >> 9 & 1;
        this.f_bgClipping = n >> 10 & 1;
        this.f_dispType = n >> 11 & 1;
    }

    public void stateLoad(ByteBuffer byteBuffer) {
        if (byteBuffer.readByte() == 1) {
            int n;
            this.cntFV = byteBuffer.readInt();
            this.cntV = byteBuffer.readInt();
            this.cntH = byteBuffer.readInt();
            this.cntVT = byteBuffer.readInt();
            this.cntHT = byteBuffer.readInt();
            this.regFV = byteBuffer.readInt();
            this.regV = byteBuffer.readInt();
            this.regH = byteBuffer.readInt();
            this.regVT = byteBuffer.readInt();
            this.regHT = byteBuffer.readInt();
            this.regFH = byteBuffer.readInt();
            this.regS = byteBuffer.readInt();
            this.vramAddress = byteBuffer.readInt();
            this.vramTmpAddress = byteBuffer.readInt();
            this.statusRegsFromInt(byteBuffer.readInt());
            this.vramBufferedReadValue = (short)byteBuffer.readInt();
            this.firstWrite = byteBuffer.readBoolean();
            for (n = 0; n < this.vramMirrorTable.length; ++n) {
                this.vramMirrorTable[n] = byteBuffer.readInt();
            }
            this.sramAddress = (short)byteBuffer.readInt();
            this.curX = byteBuffer.readInt();
            this.scanline = byteBuffer.readInt();
            this.lastRenderedScanline = byteBuffer.readInt();
            this.requestEndFrame = byteBuffer.readBoolean();
            this.nmiOk = byteBuffer.readBoolean();
            this.dummyCycleToggle = byteBuffer.readBoolean();
            this.nmiCounter = byteBuffer.readInt();
            this.tmp = (short)byteBuffer.readInt();
            for (n = 0; n < this.bgbuffer.length; ++n) {
                this.bgbuffer[n] = byteBuffer.readByte();
            }
            for (n = 0; n < this.pixrendered.length; ++n) {
                this.pixrendered[n] = byteBuffer.readByte();
            }
            for (n = 0; n < 4; ++n) {
                this.ntable1[n] = byteBuffer.readByte();
                this.nameTable[n].stateLoad(byteBuffer);
            }
            for (n = 0; n < this.ptTile.length; ++n) {
                this.ptTile[n].stateLoad(byteBuffer);
            }
            short[] sArray = this.nes.getSprMemory().mem;
            for (int i = 0; i < sArray.length; ++i) {
                this.spriteRamWriteUpdate(i, sArray[i]);
            }
        }
    }

    public void stateSave(ByteBuffer byteBuffer) {
        int n;
        byteBuffer.putByte((short)1);
        byteBuffer.putInt(this.cntFV);
        byteBuffer.putInt(this.cntV);
        byteBuffer.putInt(this.cntH);
        byteBuffer.putInt(this.cntVT);
        byteBuffer.putInt(this.cntHT);
        byteBuffer.putInt(this.regFV);
        byteBuffer.putInt(this.regV);
        byteBuffer.putInt(this.regH);
        byteBuffer.putInt(this.regVT);
        byteBuffer.putInt(this.regHT);
        byteBuffer.putInt(this.regFH);
        byteBuffer.putInt(this.regS);
        byteBuffer.putInt(this.vramAddress);
        byteBuffer.putInt(this.vramTmpAddress);
        byteBuffer.putInt(this.statusRegsToInt());
        byteBuffer.putInt(this.vramBufferedReadValue);
        byteBuffer.putBoolean(this.firstWrite);
        for (n = 0; n < this.vramMirrorTable.length; ++n) {
            byteBuffer.putInt(this.vramMirrorTable[n]);
        }
        byteBuffer.putInt(this.sramAddress);
        byteBuffer.putInt(this.curX);
        byteBuffer.putInt(this.scanline);
        byteBuffer.putInt(this.lastRenderedScanline);
        byteBuffer.putBoolean(this.requestEndFrame);
        byteBuffer.putBoolean(this.nmiOk);
        byteBuffer.putBoolean(this.dummyCycleToggle);
        byteBuffer.putInt(this.nmiCounter);
        byteBuffer.putInt(this.tmp);
        for (n = 0; n < this.bgbuffer.length; ++n) {
            byteBuffer.putByte((short)this.bgbuffer[n]);
        }
        for (n = 0; n < this.pixrendered.length; ++n) {
            byteBuffer.putByte((short)this.pixrendered[n]);
        }
        for (n = 0; n < 4; ++n) {
            byteBuffer.putByte((short)this.ntable1[n]);
            this.nameTable[n].stateSave(byteBuffer);
        }
        for (n = 0; n < this.ptTile.length; ++n) {
            this.ptTile[n].stateSave(byteBuffer);
        }
    }

    public void reset() {
        this.ppuMem.reset();
        this.sprMem.reset();
        this.vramBufferedReadValue = 0;
        this.sramAddress = 0;
        this.curX = 0;
        this.scanline = 0;
        this.lastRenderedScanline = 0;
        this.spr0HitX = 0;
        this.spr0HitY = 0;
        this.mapperIrqCounter = 0;
        this.currentMirroring = -1;
        this.firstWrite = true;
        this.requestEndFrame = false;
        this.nmiOk = false;
        this.hitSpr0 = false;
        this.dummyCycleToggle = false;
        this.validTileData = false;
        this.nmiCounter = 0;
        this.tmp = 0;
        this.att = 0;
        this.i = 0;
        this.f_nmiOnVblank = 0;
        this.f_spriteSize = 0;
        this.f_bgPatternTable = 0;
        this.f_spPatternTable = 0;
        this.f_addrInc = 0;
        this.f_nTblAddress = 0;
        this.f_color = 0;
        this.f_spVisibility = 0;
        this.f_bgVisibility = 0;
        this.f_spClipping = 0;
        this.f_bgClipping = 0;
        this.f_dispType = 0;
        this.cntFV = 0;
        this.cntV = 0;
        this.cntH = 0;
        this.cntVT = 0;
        this.cntHT = 0;
        this.regFV = 0;
        this.regV = 0;
        this.regH = 0;
        this.regVT = 0;
        this.regHT = 0;
        this.regFH = 0;
        this.regS = 0;
        Arrays.fill(this.scanlineChanged, true);
        Arrays.fill(this.oldFrame, -1);
        this.init();
    }

    public void destroy() {
        this.nes = null;
        this.ppuMem = null;
        this.sprMem = null;
        this.scantile = null;
    }
}

