/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public final class PAPU {
    NES nes;
    Memory cpuMem;
    WaveFileWriter fileOut;
    Mixer mixer;
    SourceDataLine line;
    ChannelSquare square1;
    ChannelSquare square2;
    ChannelTriangle triangle;
    ChannelNoise noise;
    ChannelDM dmc;
    int[] lengthLookup;
    int[] dmcFreqLookup;
    int[] noiseWavelengthLookup;
    int[] square_table;
    int[] tnd_table;
    int[] ismpbuffer;
    byte[] sampleBuffer;
    int frameIrqCounter;
    int frameIrqCounterMax;
    int initCounter;
    short channelEnableValue;
    byte b1;
    byte b2;
    byte b3;
    byte b4;
    int bufferSize = 2048;
    int bufferIndex;
    int sampleRate = 44100;
    boolean frameIrqEnabled;
    boolean frameIrqActive;
    boolean frameClockNow;
    boolean startedPlaying = false;
    boolean recordOutput = false;
    boolean stereo = true;
    boolean initingHardware = false;
    private boolean userEnableSquare1 = true;
    private boolean userEnableSquare2 = true;
    private boolean userEnableTriangle = true;
    private boolean userEnableNoise = true;
    public boolean userEnableDmc = true;
    int masterFrameCounter;
    int derivedFrameCounter;
    int countSequence;
    int sampleTimer;
    int frameTime;
    int sampleTimerMax;
    int sampleCount;
    int sampleValueL;
    int sampleValueR;
    int triValue = 0;
    int smpSquare1;
    int smpSquare2;
    int smpTriangle;
    int smpNoise;
    int smpDmc;
    int accCount;
    int sq_index;
    int tnd_index;
    int prevSampleL = 0;
    int prevSampleR = 0;
    int smpAccumL = 0;
    int smpAccumR = 0;
    int smpDiffL = 0;
    int smpDiffR = 0;
    int dacRange = 0;
    int dcValue = 0;
    int masterVolume;
    int[] panning;
    int stereoPosLSquare1;
    int stereoPosLSquare2;
    int stereoPosLTriangle;
    int stereoPosLNoise;
    int stereoPosLDMC;
    int stereoPosRSquare1;
    int stereoPosRSquare2;
    int stereoPosRTriangle;
    int stereoPosRNoise;
    int stereoPosRDMC;
    int extraCycles;
    int maxCycles;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public PAPU(NES nES) {
        this.nes = nES;
        this.cpuMem = nES.getCpuMemory();
        this.setSampleRate(this.sampleRate, false);
        this.sampleBuffer = new byte[this.bufferSize * (this.stereo ? 4 : 2)];
        this.ismpbuffer = new int[this.bufferSize * (this.stereo ? 2 : 1)];
        this.bufferIndex = 0;
        this.frameIrqEnabled = false;
        this.initCounter = 2048;
        this.square1 = new ChannelSquare(this, true);
        this.square2 = new ChannelSquare(this, false);
        this.triangle = new ChannelTriangle(this);
        this.noise = new ChannelNoise(this);
        this.dmc = new ChannelDM(this);
        this.masterVolume = 256;
        this.panning = new int[]{80, 170, 100, 150, 128};
        this.setPanning(this.panning);
        this.initLengthLookup();
        this.initDmcFrequencyLookup();
        this.initNoiseWavelengthLookup();
        this.initDACtables();
        this.frameIrqEnabled = false;
        this.frameIrqCounterMax = 4;
    }

    public boolean startRecording(File file) {
        this.fileOut = new WaveFileWriter(this.stereo);
        if (this.fileOut.openFile(file.getPath())) {
            this.recordOutput = true;
            return true;
        }
        this.recordOutput = false;
        return false;
    }

    public void stopRecording() {
        this.fileOut.writeHeader(this.sampleRate, 16, this.stereo ? 2 : 1);
        this.fileOut.closeFile();
        this.fileOut = null;
        this.recordOutput = false;
    }

    public void stateLoad(ByteBuffer byteBuffer) {
    }

    public void stateSave(ByteBuffer byteBuffer) {
    }

    public synchronized void start() {
        if (this.line != null && this.line.isActive()) {
            return;
        }
        this.bufferIndex = 0;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        if (infoArray == null || infoArray.length == 0) {
            if (!Globals.appletMode) {
                GUI gUI = (GUI)this.nes.gui;
            }
            Globals.enableSound = false;
            return;
        }
        this.mixer = AudioSystem.getMixer(infoArray[1]);
        AudioFormat audioFormat = new AudioFormat(this.sampleRate, 16, this.stereo ? 2 : 1, true, false);
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = PAPU.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat, this.sampleRate);
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(audioFormat);
            this.line.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public NES getNes() {
        return this.nes;
    }

    public short readReg(int n) {
        int n2 = 0;
        n2 |= this.square1.getLengthStatus();
        n2 |= this.square2.getLengthStatus() << 1;
        n2 |= this.triangle.getLengthStatus() << 2;
        n2 |= this.noise.getLengthStatus() << 3;
        n2 |= this.dmc.getLengthStatus() << 4;
        n2 |= (this.frameIrqActive && this.frameIrqEnabled ? 1 : 0) << 6;
        this.frameIrqActive = false;
        this.dmc.irqGenerated = false;
        return (short)(n2 |= this.dmc.getIrqStatus() << 7);
    }

    public void writeReg(int n, short s) {
        if (n >= 16384 && n < 16388) {
            this.square1.writeReg(n, s);
        } else if (n >= 16388 && n < 16392) {
            this.square2.writeReg(n, s);
        } else if (n >= 16392 && n < 16396) {
            this.triangle.writeReg(n, s);
        } else if (n >= 16396 && n <= 16399) {
            this.noise.writeReg(n, s);
        } else if (n == 16400) {
            this.dmc.writeReg(n, s);
        } else if (n == 16401) {
            this.dmc.writeReg(n, s);
        } else if (n == 16402) {
            this.dmc.writeReg(n, s);
        } else if (n == 16403) {
            this.dmc.writeReg(n, s);
        } else if (n == 16405) {
            this.updateChannelEnable(s);
            if (s != 0 && this.initCounter > 0) {
                this.initingHardware = true;
            }
            this.dmc.writeReg(n, s);
        } else if (n == 16407) {
            this.countSequence = s >> 7 & 1;
            this.masterFrameCounter = 0;
            this.frameIrqActive = false;
            this.frameIrqEnabled = (s >> 6 & 1) == 0;
            if (this.countSequence == 0) {
                this.frameIrqCounterMax = 4;
                this.derivedFrameCounter = 4;
            } else {
                this.frameIrqCounterMax = 5;
                this.derivedFrameCounter = 0;
                this.frameCounterTick();
            }
        }
    }

    public void resetCounter() {
        this.derivedFrameCounter = this.countSequence == 0 ? 4 : 0;
    }

    public void updateChannelEnable(int n) {
        this.channelEnableValue = (short)n;
        this.square1.setEnabled(this.userEnableSquare1 && (n & 1) != 0);
        this.square2.setEnabled(this.userEnableSquare2 && (n & 2) != 0);
        this.triangle.setEnabled(this.userEnableTriangle && (n & 4) != 0);
        this.noise.setEnabled(this.userEnableNoise && (n & 8) != 0);
        this.dmc.setEnabled(this.userEnableDmc && (n & 0x10) != 0);
    }

    public void clockFrameCounter(int n) {
        int n2;
        if (this.initCounter > 0 && this.initingHardware) {
            this.initCounter -= n;
            if (this.initCounter <= 0) {
                this.initingHardware = false;
            }
            return;
        }
        this.maxCycles = this.sampleTimerMax - this.sampleTimer;
        if ((n += this.extraCycles) << 10 > this.maxCycles) {
            this.extraCycles = (n << 10) - this.maxCycles >> 10;
            n -= this.extraCycles;
        } else {
            this.extraCycles = 0;
        }
        if (this.dmc.isEnabled) {
            this.dmc.shiftCounter -= n << 3;
            while (this.dmc.shiftCounter <= 0 && this.dmc.dmaFrequency > 0) {
                this.dmc.shiftCounter += this.dmc.dmaFrequency;
                this.dmc.clockDmc();
            }
        }
        if (this.triangle.progTimerMax > 0) {
            this.triangle.progTimerCount -= n;
            while (this.triangle.progTimerCount <= 0) {
                this.triangle.progTimerCount += this.triangle.progTimerMax + 1;
                if (this.triangle.linearCounter <= 0 || this.triangle.lengthCounter <= 0) continue;
                ++this.triangle.triangleCounter;
                this.triangle.triangleCounter &= 0x1F;
                if (!this.triangle.isEnabled) continue;
                this.triangle.sampleValue = this.triangle.triangleCounter >= 16 ? this.triangle.triangleCounter & 0xF : 15 - (this.triangle.triangleCounter & 0xF);
                this.triangle.sampleValue <<= 4;
            }
        }
        this.square1.progTimerCount -= n;
        if (this.square1.progTimerCount <= 0) {
            this.square1.progTimerCount += this.square1.progTimerMax + 1 << 1;
            ++this.square1.squareCounter;
            this.square1.squareCounter &= 7;
            this.square1.updateSampleValue();
        }
        this.square2.progTimerCount -= n;
        if (this.square2.progTimerCount <= 0) {
            this.square2.progTimerCount += this.square2.progTimerMax + 1 << 1;
            ++this.square2.squareCounter;
            this.square2.squareCounter &= 7;
            this.square2.updateSampleValue();
        }
        if (this.noise.progTimerCount - (n2 = n) > 0) {
            this.noise.progTimerCount -= n2;
            this.noise.accCount += (long)n2;
            this.noise.accValue += (long)(n2 * this.noise.sampleValue);
        } else {
            while (n2-- > 0) {
                if (--this.noise.progTimerCount <= 0 && this.noise.progTimerMax > 0) {
                    this.noise.shiftReg <<= 1;
                    this.noise.tmp = (this.noise.shiftReg << (this.noise.randomMode == 0 ? 1 : 6) ^ this.noise.shiftReg) & 0x8000;
                    if (this.noise.tmp != 0) {
                        this.noise.shiftReg |= 1;
                        this.noise.randomBit = 0;
                        this.noise.sampleValue = 0;
                    } else {
                        this.noise.randomBit = 1;
                        this.noise.sampleValue = this.noise.isEnabled && this.noise.lengthCounter > 0 ? this.noise.masterVolume : 0;
                    }
                    this.noise.progTimerCount += this.noise.progTimerMax;
                }
                this.noise.accValue += (long)this.noise.sampleValue;
                ++this.noise.accCount;
            }
        }
        if (this.frameIrqEnabled && this.frameIrqActive) {
            this.nes.cpu.requestIrq(0);
        }
        this.masterFrameCounter += n << 1;
        if (this.masterFrameCounter >= this.frameTime) {
            this.masterFrameCounter -= this.frameTime;
            this.frameCounterTick();
        }
        this.accSample(n);
        this.sampleTimer += n << 10;
        if (this.sampleTimer >= this.sampleTimerMax) {
            this.sample();
            this.sampleTimer -= this.sampleTimerMax;
        }
    }

    private void accSample(int n) {
        if (this.triangle.sampleCondition) {
            this.triValue = (this.triangle.progTimerCount << 4) / (this.triangle.progTimerMax + 1);
            if (this.triValue > 16) {
                this.triValue = 16;
            }
            if (this.triangle.triangleCounter >= 16) {
                this.triValue = 16 - this.triValue;
            }
            this.triValue += this.triangle.sampleValue;
        }
        if (n == 2) {
            this.smpTriangle += this.triValue << 1;
            this.smpDmc += this.dmc.sample << 1;
            this.smpSquare1 += this.square1.sampleValue << 1;
            this.smpSquare2 += this.square2.sampleValue << 1;
            this.accCount += 2;
        } else if (n == 4) {
            this.smpTriangle += this.triValue << 2;
            this.smpDmc += this.dmc.sample << 2;
            this.smpSquare1 += this.square1.sampleValue << 2;
            this.smpSquare2 += this.square2.sampleValue << 2;
            this.accCount += 4;
        } else {
            this.smpTriangle += n * this.triValue;
            this.smpDmc += n * this.dmc.sample;
            this.smpSquare1 += n * this.square1.sampleValue;
            this.smpSquare2 += n * this.square2.sampleValue;
            this.accCount += n;
        }
    }

    public void frameCounterTick() {
        ++this.derivedFrameCounter;
        if (this.derivedFrameCounter >= this.frameIrqCounterMax) {
            this.derivedFrameCounter = 0;
        }
        if (this.derivedFrameCounter == 1 || this.derivedFrameCounter == 3) {
            this.triangle.clockLengthCounter();
            this.square1.clockLengthCounter();
            this.square2.clockLengthCounter();
            this.noise.clockLengthCounter();
            this.square1.clockSweep();
            this.square2.clockSweep();
        }
        if (this.derivedFrameCounter >= 0 && this.derivedFrameCounter < 4) {
            this.square1.clockEnvDecay();
            this.square2.clockEnvDecay();
            this.noise.clockEnvDecay();
            this.triangle.clockLinearCounter();
        }
        if (this.derivedFrameCounter == 3 && this.countSequence == 0) {
            this.frameIrqActive = true;
        }
    }

    public void sample() {
        if (this.accCount > 0) {
            this.smpSquare1 <<= 4;
            this.smpSquare1 /= this.accCount;
            this.smpSquare2 <<= 4;
            this.smpSquare2 /= this.accCount;
            this.smpTriangle /= this.accCount;
            this.smpDmc <<= 4;
            this.smpDmc /= this.accCount;
            this.accCount = 0;
        } else {
            this.smpSquare1 = this.square1.sampleValue << 4;
            this.smpSquare2 = this.square2.sampleValue << 4;
            this.smpTriangle = this.triangle.sampleValue;
            this.smpDmc = this.dmc.sample << 4;
        }
        this.smpNoise = (int)((this.noise.accValue << 4) / this.noise.accCount);
        this.noise.accValue = this.smpNoise >> 4;
        this.noise.accCount = 1L;
        if (this.stereo) {
            this.sq_index = this.smpSquare1 * this.stereoPosLSquare1 + this.smpSquare2 * this.stereoPosLSquare2 >> 8;
            this.tnd_index = 3 * this.smpTriangle * this.stereoPosLTriangle + (this.smpNoise << 1) * this.stereoPosLNoise + this.smpDmc * this.stereoPosLDMC >> 8;
            if (this.sq_index >= this.square_table.length) {
                this.sq_index = this.square_table.length - 1;
            }
            if (this.tnd_index >= this.tnd_table.length) {
                this.tnd_index = this.tnd_table.length - 1;
            }
            this.sampleValueL = this.square_table[this.sq_index] + this.tnd_table[this.tnd_index] - this.dcValue;
            this.sq_index = this.smpSquare1 * this.stereoPosRSquare1 + this.smpSquare2 * this.stereoPosRSquare2 >> 8;
            this.tnd_index = 3 * this.smpTriangle * this.stereoPosRTriangle + (this.smpNoise << 1) * this.stereoPosRNoise + this.smpDmc * this.stereoPosRDMC >> 8;
            if (this.sq_index >= this.square_table.length) {
                this.sq_index = this.square_table.length - 1;
            }
            if (this.tnd_index >= this.tnd_table.length) {
                this.tnd_index = this.tnd_table.length - 1;
            }
            this.sampleValueR = this.square_table[this.sq_index] + this.tnd_table[this.tnd_index] - this.dcValue;
        } else {
            this.sq_index = this.smpSquare1 + this.smpSquare2;
            this.tnd_index = 3 * this.smpTriangle + 2 * this.smpNoise + this.smpDmc;
            if (this.sq_index >= this.square_table.length) {
                this.sq_index = this.square_table.length - 1;
            }
            if (this.tnd_index >= this.tnd_table.length) {
                this.tnd_index = this.tnd_table.length - 1;
            }
            this.sampleValueL = 3 * (this.square_table[this.sq_index] + this.tnd_table[this.tnd_index] - this.dcValue);
            this.sampleValueL >>= 2;
        }
        this.smpDiffL = this.sampleValueL - this.prevSampleL;
        this.prevSampleL += this.smpDiffL;
        this.smpAccumL += this.smpDiffL - (this.smpAccumL >> 10);
        this.sampleValueL = this.smpAccumL;
        if (this.stereo) {
            this.smpDiffR = this.sampleValueR - this.prevSampleR;
            this.prevSampleR += this.smpDiffR;
            this.smpAccumR += this.smpDiffR - (this.smpAccumR >> 10);
            this.sampleValueR = this.smpAccumR;
            if (this.bufferIndex + 4 < this.sampleBuffer.length) {
                if (Globals.nsfMode) {
                    this.ismpbuffer[this.bufferIndex >> 1] = this.sampleValueL;
                    this.ismpbuffer[(this.bufferIndex >> 1) + 1] = this.sampleValueR;
                }
                this.sampleBuffer[this.bufferIndex++] = (byte)(this.sampleValueL & 0xFF);
                this.sampleBuffer[this.bufferIndex++] = (byte)(this.sampleValueL >> 8 & 0xFF);
                this.sampleBuffer[this.bufferIndex++] = (byte)(this.sampleValueR & 0xFF);
                this.sampleBuffer[this.bufferIndex++] = (byte)(this.sampleValueR >> 8 & 0xFF);
            }
        } else if (this.bufferIndex + 2 < this.sampleBuffer.length) {
            if (Globals.nsfMode) {
                this.ismpbuffer[this.bufferIndex >> 1] = this.sampleValueL;
            }
            this.sampleBuffer[this.bufferIndex++] = (byte)(this.sampleValueL & 0xFF);
            this.sampleBuffer[this.bufferIndex++] = (byte)(this.sampleValueL >> 8 & 0xFF);
        }
        if (this.recordOutput) {
            if (this.stereo && this.fileOut.isStereo()) {
                this.b1 = this.sampleBuffer[this.bufferIndex - 4];
                this.b2 = this.sampleBuffer[this.bufferIndex - 3];
                this.b3 = this.sampleBuffer[this.bufferIndex - 2];
                this.b4 = this.sampleBuffer[this.bufferIndex - 1];
                this.fileOut.writeStereoSample(this.b1, this.b2, this.b3, this.b4);
            } else {
                this.b1 = this.sampleBuffer[this.bufferIndex - 2];
                this.b2 = this.sampleBuffer[this.bufferIndex - 1];
                this.fileOut.writeMonoSample(this.b1, this.b2);
            }
        }
        this.smpSquare1 = 0;
        this.smpSquare2 = 0;
        this.smpTriangle = 0;
        this.smpDmc = 0;
    }

    public void writeBuffer() {
        if (this.line == null) {
            return;
        }
        this.bufferIndex -= this.bufferIndex % (this.stereo ? 4 : 2);
        this.line.write(this.sampleBuffer, 0, this.bufferIndex);
        this.bufferIndex = 0;
    }

    public void stop() {
        if (this.line == null) {
            return;
        }
        if (this.line != null && this.line.isOpen() && this.line.isActive()) {
            this.line.close();
        }
        this.line = null;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void reset() {
        this.setSampleRate(this.sampleRate, false);
        this.updateChannelEnable(0);
        this.masterFrameCounter = 0;
        this.derivedFrameCounter = 0;
        this.countSequence = 0;
        this.sampleCount = 0;
        this.initCounter = 2048;
        this.frameIrqEnabled = false;
        this.initingHardware = false;
        this.resetCounter();
        this.square1.reset();
        this.square2.reset();
        this.triangle.reset();
        this.noise.reset();
        this.dmc.reset();
        this.bufferIndex = 0;
        this.accCount = 0;
        this.smpSquare1 = 0;
        this.smpSquare2 = 0;
        this.smpTriangle = 0;
        this.smpNoise = 0;
        this.smpDmc = 0;
        this.frameIrqEnabled = false;
        this.frameIrqCounterMax = 4;
        this.channelEnableValue = (short)255;
        this.b1 = 0;
        this.b2 = 0;
        this.startedPlaying = false;
        this.sampleValueL = 0;
        this.sampleValueR = 0;
        this.prevSampleL = 0;
        this.prevSampleR = 0;
        this.smpAccumL = 0;
        this.smpAccumR = 0;
        this.smpDiffL = 0;
        this.smpDiffR = 0;
    }

    public int getLengthMax(int n) {
        return this.lengthLookup[n >> 3];
    }

    public int getDmcFrequency(int n) {
        if (n >= 0 && n < 16) {
            return this.dmcFreqLookup[n];
        }
        return 0;
    }

    public int getNoiseWaveLength(int n) {
        if (n >= 0 && n < 16) {
            return this.noiseWavelengthLookup[n];
        }
        return 0;
    }

    public synchronized void setSampleRate(int n, boolean bl) {
        boolean bl2 = this.nes.isRunning();
        if (bl2) {
            this.nes.stopEmulation();
        }
        this.sampleRate = n;
        this.sampleTimerMax = (int)(1024.0 * Globals.CPU_FREQ_NTSC * (double)Globals.preferredFrameRate / ((double)this.sampleRate * 60.0));
        this.frameTime = (int)(14915.0 * (double)Globals.preferredFrameRate / 60.0);
        this.sampleTimer = 0;
        this.bufferIndex = 0;
        if (bl) {
            this.stop();
            this.start();
        }
        if (bl2) {
            this.nes.startEmulation();
        }
    }

    public synchronized void setStereo(boolean bl, boolean bl2) {
        if (this.stereo == bl) {
            return;
        }
        boolean bl3 = this.nes.isRunning();
        this.nes.stopEmulation();
        this.stereo = bl;
        this.sampleBuffer = this.stereo ? new byte[this.bufferSize * 4] : new byte[this.bufferSize * 2];
        if (bl2) {
            this.stop();
            this.start();
        }
        if (bl3) {
            this.nes.startEmulation();
        }
    }

    public int getPapuBufferSize() {
        return this.sampleBuffer.length;
    }

    public void setChannelEnabled(int n, boolean bl) {
        if (n == 0) {
            this.userEnableSquare1 = bl;
        } else if (n == 1) {
            this.userEnableSquare2 = bl;
        } else if (n == 2) {
            this.userEnableTriangle = bl;
        } else if (n == 3) {
            this.userEnableNoise = bl;
        } else {
            this.userEnableDmc = bl;
        }
        this.updateChannelEnable(this.channelEnableValue);
    }

    public void setPanning(int[] nArray) {
        for (int i = 0; i < 5; ++i) {
            this.panning[i] = nArray[i];
        }
        this.updateStereoPos();
    }

    public void setMasterVolume(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 256) {
            n = 256;
        }
        this.masterVolume = n;
        this.updateStereoPos();
    }

    public void updateStereoPos() {
        this.stereoPosLSquare1 = this.panning[0] * this.masterVolume >> 8;
        this.stereoPosLSquare2 = this.panning[1] * this.masterVolume >> 8;
        this.stereoPosLTriangle = this.panning[2] * this.masterVolume >> 8;
        this.stereoPosLNoise = this.panning[3] * this.masterVolume >> 8;
        this.stereoPosLDMC = this.panning[4] * this.masterVolume >> 8;
        this.stereoPosRSquare1 = this.masterVolume - this.stereoPosLSquare1;
        this.stereoPosRSquare2 = this.masterVolume - this.stereoPosLSquare2;
        this.stereoPosRTriangle = this.masterVolume - this.stereoPosLTriangle;
        this.stereoPosRNoise = this.masterVolume - this.stereoPosLNoise;
        this.stereoPosRDMC = this.masterVolume - this.stereoPosLDMC;
    }

    public SourceDataLine getLine() {
        return this.line;
    }

    public boolean isRunning() {
        return this.line != null && this.line.isActive();
    }

    public int getMillisToAvailableAbove(int n) {
        int n2 = this.line.available();
        if (n2 >= n) {
            return 0;
        }
        long l = (n - n2) * 1000 / this.sampleRate;
        l /= (long)(this.stereo ? 4 : 2);
        l /= 10L;
        return (int)(l *= 10L);
    }

    public int getBufferPos() {
        return this.bufferIndex;
    }

    public void initLengthLookup() {
        this.lengthLookup = new int[]{10, 254, 20, 2, 40, 4, 80, 6, 160, 8, 60, 10, 14, 12, 26, 14, 12, 16, 24, 18, 48, 20, 96, 22, 192, 24, 72, 26, 16, 28, 32, 30};
    }

    public void initDmcFrequencyLookup() {
        this.dmcFreqLookup = new int[16];
        this.dmcFreqLookup[0] = 3424;
        this.dmcFreqLookup[1] = 3040;
        this.dmcFreqLookup[2] = 2720;
        this.dmcFreqLookup[3] = 2560;
        this.dmcFreqLookup[4] = 2288;
        this.dmcFreqLookup[5] = 2032;
        this.dmcFreqLookup[6] = 1808;
        this.dmcFreqLookup[7] = 1712;
        this.dmcFreqLookup[8] = 1520;
        this.dmcFreqLookup[9] = 1280;
        this.dmcFreqLookup[10] = 1136;
        this.dmcFreqLookup[11] = 1024;
        this.dmcFreqLookup[12] = 848;
        this.dmcFreqLookup[13] = 672;
        this.dmcFreqLookup[14] = 576;
        this.dmcFreqLookup[15] = 432;
    }

    public void initNoiseWavelengthLookup() {
        this.noiseWavelengthLookup = new int[16];
        this.noiseWavelengthLookup[0] = 4;
        this.noiseWavelengthLookup[1] = 8;
        this.noiseWavelengthLookup[2] = 16;
        this.noiseWavelengthLookup[3] = 32;
        this.noiseWavelengthLookup[4] = 64;
        this.noiseWavelengthLookup[5] = 96;
        this.noiseWavelengthLookup[6] = 128;
        this.noiseWavelengthLookup[7] = 160;
        this.noiseWavelengthLookup[8] = 202;
        this.noiseWavelengthLookup[9] = 254;
        this.noiseWavelengthLookup[10] = 380;
        this.noiseWavelengthLookup[11] = 508;
        this.noiseWavelengthLookup[12] = 762;
        this.noiseWavelengthLookup[13] = 1016;
        this.noiseWavelengthLookup[14] = 2034;
        this.noiseWavelengthLookup[15] = 4068;
    }

    public void initDACtables() {
        int n;
        double d;
        int n2;
        this.square_table = new int[512];
        this.tnd_table = new int[3264];
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < 512; ++n2) {
            d = 95.52 / (8128.0 / ((double)n2 / 16.0) + 100.0);
            d *= 0.98411;
            this.square_table[n2] = n = (int)(d *= 50000.0);
            if (n <= n3) continue;
            n3 = n;
        }
        for (n2 = 0; n2 < 3264; ++n2) {
            d = 163.67 / (24329.0 / ((double)n2 / 16.0) + 100.0);
            d *= 0.98411;
            this.tnd_table[n2] = n = (int)(d *= 50000.0);
            if (n <= n4) continue;
            n4 = n;
        }
        this.dacRange = n3 + n4;
        this.dcValue = this.dacRange / 2;
    }

    public void destroy() {
        if (this.recordOutput) {
            this.stopRecording();
        }
        this.nes = null;
        this.cpuMem = null;
        if (this.square1 != null) {
            this.square1.destroy();
        }
        if (this.square2 != null) {
            this.square2.destroy();
        }
        if (this.triangle != null) {
            this.triangle.destroy();
        }
        if (this.noise != null) {
            this.noise.destroy();
        }
        if (this.dmc != null) {
            this.dmc.destroy();
        }
        this.square1 = null;
        this.square2 = null;
        this.triangle = null;
        this.noise = null;
        this.dmc = null;
        this.mixer = null;
        this.line = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

