/*
 * Decompiled with CFR 0.152.
 */
public class NameTable {
    String name;
    short[] tile;
    short[] attrib;
    int width;
    int height;

    public NameTable(int n, int n2, String string) {
        this.name = string;
        this.width = n;
        this.height = n2;
        this.tile = new short[n * n2];
        this.attrib = new short[n * n2];
    }

    public short getTileIndex(int n, int n2) {
        return this.tile[n2 * this.width + n];
    }

    public short getAttrib(int n, int n2) {
        return this.attrib[n2 * this.width + n];
    }

    public void writeTileIndex(int n, int n2) {
        this.tile[n] = (short)n2;
    }

    public void writeAttrib(int n, int n2) {
        int n3 = n % 8;
        int n4 = n / 8;
        n3 *= 4;
        n4 *= 4;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                int n5 = n2 >> 2 * (i * 2 + j) & 3;
                for (int k = 0; k < 2; ++k) {
                    for (int i2 = 0; i2 < 2; ++i2) {
                        int n6 = n3 + j * 2 + i2;
                        int n7 = n4 + i * 2 + k;
                        int n8 = n7 * this.width + n6;
                        this.attrib[n7 * this.width + n6] = (short)(n5 << 2 & 0xC);
                    }
                }
            }
        }
    }

    public void stateSave(ByteBuffer byteBuffer) {
        int n;
        for (n = 0; n < this.width * this.height; ++n) {
            if (this.tile[n] <= 255) continue;
            byteBuffer.putByte((byte)this.tile[n]);
        }
        for (n = 0; n < this.width * this.height; ++n) {
            byteBuffer.putByte((byte)this.attrib[n]);
        }
    }

    public void stateLoad(ByteBuffer byteBuffer) {
        int n;
        for (n = 0; n < this.width * this.height; ++n) {
            this.tile[n] = byteBuffer.readByte();
        }
        for (n = 0; n < this.width * this.height; ++n) {
            this.attrib[n] = byteBuffer.readByte();
        }
    }
}

