/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;

public class NSF
extends MapperDefault
implements Runnable {
    public static final int MODE_NTSC = 0;
    public static final int MODE_PAL = 1;
    public static final int MODE_DUAL = 2;
    public static final int EXT_VRCVI = 1;
    public static final int EXT_VRCVII = 2;
    public static final int EXT_FDS = 4;
    public static final int EXT_MMC5 = 5;
    boolean loaded;
    boolean bankSwitched;
    int version;
    int songCount;
    int bankCount;
    int startSong;
    int loadAddress;
    int initAddress;
    int playAddress;
    String songName;
    String songArtist;
    String songCopyright;
    int speedNTSC;
    int speedPAL;
    int skipCycles;
    int ppuCycles;
    int mode;
    int ext;
    int[] bankSwitchInit;
    short[][] bank;
    int currentSong;
    boolean isPlaying;
    boolean pauseMusic;
    Thread myThread;

    public NSF(NES nES) {
        super.init(nES);
        this.loaded = false;
    }

    public NSF(NES nES, String string) {
        super.init(nES);
        this.load(string);
        if (this.loaded) {
            // empty if block
        }
    }

    public boolean load(String string) {
        int n;
        int n2;
        FileLoader fileLoader = new FileLoader();
        short[] sArray = fileLoader.loadFile(string, this.nes.getGui());
        if (sArray == null || sArray.length < 128) {
            return false;
        }
        char[] cArray = new char[4];
        for (int i = 0; i < 4; ++i) {
            cArray[i] = (char)sArray[i];
        }
        String string2 = new String(cArray);
        if (!string2.equals("NESM") || sArray[4] != 26) {
            return false;
        }
        this.version = sArray[5];
        this.songCount = sArray[6];
        this.currentSong = this.startSong = sArray[7];
        this.loadAddress = sArray[8] | sArray[9] << 8;
        this.initAddress = sArray[10] | sArray[11] << 8;
        this.playAddress = sArray[12] | sArray[13] << 8;
        int n3 = sArray.length - 128 + (this.loadAddress & 0xFFF);
        this.bankCount = n3 / 4096;
        if (this.bankCount * 4096 < n3) {
            ++this.bankCount;
        }
        char[][] cArray2 = new char[3][32];
        int[] nArray = new int[]{-1, -1, -1};
        for (n2 = 0; n2 < 32; ++n2) {
            cArray2[0][n2] = (char)sArray[14 + n2];
            cArray2[1][n2] = (char)sArray[46 + n2];
            cArray2[2][n2] = (char)sArray[78 + n2];
            for (n = 0; n < 3; ++n) {
                if (cArray2[n][n2] != '\u0000' || nArray[n] != -1) continue;
                nArray[n] = n2;
            }
        }
        for (n2 = 0; n2 < 3; ++n2) {
            if (nArray[n2] != -1) continue;
            nArray[n2] = 32;
        }
        this.songName = new String(cArray2[0], 0, nArray[0]);
        this.songArtist = new String(cArray2[1], 0, nArray[1]);
        this.songCopyright = new String(cArray2[2], 0, nArray[2]);
        this.speedNTSC = sArray[110] | sArray[111] << 8;
        this.speedPAL = sArray[120] | sArray[121] << 8;
        this.bankSwitchInit = new int[8];
        this.bankSwitched = false;
        for (n2 = 0; n2 < 8; ++n2) {
            this.bankSwitchInit[n2] = sArray[112 + n2];
            if (this.bankSwitchInit[n2] == 0) continue;
            this.bankSwitched = true;
        }
        int n4 = sArray[122] & 3;
        if (n4 == 3) {
            return false;
        }
        this.mode = n4;
        this.ext = sArray[123];
        this.bank = new short[this.bankCount][4096];
        short[] sArray2 = new short[this.bankCount * 4096 + (this.loadAddress & 0xFFF)];
        System.arraycopy(sArray, 128, sArray2, this.loadAddress & 0xFFF, sArray.length - 128);
        for (n = 0; n < this.bankCount; ++n) {
            System.arraycopy(sArray2, n * 4096, this.bank[n], 0, 4096);
        }
        this.loaded = true;
        return true;
    }

    public boolean isValid() {
        return this.loaded;
    }

    public short[] getBank(int n) {
        if (n < this.bank.length) {
            return this.bank[n];
        }
        return null;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public int getSongCount() {
        return this.songCount;
    }

    public int getCurrentSong() {
        return this.currentSong;
    }

    public synchronized void resumeSong() {
        if (this.myThread != null && this.myThread.isAlive()) {
            this.stopPlaying();
        }
        this.isPlaying = true;
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    public synchronized void playSong(int n) {
        if (this.myThread != null && this.myThread.isAlive()) {
            this.stopPlaying();
        }
        this.currentSong = n;
        this.initSong();
        this.isPlaying = true;
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    public void stopPlaying() {
        this.isPlaying = false;
        if (this.myThread != null && this.myThread.isAlive()) {
            try {
                this.myThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void nextSong() {
        int n = this.getCurrentSong() + 1;
        if (n > this.getSongCount()) {
            n = 1;
        }
        if (n == this.currentSong) {
            return;
        }
        this.playSong(n);
    }

    public void prevSong() {
        int n = this.getCurrentSong() - 1;
        if (n < 1) {
            n = this.getSongCount();
        }
        if (n == this.currentSong) {
            return;
        }
        this.playSong(n);
    }

    public void initSong() {
        int n;
        this.nes.cpu.reset();
        if (this.nes.usePPU()) {
            this.nes.ppu.reset();
        }
        this.nes.papu.stop();
        this.nes.papu.start();
        this.skipCycles = this.mode == 0 || this.mode == 2 ? (int)((double)this.speedNTSC * 1.78977272) : (int)((double)this.speedPAL * 1.78977272);
        for (n = 0; n < 2048; ++n) {
            this.nes.cpuMem.mem[n] = 0;
        }
        for (n = 24576; n < 32768; ++n) {
            this.nes.cpuMem.mem[n] = 0;
        }
        for (n = 0; n < 20; ++n) {
            if (n == 16) {
                this.regWrite(16400, (short)16);
                continue;
            }
            this.regWrite(16384 + n, (short)0);
        }
        this.regWrite(16405, (short)15);
        this.cpu.REG_ACC_NEW = this.currentSong - 1;
        this.cpu.REG_X_NEW = this.mode == 0 || this.mode == 2 ? 0 : 1;
        for (n = 0; n < 8; ++n) {
            if (this.bankSwitched) {
                this.switchBank(32768 + n * 4096, this.bankSwitchInit[n]);
                continue;
            }
            this.switchBank((this.loadAddress & 0xF000) + n * 4096, n);
        }
        this.cpu.push(255);
        this.cpu.push(255);
        this.cpu.REG_PC_NEW = this.initAddress - 1;
        this.cpu.nsfInit = true;
        this.cpu.emulate();
        this.cpu.nsfInit = false;
    }

    private void switchBank(int n, int n2) {
        if (n2 < this.bank.length) {
            System.arraycopy(this.bank[n2], 0, this.nes.cpuMem.mem, n, 4096);
        }
    }

    public void run() {
        PPU pPU = this.nes.ppu;
        PAPU pAPU = this.nes.papu;
        while (this.isPlaying) {
            int n;
            if (this.pauseMusic) {
                try {
                    Thread.currentThread();
                    Thread.sleep(16L);
                    this.nes.getGui().imageReady(false);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            this.cpu.push(255);
            this.cpu.push(255);
            this.cpu.REG_PC_NEW = this.playAddress - 1;
            this.cpu.stopRunning = false;
            this.cpu.emulate();
            for (n = this.skipCycles - this.cpu.nsfCycles; n > 8; n -= 8) {
                this.ppuCycles += 24;
                if (this.ppuCycles >= 89342) {
                    this.ppuCycles -= 89342;
                    this.frameFinished();
                }
                this.nes.papu.clockFrameCounter(1);
                this.nes.papu.clockFrameCounter(1);
                this.nes.papu.clockFrameCounter(1);
                this.nes.papu.clockFrameCounter(1);
                this.nes.papu.clockFrameCounter(1);
                this.nes.papu.clockFrameCounter(1);
                this.nes.papu.clockFrameCounter(1);
                this.nes.papu.clockFrameCounter(1);
            }
            this.ppuCycles += n * 3;
            if (this.ppuCycles >= 89342) {
                this.ppuCycles -= 89342;
                this.frameFinished();
            }
            while (n > 0) {
                this.nes.papu.clockFrameCounter(1);
                --n;
            }
            this.cpu.nsfCycles = 0;
        }
    }

    public void frameFinished() {
        if (Globals.appletMode) {
            this.nes.getCpu().requestIrq(1);
            this.nes.getGui().imageReady(false);
        } else {
            this.nes.ppu.startVBlank();
        }
    }

    public void write(int n, short s) {
        if (n < 24568 || n > 24575) {
            super.write(n, s);
        } else {
            this.switchBank(32768 + (n - 24568) * 4096, s % this.bankCount);
        }
    }

    private short[] loadFile(File file) {
        try {
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            int n2 = 0;
            FileInputStream fileInputStream = new FileInputStream(file);
            while (n2 < n) {
                int n3 = fileInputStream.read(byArray, n2, n - n2);
                if (n3 > 0) {
                    n2 += n3;
                    continue;
                }
                if (n3 != -1) continue;
            }
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = (short)(byArray[i] & 0xFF);
            }
            fileInputStream.close();
            return sArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void reset() {
        super.reset();
    }
}

