/*
 * Decompiled with CFR 0.152.
 */
public class NES {
    public UI gui;
    public CPU cpu;
    public PPU ppu;
    public PAPU papu;
    public Memory cpuMem;
    public Memory ppuMem;
    public Memory sprMem;
    public MemoryMapper memMapper;
    public PaletteTable palTable;
    public ROM rom;
    public GameGenie gameGenie;
    public NSF nsf;
    int cc;
    public String romFile;
    boolean isRunning = false;

    public NES(UI uI) {
        Globals.nes = this;
        this.gui = uI;
        this.cpuMem = new Memory(this, 65536);
        this.ppuMem = new Memory(this, 32768);
        this.sprMem = new Memory(this, 256);
        this.cpu = new CPU(this);
        if (this.usePPU()) {
            this.palTable = new PaletteTable();
            this.ppu = new PPU(this);
        }
        this.papu = new PAPU(this);
        if (!Globals.nsfMode) {
            this.gameGenie = new GameGenie();
        }
        for (int i = 0; i < 20; ++i) {
            if (i == 16) {
                this.papu.writeReg(16400, (short)16);
                continue;
            }
            this.papu.writeReg(16384 + i, (short)0);
        }
        if (this.usePPU() && !this.palTable.loadNTSCPalette()) {
            this.palTable.loadDefaultPalette();
        }
        this.cpu.init();
        if (this.usePPU()) {
            this.ppu.init();
        }
        this.enableSound(true);
        this.clearCPUMemory();
    }

    public boolean stateLoad(ByteBuffer byteBuffer) {
        boolean bl;
        boolean bl2 = false;
        if (this.cpu.isRunning()) {
            bl2 = true;
            this.stopEmulation();
        }
        if (byteBuffer.readByte() == 1) {
            this.cpuMem.stateLoad(byteBuffer);
            this.ppuMem.stateLoad(byteBuffer);
            this.sprMem.stateLoad(byteBuffer);
            this.cpu.stateLoad(byteBuffer);
            this.memMapper.stateLoad(byteBuffer);
            this.ppu.stateLoad(byteBuffer);
            bl = true;
        } else {
            bl = false;
        }
        if (bl2) {
            this.startEmulation();
        }
        return bl;
    }

    public void stateSave(ByteBuffer byteBuffer) {
        boolean bl = this.isRunning();
        this.stopEmulation();
        byteBuffer.putByte((short)1);
        this.cpuMem.stateSave(byteBuffer);
        this.ppuMem.stateSave(byteBuffer);
        this.sprMem.stateSave(byteBuffer);
        this.cpu.stateSave(byteBuffer);
        this.memMapper.stateSave(byteBuffer);
        this.ppu.stateSave(byteBuffer);
        if (bl) {
            this.startEmulation();
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean usePPU() {
        return !Globals.appletMode || !Globals.nsfMode;
    }

    public void startEmulation() {
        if (Globals.enableSound && !this.papu.isRunning()) {
            this.papu.start();
        }
        if (Globals.nsfMode) {
            if (this.nsf != null && this.nsf.isValid() && !this.nsf.isPlaying) {
                this.nsf.resumeSong();
                this.isRunning = true;
            }
        } else if (this.rom != null && this.rom.isValid() && !this.cpu.isRunning()) {
            this.cpu.beginExecution();
            this.isRunning = true;
        }
    }

    public void stopEmulation() {
        if (Globals.nsfMode) {
            if (this.nsf != null && this.nsf.isPlaying) {
                this.nsf.stopPlaying();
                this.isRunning = false;
            }
        } else if (this.cpu.isRunning()) {
            this.cpu.endExecution();
            this.isRunning = false;
        }
        if (Globals.enableSound && this.papu.isRunning()) {
            this.papu.stop();
        }
    }

    public void reloadRom() {
        if (this.romFile != null) {
            this.loadRom(this.romFile);
        }
    }

    public void clearCPUMemory() {
        int n;
        short s = Globals.memoryFlushValue;
        for (n = 0; n < 8192; ++n) {
            this.cpuMem.mem[n] = s;
        }
        for (n = 0; n < 4; ++n) {
            int n2 = n * 2048;
            this.cpuMem.mem[n2 + 8] = 247;
            this.cpuMem.mem[n2 + 9] = 239;
            this.cpuMem.mem[n2 + 10] = 223;
            this.cpuMem.mem[n2 + 15] = 191;
        }
    }

    public void setGameGenieState(boolean bl) {
        if (this.memMapper != null) {
            this.memMapper.setGameGenieState(bl);
        }
    }

    public CPU getCpu() {
        return this.cpu;
    }

    public PPU getPpu() {
        return this.ppu;
    }

    public PAPU getPapu() {
        return this.papu;
    }

    public Memory getCpuMemory() {
        return this.cpuMem;
    }

    public Memory getPpuMemory() {
        return this.ppuMem;
    }

    public Memory getSprMemory() {
        return this.sprMem;
    }

    public ROM getRom() {
        return this.rom;
    }

    public UI getGui() {
        return this.gui;
    }

    public MemoryMapper getMemoryMapper() {
        return this.memMapper;
    }

    public GameGenie getGameGenie() {
        return this.gameGenie;
    }

    public boolean loadRom(String string) {
        if (this.isRunning) {
            this.stopEmulation();
        }
        if (string.toLowerCase().endsWith("nsf")) {
            this.nsf = new NSF(this, string);
            if (this.nsf.isValid()) {
                Globals.nsfMode = true;
                this.reset();
                this.cpu.setMapper(this.nsf);
                this.memMapper = this.nsf;
                this.nsf.initSong();
                this.romFile = string;
                return true;
            }
            return false;
        }
        this.rom = new ROM(this);
        this.rom.load(string);
        if (this.rom.isValid()) {
            Globals.nsfMode = false;
            this.nsf = null;
            this.reset();
            this.memMapper = this.rom.createMapper();
            this.memMapper.init(this);
            this.cpu.setMapper(this.memMapper);
            this.memMapper.loadROM(this.rom);
            this.ppu.setMirroring(this.rom.getMirroringType());
            if (this.gameGenie.getCodeCount() > 0) {
                this.memMapper.setGameGenieState(true);
            }
            this.romFile = string;
        }
        return this.rom.isValid();
    }

    public void reset() {
        if (this.rom != null) {
            this.rom.closeRom();
        }
        if (this.memMapper != null) {
            this.memMapper.reset();
        }
        this.cpuMem.reset();
        this.ppuMem.reset();
        this.sprMem.reset();
        this.clearCPUMemory();
        this.cpu.reset();
        this.cpu.init();
        if (this.usePPU()) {
            this.ppu.reset();
            this.palTable.reset();
        }
        this.papu.reset();
        InputHandler inputHandler = this.gui.getJoy1();
        if (inputHandler != null) {
            inputHandler.reset();
        }
    }

    public void enableSound(boolean bl) {
        boolean bl2 = this.isRunning();
        if (bl2) {
            this.stopEmulation();
        }
        if (bl) {
            this.papu.start();
        } else {
            this.papu.stop();
        }
        Globals.enableSound = bl;
        if (bl2) {
            this.startEmulation();
        }
    }

    public void setFramerate(int n) {
        Globals.preferredFrameRate = n;
        Globals.frameTime = 1000000 / n;
        this.papu.setSampleRate(this.papu.getSampleRate(), false);
    }

    public void destroy() {
        if (this.cpu != null) {
            this.cpu.destroy();
        }
        if (this.ppu != null) {
            this.ppu.destroy();
        }
        if (this.papu != null) {
            this.papu.destroy();
        }
        if (this.cpuMem != null) {
            this.cpuMem.destroy();
        }
        if (this.ppuMem != null) {
            this.ppuMem.destroy();
        }
        if (this.sprMem != null) {
            this.sprMem.destroy();
        }
        if (this.memMapper != null) {
            this.memMapper.destroy();
        }
        if (this.rom != null) {
            this.rom.destroy();
        }
        this.gui = null;
        this.cpu = null;
        this.ppu = null;
        this.papu = null;
        this.cpuMem = null;
        this.ppuMem = null;
        this.sprMem = null;
        this.memMapper = null;
        this.rom = null;
        this.gameGenie = null;
        this.palTable = null;
    }
}

