/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class Memory {
    public short[] mem;
    int memLength;
    NES nes;

    public Memory(NES nES, int n) {
        this.nes = nES;
        this.mem = new short[n];
        this.memLength = n;
    }

    public void stateLoad(ByteBuffer byteBuffer) {
        if (this.mem == null) {
            this.mem = new short[this.memLength];
        }
        byteBuffer.readByteArray(this.mem);
    }

    public void stateSave(ByteBuffer byteBuffer) {
        byteBuffer.putByteArray(this.mem);
    }

    public void reset() {
        for (int i = 0; i < this.mem.length; ++i) {
            this.mem[i] = 0;
        }
    }

    public int getMemSize() {
        return this.memLength;
    }

    public void write(int n, short s) {
        this.mem[n] = s;
    }

    public short load(int n) {
        return this.mem[n];
    }

    public void dump(String string) {
        this.dump(string, 0, this.mem.length);
    }

    public void dump(String string, int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = (char)this.mem[n + i];
        }
        try {
            File file = new File(string);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(cArray);
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(int n, short[] sArray, int n2) {
        if (n + n2 > this.mem.length) {
            return;
        }
        System.arraycopy(sArray, 0, this.mem, n, n2);
    }

    public void write(int n, short[] sArray, int n2, int n3) {
        if (n + n3 > this.mem.length) {
            return;
        }
        System.arraycopy(sArray, n2, this.mem, n, n3);
    }

    public void destroy() {
        this.nes = null;
        this.mem = null;
    }
}

