/*
 * Decompiled with CFR 0.152.
 */
public class MapperDefault
implements MemoryMapper {
    public NES nes;
    public Memory cpuMem;
    public Memory ppuMem;
    public short[] cpuMemArray;
    public ROM rom;
    public CPU cpu;
    public PPU ppu;
    public int cpuMemSize;
    public int joy1StrobeState;
    public int joy2StrobeState;
    public int joypadLastWrite;
    public boolean mousePressed;
    public boolean gameGenieActive;
    public int mouseX;
    public int mouseY;
    int tmp;

    public void init(NES nES) {
        this.nes = nES;
        this.cpuMem = nES.getCpuMemory();
        this.cpuMemArray = this.cpuMem.mem;
        this.ppuMem = nES.getPpuMemory();
        this.rom = nES.getRom();
        this.cpu = nES.getCpu();
        this.ppu = nES.getPpu();
        this.cpuMemSize = this.cpuMem.getMemSize();
        this.joypadLastWrite = -1;
    }

    public void stateLoad(ByteBuffer byteBuffer) {
        if (byteBuffer.readByte() == 1) {
            this.joy1StrobeState = byteBuffer.readInt();
            this.joy2StrobeState = byteBuffer.readInt();
            this.joypadLastWrite = byteBuffer.readInt();
            this.mapperInternalStateLoad(byteBuffer);
        }
    }

    public void stateSave(ByteBuffer byteBuffer) {
        byteBuffer.putByte((short)1);
        byteBuffer.putInt(this.joy1StrobeState);
        byteBuffer.putInt(this.joy2StrobeState);
        byteBuffer.putInt(this.joypadLastWrite);
        this.mapperInternalStateSave(byteBuffer);
    }

    public void mapperInternalStateLoad(ByteBuffer byteBuffer) {
        byteBuffer.putByte((short)this.joy1StrobeState);
        byteBuffer.putByte((short)this.joy2StrobeState);
        byteBuffer.putByte((short)this.joypadLastWrite);
    }

    public void mapperInternalStateSave(ByteBuffer byteBuffer) {
        this.joy1StrobeState = byteBuffer.readByte();
        this.joy2StrobeState = byteBuffer.readByte();
        this.joypadLastWrite = byteBuffer.readByte();
    }

    public void setGameGenieState(boolean bl) {
        this.gameGenieActive = bl;
    }

    public boolean getGameGenieState() {
        return this.gameGenieActive;
    }

    public void write(int n, short s) {
        if (n < 8192) {
            this.cpuMem.mem[n & 0x7FF] = s;
        } else if (n > 16407) {
            this.cpuMem.mem[n] = s;
            if (n >= 24576 && n < 32768 && this.rom != null) {
                this.rom.writeBatteryRam(n, s);
            }
        } else if (n > 8199 && n < 16384) {
            this.regWrite(8192 + (n & 7), s);
        } else {
            this.regWrite(n, s);
        }
    }

    public short load(int n) {
        if (this.gameGenieActive && this.nes.gameGenie.addressMatch[n]) {
            this.tmp = this.nes.gameGenie.getCodeIndex(n);
            if (this.nes.gameGenie.getCodeType(this.tmp) == GameGenie.TYPE_6CHAR) {
                return (short)this.nes.gameGenie.getCodeValue(this.tmp);
            }
            if (this.cpuMemArray[n] == this.nes.gameGenie.getCodeCompare(this.tmp)) {
                return (short)this.nes.gameGenie.getCodeValue(this.tmp);
            }
        }
        if ((n &= 0xFFFF) > 16407) {
            return this.cpuMemArray[n];
        }
        if (n >= 8192) {
            return this.regLoad(n);
        }
        return this.cpuMemArray[n & 0x7FF];
    }

    public short regLoad(int n) {
        switch (n >> 12) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                switch (n & 7) {
                    case 0: {
                        return this.cpuMem.mem[8192];
                    }
                    case 1: {
                        return this.cpuMem.mem[8193];
                    }
                    case 2: {
                        return this.ppu.readStatusRegister();
                    }
                    case 3: {
                        return 0;
                    }
                    case 4: {
                        return this.ppu.sramLoad();
                    }
                    case 5: {
                        return 0;
                    }
                    case 6: {
                        return 0;
                    }
                    case 7: {
                        return this.ppu.vramLoad();
                    }
                }
                break;
            }
            case 4: {
                switch (n - 16405) {
                    case 0: {
                        return this.nes.getPapu().readReg(n);
                    }
                    case 1: {
                        return this.joy1Read();
                    }
                    case 2: {
                        if (this.mousePressed && this.nes.ppu != null && this.nes.ppu.buffer != null) {
                            int n2 = Math.max(0, this.mouseX - 4);
                            int n3 = Math.min(256, this.mouseX + 4);
                            int n4 = Math.max(0, this.mouseY - 4);
                            int n5 = Math.min(240, this.mouseY + 4);
                            int n6 = 0;
                            block21: for (int i = n4; i < n5; ++i) {
                                for (int j = n2; j < n3; ++j) {
                                    if ((this.nes.ppu.buffer[(i << 8) + j] & 0xFFFFFF) != 0xFFFFFF) continue;
                                    n6 = 8;
                                    continue block21;
                                }
                            }
                            return (short)(this.joy2Read() | (n6 |= this.mousePressed ? 16 : 0));
                        }
                        return this.joy2Read();
                    }
                }
            }
        }
        return 0;
    }

    public void regWrite(int n, short s) {
        switch (n) {
            case 8192: {
                this.cpuMem.write(n, s);
                this.ppu.updateControlReg1(s);
                break;
            }
            case 8193: {
                this.cpuMem.write(n, s);
                this.ppu.updateControlReg2(s);
                break;
            }
            case 8195: {
                this.ppu.writeSRAMAddress(s);
                break;
            }
            case 8196: {
                this.ppu.sramWrite(s);
                break;
            }
            case 8197: {
                this.ppu.scrollWrite(s);
                break;
            }
            case 8198: {
                this.ppu.writeVRAMAddress(s);
                break;
            }
            case 8199: {
                this.ppu.vramWrite(s);
                break;
            }
            case 16404: {
                this.ppu.sramDMA(s);
                break;
            }
            case 16405: {
                this.nes.getPapu().writeReg(n, s);
                break;
            }
            case 16406: {
                if (s == 0 && this.joypadLastWrite == 1) {
                    this.joy1StrobeState = 0;
                    this.joy2StrobeState = 0;
                }
                this.joypadLastWrite = s;
                break;
            }
            case 16407: {
                this.nes.papu.writeReg(n, s);
                break;
            }
            default: {
                if (n < 16384 || n > 16407) break;
                this.nes.getPapu().writeReg(n, s);
            }
        }
    }

    public short joy1Read() {
        short s;
        InputHandler inputHandler = this.nes.getGui().getJoy1();
        switch (this.joy1StrobeState) {
            case 0: {
                s = inputHandler.getKeyState(0);
                break;
            }
            case 1: {
                s = inputHandler.getKeyState(1);
                break;
            }
            case 2: {
                s = inputHandler.getKeyState(3);
                break;
            }
            case 3: {
                s = inputHandler.getKeyState(2);
                break;
            }
            case 4: {
                s = inputHandler.getKeyState(4);
                break;
            }
            case 5: {
                s = inputHandler.getKeyState(5);
                break;
            }
            case 6: {
                s = inputHandler.getKeyState(6);
                break;
            }
            case 7: {
                s = inputHandler.getKeyState(7);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                s = 0;
                break;
            }
            case 19: {
                s = 1;
                break;
            }
            default: {
                s = 0;
            }
        }
        ++this.joy1StrobeState;
        if (this.joy1StrobeState == 24) {
            this.joy1StrobeState = 0;
        }
        return s;
    }

    public short joy2Read() {
        InputHandler inputHandler = this.nes.getGui().getJoy2();
        int n = this.joy2StrobeState++;
        if (this.joy2StrobeState == 24) {
            this.joy2StrobeState = 0;
        }
        if (n == 0) {
            return inputHandler.getKeyState(0);
        }
        if (n == 1) {
            return inputHandler.getKeyState(1);
        }
        if (n == 2) {
            return inputHandler.getKeyState(3);
        }
        if (n == 3) {
            return inputHandler.getKeyState(2);
        }
        if (n == 4) {
            return inputHandler.getKeyState(4);
        }
        if (n == 5) {
            return inputHandler.getKeyState(5);
        }
        if (n == 6) {
            return inputHandler.getKeyState(6);
        }
        if (n == 7) {
            return inputHandler.getKeyState(7);
        }
        if (n == 16) {
            return 0;
        }
        if (n == 17) {
            return 0;
        }
        if (n == 18) {
            return 1;
        }
        if (n == 19) {
            return 0;
        }
        return 0;
    }

    public void loadROM(ROM rOM) {
        if (!rOM.isValid() || rOM.getRomBankCount() < 1) {
            return;
        }
        this.loadPRGROM();
        this.loadCHRROM();
        this.loadBatteryRam();
        this.nes.getCpu().requestIrq(2);
    }

    protected void loadPRGROM() {
        if (this.rom.getRomBankCount() > 1) {
            this.loadRomBank(0, 32768);
            this.loadRomBank(1, 49152);
        } else {
            this.loadRomBank(0, 32768);
            this.loadRomBank(0, 49152);
        }
    }

    protected void loadCHRROM() {
        if (this.rom.getVromBankCount() > 0) {
            if (this.rom.getVromBankCount() == 1) {
                this.loadVromBank(0, 0);
                this.loadVromBank(0, 4096);
            } else {
                this.loadVromBank(0, 0);
                this.loadVromBank(1, 4096);
            }
        }
    }

    public void loadBatteryRam() {
        short[] sArray;
        if (this.rom.batteryRam && (sArray = this.rom.getBatteryRam()) != null && sArray.length == 8192) {
            System.arraycopy(sArray, 0, this.nes.cpuMem.mem, 24576, 8192);
        }
    }

    protected void loadRomBank(int n, int n2) {
        short[] sArray = this.rom.getRomBank(n %= this.rom.getRomBankCount());
        System.arraycopy(this.rom.getRomBank(n), 0, this.cpuMem.mem, n2, 16384);
    }

    protected void loadVromBank(int n, int n2) {
        if (this.rom.getVromBankCount() == 0) {
            return;
        }
        this.ppu.triggerRendering();
        System.arraycopy(this.rom.getVromBank(n % this.rom.getVromBankCount()), 0, this.nes.ppuMem.mem, n2, 4096);
        Tile[] tileArray = this.rom.getVromBankTiles(n % this.rom.getVromBankCount());
        System.arraycopy(tileArray, 0, this.ppu.ptTile, n2 >> 4, 256);
    }

    protected void load32kRomBank(int n, int n2) {
        this.loadRomBank(n * 2 % this.rom.getRomBankCount(), n2);
        this.loadRomBank((n * 2 + 1) % this.rom.getRomBankCount(), n2 + 16384);
    }

    protected void load8kVromBank(int n, int n2) {
        if (this.rom.getVromBankCount() == 0) {
            return;
        }
        this.ppu.triggerRendering();
        this.loadVromBank(n % this.rom.getVromBankCount(), n2);
        this.loadVromBank((n + 1) % this.rom.getVromBankCount(), n2 + 4096);
    }

    protected void load1kVromBank(int n, int n2) {
        if (this.rom.getVromBankCount() == 0) {
            return;
        }
        this.ppu.triggerRendering();
        int n3 = n / 4 % this.rom.getVromBankCount();
        int n4 = n % 4 * 1024;
        System.arraycopy(this.rom.getVromBank(n3), 0, this.nes.ppuMem.mem, n4, 1024);
        Tile[] tileArray = this.rom.getVromBankTiles(n3);
        int n5 = n2 >> 4;
        for (int i = 0; i < 64; ++i) {
            this.ppu.ptTile[n5 + i] = tileArray[(n % 4 << 6) + i];
        }
    }

    protected void load2kVromBank(int n, int n2) {
        if (this.rom.getVromBankCount() == 0) {
            return;
        }
        this.ppu.triggerRendering();
        int n3 = n / 2 % this.rom.getVromBankCount();
        int n4 = n % 2 * 2048;
        System.arraycopy(this.rom.getVromBank(n3), n4, this.nes.ppuMem.mem, n2, 2048);
        Tile[] tileArray = this.rom.getVromBankTiles(n3);
        int n5 = n2 >> 4;
        for (int i = 0; i < 128; ++i) {
            this.ppu.ptTile[n5 + i] = tileArray[(n % 2 << 7) + i];
        }
    }

    protected void load8kRomBank(int n, int n2) {
        int n3 = n / 2 % this.rom.getRomBankCount();
        int n4 = n % 2 * 8192;
        short[] sArray = this.rom.getRomBank(n3);
        this.cpuMem.write(n2, sArray, n4, 8192);
    }

    public void clockIrqCounter() {
    }

    public void latchAccess(int n) {
    }

    public void setMouseState(boolean bl, int n, int n2) {
        this.mousePressed = bl;
        this.mouseX = n;
        this.mouseY = n2;
    }

    public void reset() {
        this.joy1StrobeState = 0;
        this.joy2StrobeState = 0;
        this.joypadLastWrite = 0;
        this.mousePressed = false;
    }

    public void destroy() {
        this.nes = null;
        this.cpuMem = null;
        this.ppuMem = null;
        this.rom = null;
        this.cpu = null;
        this.ppu = null;
    }
}

