/*
 * Decompiled with CFR 0.152.
 */
public class Mapper071
extends MapperDefault {
    int curBank;

    public void init(NES nES) {
        super.init(nES);
        this.reset();
    }

    public void loadROM(ROM rOM) {
        if (!rOM.isValid()) {
            return;
        }
        int n = rOM.getRomBankCount();
        this.loadRomBank(0, 32768);
        this.loadRomBank(n - 1, 49152);
        this.loadCHRROM();
        this.loadBatteryRam();
        this.nes.getCpu().requestIrq(2);
    }

    public void write(int n, short s) {
        if (n < 32768) {
            super.write(n, s);
        } else if (n >= 49152 && s != this.curBank) {
            this.curBank = s;
            this.loadRomBank(s, 32768);
        }
    }

    public void reset() {
        this.curBank = -1;
    }
}

