/*
 * Decompiled with CFR 0.152.
 */
public class Mapper068
extends MapperDefault {
    int r1;
    int r2;
    int r3;
    int r4;

    public void write(int n, short s) {
        if (n < 32768) {
            super.write(n, s);
            return;
        }
        switch ((n >> 12) - 8) {
            case 0: {
                this.load2kVromBank(s, 0);
                break;
            }
            case 1: {
                this.load2kVromBank(s, 2048);
                break;
            }
            case 2: {
                this.load2kVromBank(s, 4096);
                break;
            }
            case 3: {
                this.load2kVromBank(s, 6144);
                break;
            }
            case 4: {
                this.r3 = s;
                this.setMirroring();
                break;
            }
            case 5: {
                this.r4 = s;
                this.setMirroring();
                break;
            }
            case 6: {
                this.r1 = s >> 4 & 1;
                this.r2 = s & 3;
                this.setMirroring();
                break;
            }
            case 7: {
                this.loadRomBank(s, 32768);
            }
        }
    }

    private void setMirroring() {
        if (this.r1 == 0) {
            switch (this.r2) {
                case 0: {
                    this.ppu.setMirroring(1);
                    break;
                }
                case 1: {
                    this.ppu.setMirroring(0);
                    break;
                }
                case 2: {
                    this.ppu.setMirroring(3);
                    break;
                }
                case 3: {
                    this.ppu.setMirroring(4);
                }
            }
        } else {
            switch (this.r2) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
    }

    public void loadROM(ROM rOM) {
        if (!rOM.isValid()) {
            return;
        }
        int n = rOM.getRomBankCount();
        this.loadRomBank(0, 32768);
        this.loadRomBank(n - 1, 49152);
        this.loadCHRROM();
        this.loadBatteryRam();
        this.nes.getCpu().requestIrq(2);
    }

    public void reset() {
        this.r4 = 0;
        this.r3 = 0;
        this.r2 = 0;
        this.r1 = 0;
    }
}

