/*
 * Decompiled with CFR 0.152.
 */
public class Mapper010
extends MapperDefault {
    int latchLo;
    int latchHi;
    int latchLoVal1;
    int latchLoVal2;
    int latchHiVal1;
    int latchHiVal2;

    public void init(NES nES) {
        super.init(nES);
        this.reset();
    }

    public void write(int n, short s) {
        if (n < 40960) {
            super.write(n, s);
        } else {
            s = (short)(s & 0xFF);
            switch (n >> 12) {
                case 10: {
                    this.load8kRomBank(s, 32768);
                    break;
                }
                case 11: {
                    this.latchLoVal1 = s;
                    if (this.latchLo != 253) break;
                    this.loadVromBank(s, 0);
                    break;
                }
                case 12: {
                    this.latchLoVal2 = s;
                    if (this.latchLo != 254) break;
                    this.loadVromBank(s, 0);
                    break;
                }
                case 13: {
                    this.latchHiVal1 = s;
                    if (this.latchHi != 253) break;
                    this.loadVromBank(s, 4096);
                    break;
                }
                case 14: {
                    this.latchHiVal2 = s;
                    if (this.latchHi != 254) break;
                    this.loadVromBank(s, 4096);
                    break;
                }
                case 15: {
                    if ((s & 1) == 0) {
                        this.nes.getPpu().setMirroring(0);
                        break;
                    }
                    this.nes.getPpu().setMirroring(1);
                }
            }
        }
    }

    public void loadROM(ROM rOM) {
        if (!rOM.isValid()) {
            return;
        }
        int n = rOM.getRomBankCount() * 2;
        this.load8kRomBank(0, 32768);
        this.load8kRomBank(n - 3, 40960);
        this.load8kRomBank(n - 2, 49152);
        this.load8kRomBank(n - 1, 57344);
        this.loadCHRROM();
        this.loadBatteryRam();
        this.nes.getCpu().requestIrq(2);
    }

    public void latchAccess(int n) {
        boolean bl = n < 4096;
        n &= 0xFF0;
        if (bl) {
            if (n == 4048) {
                this.latchLo = 253;
                this.loadVromBank(this.latchLoVal1, 0);
            } else if (n == 4064) {
                this.latchLo = 254;
                this.loadVromBank(this.latchLoVal2, 0);
            }
        } else if (n == 4048) {
            this.latchHi = 253;
            this.loadVromBank(this.latchHiVal1, 4096);
        } else if (n == 4064) {
            this.latchHi = 254;
            this.loadVromBank(this.latchHiVal2, 4096);
        }
    }

    public void mapperInternalStateLoad(ByteBuffer byteBuffer) {
        super.mapperInternalStateLoad(byteBuffer);
        if (byteBuffer.readByte() == 1) {
            this.latchLo = byteBuffer.readByte();
            this.latchHi = byteBuffer.readByte();
            this.latchLoVal1 = byteBuffer.readByte();
            this.latchLoVal2 = byteBuffer.readByte();
            this.latchHiVal1 = byteBuffer.readByte();
            this.latchHiVal2 = byteBuffer.readByte();
        }
    }

    public void mapperInternalStateSave(ByteBuffer byteBuffer) {
        super.mapperInternalStateSave(byteBuffer);
        byteBuffer.putByte((short)1);
        byteBuffer.putByte((byte)this.latchLo);
        byteBuffer.putByte((byte)this.latchHi);
        byteBuffer.putByte((byte)this.latchLoVal1);
        byteBuffer.putByte((byte)this.latchLoVal2);
        byteBuffer.putByte((byte)this.latchHiVal1);
        byteBuffer.putByte((byte)this.latchHiVal2);
    }

    public void reset() {
        this.latchLo = 254;
        this.latchHi = 254;
        this.latchLoVal1 = 0;
        this.latchLoVal2 = 4;
        this.latchHiVal1 = 0;
        this.latchHiVal2 = 0;
    }
}

