/*
 * Decompiled with CFR 0.152.
 */
public class Mapper007
extends MapperDefault {
    int currentOffset;
    int currentMirroring;
    short[] prgrom;

    public void init(NES nES) {
        super.init(nES);
        this.currentOffset = 0;
        this.currentMirroring = -1;
        ROM rOM = nES.getRom();
        int n = rOM.getRomBankCount();
        this.prgrom = new short[n * 16384];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(rOM.getRomBank(i), 0, this.prgrom, i * 16384, 16384);
        }
    }

    public short load(int n) {
        if (n < 32768) {
            return super.load(n);
        }
        return this.prgrom[n + this.currentOffset];
    }

    public void write(int n, short s) {
        if (n < 32768) {
            super.write(n, s);
        } else {
            this.currentOffset = (s & 0xF) - 1 << 15;
            if (this.currentMirroring != (s & 0x10)) {
                this.currentMirroring = s & 0x10;
                if (this.currentMirroring == 0) {
                    this.nes.getPpu().setMirroring(3);
                } else {
                    this.nes.getPpu().setMirroring(4);
                }
            }
        }
    }

    public void mapperInternalStateLoad(ByteBuffer byteBuffer) {
        super.mapperInternalStateLoad(byteBuffer);
        if (byteBuffer.readByte() == 1) {
            this.currentMirroring = byteBuffer.readByte();
            this.currentOffset = byteBuffer.readInt();
        }
    }

    public void mapperInternalStateSave(ByteBuffer byteBuffer) {
        super.mapperInternalStateSave(byteBuffer);
        byteBuffer.putByte((short)1);
        byteBuffer.putByte((short)this.currentMirroring);
        byteBuffer.putInt(this.currentOffset);
    }

    public void reset() {
        super.reset();
        this.currentOffset = 0;
        this.currentMirroring = -1;
    }
}

