/*
 * Decompiled with CFR 0.152.
 */
public class Mapper004
extends MapperDefault {
    public static final int CMD_SEL_2_1K_VROM_0000 = 0;
    public static final int CMD_SEL_2_1K_VROM_0800 = 1;
    public static final int CMD_SEL_1K_VROM_1000 = 2;
    public static final int CMD_SEL_1K_VROM_1400 = 3;
    public static final int CMD_SEL_1K_VROM_1800 = 4;
    public static final int CMD_SEL_1K_VROM_1C00 = 5;
    public static final int CMD_SEL_ROM_PAGE1 = 6;
    public static final int CMD_SEL_ROM_PAGE2 = 7;
    int command;
    int prgAddressSelect;
    int chrAddressSelect;
    int pageNumber;
    int irqCounter;
    int irqLatchValue;
    int irqEnable;
    boolean prgAddressChanged = false;

    public void init(NES nES) {
        super.init(nES);
    }

    public void mapperInternalStateLoad(ByteBuffer byteBuffer) {
        super.mapperInternalStateLoad(byteBuffer);
        if (byteBuffer.readByte() == 1) {
            this.command = byteBuffer.readInt();
            this.prgAddressSelect = byteBuffer.readInt();
            this.chrAddressSelect = byteBuffer.readInt();
            this.pageNumber = byteBuffer.readInt();
            this.irqCounter = byteBuffer.readInt();
            this.irqLatchValue = byteBuffer.readInt();
            this.irqEnable = byteBuffer.readInt();
            this.prgAddressChanged = byteBuffer.readBoolean();
        }
    }

    public void mapperInternalStateSave(ByteBuffer byteBuffer) {
        super.mapperInternalStateSave(byteBuffer);
        byteBuffer.putByte((short)1);
        byteBuffer.putInt(this.command);
        byteBuffer.putInt(this.prgAddressSelect);
        byteBuffer.putInt(this.chrAddressSelect);
        byteBuffer.putInt(this.pageNumber);
        byteBuffer.putInt(this.irqCounter);
        byteBuffer.putInt(this.irqLatchValue);
        byteBuffer.putInt(this.irqEnable);
        byteBuffer.putBoolean(this.prgAddressChanged);
    }

    public void write(int n, short s) {
        if (n < 32768) {
            super.write(n, s);
            return;
        }
        if (n == 32768) {
            this.command = s & 7;
            int n2 = s >> 6 & 1;
            if (n2 != this.prgAddressSelect) {
                this.prgAddressChanged = true;
            }
            this.prgAddressSelect = n2;
            this.chrAddressSelect = s >> 7 & 1;
        } else if (n == 32769) {
            this.executeCommand(this.command, s);
        } else if (n == 40960) {
            if ((s & 1) != 0) {
                this.nes.getPpu().setMirroring(1);
            } else {
                this.nes.getPpu().setMirroring(0);
            }
        } else if (n == 40961) {
            this.nes.getRom().setSaveState((s & 1) != 0);
        } else if (n == 49152) {
            this.irqCounter = s;
        } else if (n == 49153) {
            this.irqLatchValue = s;
        } else if (n == 57344) {
            this.irqEnable = 0;
        } else if (n == 57345) {
            this.irqEnable = 1;
        }
    }

    public void executeCommand(int n, int n2) {
        if (n == 0) {
            if (this.chrAddressSelect == 0) {
                this.load1kVromBank(n2, 0);
                this.load1kVromBank(n2 + 1, 1024);
            } else {
                this.load1kVromBank(n2, 4096);
                this.load1kVromBank(n2 + 1, 5120);
            }
        } else if (n == 1) {
            if (this.chrAddressSelect == 0) {
                this.load1kVromBank(n2, 2048);
                this.load1kVromBank(n2 + 1, 3072);
            } else {
                this.load1kVromBank(n2, 6144);
                this.load1kVromBank(n2 + 1, 7168);
            }
        } else if (n == 2) {
            if (this.chrAddressSelect == 0) {
                this.load1kVromBank(n2, 4096);
            } else {
                this.load1kVromBank(n2, 0);
            }
        } else if (n == 3) {
            if (this.chrAddressSelect == 0) {
                this.load1kVromBank(n2, 5120);
            } else {
                this.load1kVromBank(n2, 1024);
            }
        } else if (n == 4) {
            if (this.chrAddressSelect == 0) {
                this.load1kVromBank(n2, 6144);
            } else {
                this.load1kVromBank(n2, 2048);
            }
        } else if (n == 5) {
            if (this.chrAddressSelect == 0) {
                this.load1kVromBank(n2, 7168);
            } else {
                this.load1kVromBank(n2, 3072);
            }
        } else if (n == 6) {
            if (this.prgAddressChanged) {
                if (this.prgAddressSelect == 0) {
                    this.load8kRomBank((this.nes.getRom().getRomBankCount() - 1) * 2, 49152);
                } else {
                    this.load8kRomBank((this.nes.getRom().getRomBankCount() - 1) * 2, 32768);
                }
                this.prgAddressChanged = false;
            }
            if (this.prgAddressSelect == 0) {
                this.load8kRomBank(n2, 32768);
            } else {
                this.load8kRomBank(n2, 49152);
            }
        } else if (n == 7) {
            this.load8kRomBank(n2, 40960);
            if (this.prgAddressChanged) {
                if (this.prgAddressSelect == 0) {
                    this.load8kRomBank((this.nes.getRom().getRomBankCount() - 1) * 2, 49152);
                } else {
                    this.load8kRomBank((this.nes.getRom().getRomBankCount() - 1) * 2, 32768);
                }
                this.prgAddressChanged = false;
            }
        }
    }

    public void loadROM(ROM rOM) {
        if (!rOM.isValid()) {
            return;
        }
        this.load8kRomBank((this.nes.getRom().getRomBankCount() - 1) * 2, 49152);
        this.load8kRomBank((this.nes.getRom().getRomBankCount() - 1) * 2 + 1, 57344);
        this.load8kRomBank(0, 32768);
        this.load8kRomBank(1, 40960);
        this.loadCHRROM();
        this.loadBatteryRam();
        this.nes.getCpu().requestIrq(2);
    }

    public void clockIrqCounter() {
        if (this.irqEnable == 1) {
            --this.irqCounter;
            if (this.irqCounter < 0) {
                this.nes.getCpu().requestIrq(0);
                this.irqCounter = this.irqLatchValue;
            }
        }
    }

    public void reset() {
        this.command = 0;
        this.prgAddressSelect = 0;
        this.chrAddressSelect = 0;
        this.pageNumber = 0;
        this.irqCounter = 0;
        this.irqLatchValue = 0;
        this.irqEnable = 0;
        this.prgAddressChanged = false;
    }
}

