/*
 * Decompiled with CFR 0.152.
 */
public class Mapper001
extends MapperDefault {
    int mirroring;
    int oneScreenMirroring;
    int prgSwitchingArea = 1;
    int prgSwitchingSize = 1;
    int vromSwitchingSize;
    int romSelectionReg0;
    int romSelectionReg1;
    int romBankSelect;
    int regBuffer;
    int regBufferCounter;

    public void init(NES nES) {
        super.init(nES);
    }

    public void mapperInternalStateLoad(ByteBuffer byteBuffer) {
        if (byteBuffer.readByte() == 1) {
            this.mirroring = byteBuffer.readInt();
            this.oneScreenMirroring = byteBuffer.readInt();
            this.prgSwitchingArea = byteBuffer.readInt();
            this.prgSwitchingSize = byteBuffer.readInt();
            this.vromSwitchingSize = byteBuffer.readInt();
            this.romSelectionReg0 = byteBuffer.readInt();
            this.romSelectionReg1 = byteBuffer.readInt();
            this.romBankSelect = byteBuffer.readInt();
            this.regBuffer = byteBuffer.readInt();
            this.regBufferCounter = byteBuffer.readInt();
        }
    }

    public void mapperInternalStateSave(ByteBuffer byteBuffer) {
        byteBuffer.putByte((short)1);
        byteBuffer.putInt(this.mirroring);
        byteBuffer.putInt(this.oneScreenMirroring);
        byteBuffer.putInt(this.prgSwitchingArea);
        byteBuffer.putInt(this.prgSwitchingSize);
        byteBuffer.putInt(this.vromSwitchingSize);
        byteBuffer.putInt(this.romSelectionReg0);
        byteBuffer.putInt(this.romSelectionReg1);
        byteBuffer.putInt(this.romBankSelect);
        byteBuffer.putInt(this.regBuffer);
        byteBuffer.putInt(this.regBufferCounter);
    }

    public void write(int n, short s) {
        if (n < 32768) {
            super.write(n, s);
            return;
        }
        if ((s & 0x80) != 0) {
            this.regBufferCounter = 0;
            this.regBuffer = 0;
            if (this.getRegNumber(n) == 0) {
                this.prgSwitchingArea = 1;
                this.prgSwitchingSize = 1;
            }
        } else {
            this.regBuffer = this.regBuffer & 255 - (1 << this.regBufferCounter) | (s & 1) << this.regBufferCounter;
            ++this.regBufferCounter;
            if (this.regBufferCounter == 5) {
                this.setReg(this.getRegNumber(n), this.regBuffer);
                this.regBuffer = 0;
                this.regBufferCounter = 0;
            }
        }
    }

    private void setReg(int n, int n2) {
        if (n == 0) {
            int n3 = n2 & 3;
            if (n3 != this.mirroring) {
                this.mirroring = n3;
                if ((this.mirroring & 2) == 0) {
                    this.nes.getPpu().setMirroring(3);
                } else {
                    this.nes.getPpu().setMirroring((this.mirroring & 1) != 0 ? 1 : 0);
                }
            }
            this.prgSwitchingArea = n2 >> 2 & 1;
            this.prgSwitchingSize = n2 >> 3 & 1;
            this.vromSwitchingSize = n2 >> 4 & 1;
        } else if (n == 1) {
            this.romSelectionReg0 = n2 >> 4 & 1;
            if (this.nes.getRom().getVromBankCount() > 0) {
                if (this.vromSwitchingSize == 0) {
                    if (this.romSelectionReg0 == 0) {
                        this.load8kVromBank(n2 & 0xF, 0);
                    } else {
                        this.load8kVromBank(this.nes.getRom().getVromBankCount() / 2 + (n2 & 0xF), 0);
                    }
                } else if (this.romSelectionReg0 == 0) {
                    this.loadVromBank(n2 & 0xF, 0);
                } else {
                    this.loadVromBank(this.nes.getRom().getVromBankCount() / 2 + (n2 & 0xF), 0);
                }
            }
        } else if (n == 2) {
            this.romSelectionReg1 = n2 >> 4 & 1;
            if (this.nes.getRom().getVromBankCount() > 0 && this.vromSwitchingSize == 1) {
                if (this.romSelectionReg1 == 0) {
                    this.loadVromBank(n2 & 0xF, 4096);
                } else {
                    this.loadVromBank(this.nes.getRom().getVromBankCount() / 2 + (n2 & 0xF), 4096);
                }
            }
        } else {
            int n4 = n2 & 0xF;
            int n5 = 0;
            int n6 = this.nes.getRom().getRomBankCount();
            if (n6 >= 32) {
                if (this.vromSwitchingSize == 0) {
                    if (this.romSelectionReg0 == 1) {
                        n5 = 16;
                    }
                } else {
                    n5 = (this.romSelectionReg0 | this.romSelectionReg1 << 1) << 3;
                }
            } else if (n6 >= 16 && this.romSelectionReg0 == 1) {
                n5 = 8;
            }
            if (this.prgSwitchingSize == 0) {
                int n7 = n5 + (n2 & 0xF);
                this.load32kRomBank(n7, 32768);
            } else {
                int n8 = n5 * 2 + (n2 & 0xF);
                if (this.prgSwitchingArea == 0) {
                    this.loadRomBank(n8, 49152);
                } else {
                    this.loadRomBank(n8, 32768);
                }
            }
        }
    }

    private int getRegNumber(int n) {
        if (n >= 32768 && n <= 40959) {
            return 0;
        }
        if (n >= 40960 && n <= 49151) {
            return 1;
        }
        if (n >= 49152 && n <= 57343) {
            return 2;
        }
        return 3;
    }

    public void loadROM(ROM rOM) {
        if (!rOM.isValid()) {
            return;
        }
        this.loadRomBank(0, 32768);
        this.loadRomBank(rOM.getRomBankCount() - 1, 49152);
        this.loadCHRROM();
        this.loadBatteryRam();
        this.nes.getCpu().requestIrq(2);
    }

    public void reset() {
        this.regBuffer = 0;
        this.regBufferCounter = 0;
        this.mirroring = 0;
        this.oneScreenMirroring = 0;
        this.prgSwitchingArea = 1;
        this.prgSwitchingSize = 1;
        this.vromSwitchingSize = 0;
        this.romSelectionReg0 = 0;
        this.romSelectionReg1 = 0;
        this.romBankSelect = 0;
    }

    private void switchLowHighPrgRom(int n) {
    }

    private void switch16to32() {
    }

    private void switch32to16() {
    }
}

