/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class KbInputHandler
implements KeyListener,
InputHandler {
    boolean[] allKeysState;
    int[] keyMapping;
    int id;
    NES nes;

    public KbInputHandler(NES nES, int n) {
        this.nes = nES;
        this.id = n;
        this.allKeysState = new boolean[255];
        this.keyMapping = new int[8];
    }

    public short getKeyState(int n) {
        return (short)(this.allKeysState[this.keyMapping[n]] ? 65 : 64);
    }

    public void mapKey(int n, int n2) {
        this.keyMapping[n] = n2;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n >= this.allKeysState.length) {
            return;
        }
        this.allKeysState[n] = true;
        if (n == 32 && !this.nes.cpu.isRunning() && !Globals.nsfMode) {
            this.nes.getGui().frameStep();
        }
        if (n == this.keyMapping[6]) {
            this.allKeysState[this.keyMapping[7]] = false;
        } else if (n == this.keyMapping[7]) {
            this.allKeysState[this.keyMapping[6]] = false;
        } else if (n == this.keyMapping[4]) {
            this.allKeysState[this.keyMapping[5]] = false;
        } else if (n == this.keyMapping[5]) {
            this.allKeysState[this.keyMapping[4]] = false;
        }
        if (this.id == 0 && Globals.nsfMode) {
            if (n == 37) {
                this.nes.nsf.prevSong();
                return;
            }
            if (n == 39) {
                this.nes.nsf.nextSong();
                return;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n >= this.allKeysState.length) {
            return;
        }
        this.allKeysState[n] = false;
        if (this.id == 0) {
            switch (n) {
                case 27: {
                    this.nes.getGui().setFullScreen(false);
                    break;
                }
                case 8: {
                    if (!this.nes.isRunning()) break;
                    this.nes.stopEmulation();
                    this.nes.reset();
                    this.nes.reloadRom();
                    this.nes.startEmulation();
                    break;
                }
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void reset() {
        this.allKeysState = new boolean[255];
    }

    public void update() {
    }

    public void destroy() {
        this.nes = null;
    }
}

