/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class GameGenie {
    public static int TYPE_6CHAR = 0;
    public static int TYPE_8CHAR = 1;
    private ArrayList codeList;
    public boolean[] addressMatch;
    private String[] charMapping = new String[]{"a", "p", "z", "l", "g", "i", "t", "y", "e", "o", "x", "u", "k", "s", "v", "n"};
    private int[] lut6charMapping = new int[]{20, 21, 22, 3, 16, 17, 18, 23, 4, 5, 6, 11, 12, 13, 14, 19, 0, 1, 2, 7, 8, 9, 10};
    private int[] lut8charMapping = new int[]{28, 29, 30, 3, 24, 25, 26, 31, 12, 13, 14, 19, 20, 21, 22, 27, 8, 9, 10, 15, 16, 17, 18, 4, 5, 6, 11, 0, 1, 2, 7};

    public GameGenie() {
        this.addressMatch = new boolean[65536];
        this.codeList = new ArrayList();
    }

    public void clearCodes() {
        this.codeList.clear();
        this.updateAddressMatch();
    }

    public void updateAddressMatch() {
        int n;
        for (n = 0; n < this.addressMatch.length; ++n) {
            this.addressMatch[n] = false;
        }
        for (n = 0; n < this.codeList.size(); ++n) {
            this.addressMatch[((GameGenieCode)this.codeList.get((int)n)).address] = true;
        }
    }

    public void addCode(String string) {
        if (string.length() == 6 || string.length() == 8) {
            GameGenieCode gameGenieCode = new GameGenieCode();
            this.codeList.add(gameGenieCode);
            gameGenieCode.type = string.length() == 6 ? TYPE_6CHAR : TYPE_8CHAR;
            gameGenieCode.code = string;
            if (gameGenieCode.type == TYPE_6CHAR) {
                gameGenieCode.address = this.get6charAddress(string);
                gameGenieCode.value = this.get6charValue(string);
            } else {
                gameGenieCode.address = this.get8charAddress(string);
                gameGenieCode.value = this.get8charValue(string);
                gameGenieCode.compare = this.get8charCompare(string);
            }
            this.addressMatch[gameGenieCode.address] = true;
        }
    }

    public void editCode(int n, String string) {
        if (string.length() == 6 || string.length() == 8) {
            GameGenieCode gameGenieCode = (GameGenieCode)this.codeList.get(n);
            gameGenieCode.code = string;
            int n2 = gameGenieCode.type = string.length() == 6 ? TYPE_6CHAR : TYPE_8CHAR;
            if (gameGenieCode.type == TYPE_6CHAR) {
                gameGenieCode.address = this.get6charAddress(string);
                gameGenieCode.value = this.get6charValue(string);
            } else {
                gameGenieCode.address = this.get8charAddress(string);
                gameGenieCode.value = this.get8charValue(string);
                gameGenieCode.compare = this.get8charCompare(string);
            }
            this.updateAddressMatch();
        }
    }

    public void removeCode(int n) {
        this.codeList.remove(n);
        this.updateAddressMatch();
    }

    public int getCodeIndex(int n) {
        for (int i = 0; i < this.codeList.size(); ++i) {
            if (this.getCode((int)i).address != n) continue;
            return i;
        }
        return 0;
    }

    public int getCodeCount() {
        return this.codeList.size();
    }

    public GameGenieCode getCode(int n) {
        return (GameGenieCode)this.codeList.get(n);
    }

    public int getCodeType(int n) {
        return this.getCode((int)n).type;
    }

    public String getCodeString(int n) {
        return this.getCode((int)n).code;
    }

    public int getCodeAddress(int n) {
        return this.getCode((int)n).address;
    }

    public int getCodeValue(int n) {
        return this.getCode((int)n).value;
    }

    public int getCodeCompare(int n) {
        return this.getCode((int)n).compare;
    }

    public long decode6char(String string) {
        long l = this.mapChars(string);
        long l2 = 0L;
        for (int i = 0; i < 23; ++i) {
            l2 |= (l >> this.lut6charMapping[i] & 1L) << i;
        }
        return l2;
    }

    public long decode8char(String string) {
        long l = this.mapChars(string);
        long l2 = 0L;
        for (int i = 0; i < 31; ++i) {
            l2 |= (l >> this.lut8charMapping[i] & 1L) << i;
        }
        return l2;
    }

    public long mapChars(String string) {
        long l = 0L;
        string = string.toLowerCase();
        for (int i = 0; i < string.length(); ++i) {
            l |= (long)(this.getCharNum(string.substring(i, i + 1)) << (string.length() - i - 1) * 4);
        }
        return l;
    }

    public int getCharNum(String string) {
        for (int i = 0; i < this.charMapping.length; ++i) {
            if (!string.equals(this.charMapping[i])) continue;
            return i;
        }
        return 0;
    }

    public int get6charAddress(String string) {
        return (int)((this.decode6char(string) & 0xFFFF00L) >> 8) | 0x8000;
    }

    public int get6charValue(String string) {
        return (int)(this.decode6char(string) & 0xFFL);
    }

    public int get8charAddress(String string) {
        return (int)(this.decode8char(string) >> 8 & 0x7FFFL) | 0x8000;
    }

    public int get8charValue(String string) {
        return (int)(this.decode8char(string) & 0xFFL);
    }

    public int get8charCompare(String string) {
        return (int)(this.decode8char(string) >> 23) & 0xFF;
    }
}

