/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.DisplayMode;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.ViewportLayout;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;

public class GUI
extends JFrame
implements UI,
ActionListener,
MenuListener {
    public static GUI theGui;
    public static File dbgFile;
    public static FileWriter dbgWriter;
    public static boolean showDebug;
    NES nes;
    Container cPane;
    Graphics g;
    Graphics fullScreenGraphics;
    DisplayMode fullscreenMode;
    RomInfoDlg romInfoDlg;
    GameGenieDialog gameGenieDlg;
    PPUViewDialog ppuView;
    ColorSettingsDialog colorDlg;
    VideoModeChooser videoModeChooser;
    JButton btnRun;
    JButton btnReset;
    JMenuBar topMenu;
    JMenu mnuFile;
    JMenuItem mnuLoad;
    JMenuItem mnuLoadState;
    JMenuItem mnuSaveState;
    JMenuItem mnuRomInfo;
    JMenuItem mnuExit;
    JMenu mnuCheat;
    JMenuItem mnuGameGenie;
    JMenu mnuSound;
    JCheckBoxMenuItem mnuSoundEnable;
    JMenu mnuSampleRateParent;
    JMenu mnuSoundChannelParent;
    JCheckBoxMenuItem[] mnuSampleRate;
    JCheckBoxMenuItem[] mnuSoundChannel;
    JMenuItem mnuSoundRecord;
    JCheckBoxMenuItem mnuSoundStereo;
    JMenuItem mnuSoundStereoSettings;
    JMenu mnuVideo;
    JMenu mnuPalette;
    JMenuItem mnuColorSettings;
    JCheckBoxMenuItem mnuEnableScaling;
    JCheckBoxMenuItem mnuHW2XScaling;
    JCheckBoxMenuItem mnuHW3XScaling;
    JCheckBoxMenuItem mnuNormalScaling;
    JCheckBoxMenuItem mnuScanlineScaling;
    JCheckBoxMenuItem mnuRasterScaling;
    JCheckBoxMenuItem mnuFramerate50;
    JCheckBoxMenuItem mnuFramerate60;
    JCheckBoxMenuItem mnuFramerate70;
    JCheckBoxMenuItem mnuClipToTvSize;
    JCheckBoxMenuItem mnuPalNTSC;
    JCheckBoxMenuItem mnuPalPAL;
    JCheckBoxMenuItem mnuPalCustom;
    JMenuItem mnuFullScreen;
    JMenu mnuInput;
    JMenu mnuDebug;
    JMenu mnuMemFlushValue;
    JCheckBoxMenuItem mnuMemFlush0xFF;
    JCheckBoxMenuItem mnuMemFlush0x00;
    JMenuItem mnuDoNMI;
    JMenuItem mnuDumpTile0;
    JCheckBoxMenuItem mnuTimeEmulation;
    JCheckBoxMenuItem mnuShowSpr0Hit;
    JCheckBoxMenuItem mnuShowPatterns;
    JCheckBoxMenuItem mnuShowNameTables;
    JCheckBoxMenuItem mnuShowPalettes;
    JCheckBoxMenuItem mnuShowSoundBuffer;
    JCheckBoxMenuItem mnuShowFPS;
    SoundPanel panelSound;
    JFileChooser filechooser;
    File lastDirectory;
    HiResTimer timer;
    long t1;
    long t2;
    ScreenView panelScreen;
    BufferView panelPatterns;
    BufferView imgPalView;
    BufferView sprPalView;
    BufferView nameTableView;
    private GraphicsEnvironment myEnvironment;
    private GraphicsDevice myDevice;
    private FullScreenWindow fullScreenWindow;
    private BufferStrategy myStrategy;
    private DisplayMode newDisplayMode;
    private DisplayMode oldDisplayMode;
    private boolean isFullScreen;
    private boolean isDisplayChanged;
    private boolean useJoypad = false;
    boolean fullscreenCanceled;
    private int screenW;
    private int screenH;
    KbInputHandler kbJoy1;
    KbInputHandler kbJoy2;
    public Thread myThread;
    public boolean stopRunning;
    String windowCaption;
    int frameTimeExtra = 0;
    int sleepTime;
    int stepSize = 150;
    int audioBufferRem = 0;
    int audioBufferSize = 0;
    int tempBufferSize = 0;
    int soundExtraSleepCounter = 0;
    int soundExtraSleepAmount;
    int timeToSndBufferCheck = 60;

    public GUI() {
        super("vNES");
    }

    public void init(boolean bl) {
        this.nes = new NES(this);
        this.timer = new HiResTimer();
        if (bl) {
            this.addWindowListener(new MyWinAdapter());
            this.setSize(273, 348);
            this.setDefaultCloseOperation(3);
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
        }
        this.cPane = this.getContentPane();
        this.romInfoDlg = new RomInfoDlg(this.nes);
        this.gameGenieDlg = new GameGenieDialog(this.nes.getGameGenie(), this.nes);
        this.colorDlg = new ColorSettingsDialog(this.nes);
        this.initComponents();
        this.ppuView = new PPUViewDialog(this.nes);
        if (bl) {
            this.setVisible(true);
        }
        this.myEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.myDevice = this.myEnvironment.getDefaultScreenDevice();
        this.g = this.cPane.getGraphics();
        this.kbJoy1 = new KbInputHandler(this.nes, 0);
        this.kbJoy2 = new KbInputHandler(this.nes, 1);
        this.panelScreen.setFocusable(true);
        this.kbJoy1.mapKey(0, 90);
        this.kbJoy1.mapKey(1, 88);
        this.kbJoy1.mapKey(2, 10);
        this.kbJoy1.mapKey(3, 17);
        this.kbJoy1.mapKey(4, 38);
        this.kbJoy1.mapKey(5, 40);
        this.kbJoy1.mapKey(6, 37);
        this.kbJoy1.mapKey(7, 39);
        this.panelScreen.addKeyListener(this.kbJoy1);
        this.kbJoy2.mapKey(0, 103);
        this.kbJoy2.mapKey(1, 105);
        this.kbJoy2.mapKey(2, 97);
        this.kbJoy2.mapKey(3, 99);
        this.kbJoy2.mapKey(4, 104);
        this.kbJoy2.mapKey(5, 98);
        this.kbJoy2.mapKey(6, 100);
        this.kbJoy2.mapKey(7, 102);
        this.initBufferViews();
        Scale.setFilterParams(Globals.filterDarkenDepth, Globals.filterBrightenDepth);
    }

    public void initBufferViews() {
        this.panelScreen.init();
        this.panelPatterns.init();
        this.imgPalView.init();
        this.sprPalView.init();
        this.nameTableView.init();
    }

    public void initComponents() {
        int n;
        this.cPane.setLayout(new MyLayoutManager());
        this.cPane.setBackground(Color.gray);
        this.btnRun = new JButton("Run");
        this.btnRun.addActionListener(this);
        this.cPane.add(this.btnRun);
        this.btnRun.setBounds(5, 35, 100, 25);
        this.btnReset = new JButton("Reset");
        this.btnReset.addActionListener(this);
        this.cPane.add(this.btnReset);
        this.btnReset.setBounds(161, 35, 100, 25);
        this.btnReset.setEnabled(false);
        this.panelScreen = new ScreenView(this.nes, 256, 240);
        this.panelScreen.setNotifyImageReady(true);
        this.panelScreen.setBounds(5, 65, 256, 240);
        this.cPane.add(this.panelScreen);
        this.nameTableView = new BufferView(this.nes, 256, 240);
        this.panelPatterns = new BufferView(this.nes, 256, 128);
        this.imgPalView = new BufferView(this.nes, 256, 16);
        this.sprPalView = new BufferView(this.nes, 256, 16);
        this.panelSound = new SoundPanel(this.nes, this);
        this.topMenu = new JMenuBar();
        this.topMenu.setBounds(0, 0, 590, 30);
        this.cPane.add(this.topMenu);
        this.mnuFile = new JMenu("File");
        this.mnuFile.addMenuListener(this);
        this.topMenu.add(this.mnuFile);
        this.mnuLoad = new JMenuItem("Load ROM..");
        this.mnuLoad.addActionListener(this);
        this.mnuFile.add(this.mnuLoad);
        this.mnuFile.addSeparator();
        this.mnuLoadState = new JMenuItem("Load State (buggy!)");
        this.mnuLoadState.setEnabled(false);
        this.mnuLoadState.addActionListener(this);
        this.mnuFile.add(this.mnuLoadState);
        this.mnuSaveState = new JMenuItem("Save State (buggy!)");
        this.mnuSaveState.setEnabled(false);
        this.mnuSaveState.addActionListener(this);
        this.mnuFile.add(this.mnuSaveState);
        this.mnuFile.addSeparator();
        this.mnuRomInfo = new JMenuItem("ROM Info");
        this.mnuRomInfo.addActionListener(this);
        this.mnuFile.add(this.mnuRomInfo);
        this.mnuFile.addSeparator();
        this.mnuExit = new JMenuItem("Exit");
        this.mnuExit.addActionListener(this);
        this.mnuFile.add(this.mnuExit);
        this.mnuCheat = new JMenu("Cheat");
        this.topMenu.add(this.mnuCheat);
        this.mnuCheat.addMenuListener(this);
        this.mnuGameGenie = new JMenuItem("Game Genie..");
        this.mnuGameGenie.addActionListener(this);
        this.mnuCheat.add(this.mnuGameGenie);
        this.mnuInput = new JMenu("Input");
        this.topMenu.add(this.mnuInput);
        this.mnuInput.addMenuListener(this);
        this.mnuVideo = new JMenu("Video");
        this.topMenu.add(this.mnuVideo);
        this.mnuVideo.addMenuListener(this);
        this.mnuEnableScaling = new JCheckBoxMenuItem("Enable Scaling");
        this.mnuEnableScaling.addActionListener(this);
        this.mnuVideo.add(this.mnuEnableScaling);
        this.mnuVideo.addSeparator();
        this.mnuHW2XScaling = new JCheckBoxMenuItem("Hardware 2X");
        this.mnuHW2XScaling.setState(true);
        this.mnuHW2XScaling.addActionListener(this);
        this.mnuHW2XScaling.setEnabled(false);
        this.mnuVideo.add(this.mnuHW2XScaling);
        this.mnuHW3XScaling = new JCheckBoxMenuItem("Hardware 3X");
        this.mnuHW3XScaling.addActionListener(this);
        this.mnuHW3XScaling.setEnabled(false);
        this.mnuVideo.add(this.mnuHW3XScaling);
        this.mnuVideo.addSeparator();
        this.mnuNormalScaling = new JCheckBoxMenuItem("Pixel Doubling");
        this.mnuNormalScaling.addActionListener(this);
        this.mnuNormalScaling.setEnabled(false);
        this.mnuVideo.add(this.mnuNormalScaling);
        this.mnuScanlineScaling = new JCheckBoxMenuItem("Scanline Effect");
        this.mnuScanlineScaling.addActionListener(this);
        this.mnuScanlineScaling.setEnabled(false);
        this.mnuVideo.add(this.mnuScanlineScaling);
        this.mnuRasterScaling = new JCheckBoxMenuItem("Raster Effect");
        this.mnuRasterScaling.addActionListener(this);
        this.mnuRasterScaling.setEnabled(false);
        this.mnuVideo.add(this.mnuRasterScaling);
        this.mnuVideo.addSeparator();
        this.mnuFramerate50 = new JCheckBoxMenuItem("50 FPS (PAL)");
        this.mnuFramerate60 = new JCheckBoxMenuItem("60 FPS (NTSC)");
        this.mnuFramerate70 = new JCheckBoxMenuItem("70 FPS");
        this.mnuFramerate50.setState(false);
        this.mnuFramerate60.setState(true);
        this.mnuFramerate70.setState(false);
        this.mnuFramerate50.addActionListener(this);
        this.mnuFramerate60.addActionListener(this);
        this.mnuFramerate70.addActionListener(this);
        this.mnuVideo.add(this.mnuFramerate50);
        this.mnuVideo.add(this.mnuFramerate60);
        this.mnuVideo.add(this.mnuFramerate70);
        this.mnuVideo.addSeparator();
        this.mnuPalette = new JMenu("Palette");
        this.mnuVideo.add(this.mnuPalette);
        this.mnuPalNTSC = new JCheckBoxMenuItem("NTSC", true);
        this.mnuPalPAL = new JCheckBoxMenuItem("PAL");
        this.mnuPalCustom = new JCheckBoxMenuItem("Custom..");
        this.mnuPalette.add(this.mnuPalNTSC);
        this.mnuPalette.add(this.mnuPalPAL);
        this.mnuPalette.add(this.mnuPalCustom);
        this.mnuPalNTSC.addActionListener(this);
        this.mnuPalPAL.addActionListener(this);
        this.mnuPalCustom.addActionListener(this);
        this.mnuColorSettings = new JMenuItem("Color Settings..");
        this.mnuColorSettings.addActionListener(this);
        this.mnuVideo.add(this.mnuColorSettings);
        this.mnuClipToTvSize = new JCheckBoxMenuItem("Clip to TV size");
        this.mnuClipToTvSize.addActionListener(this);
        this.mnuClipToTvSize.setState(true);
        this.mnuVideo.add(this.mnuClipToTvSize);
        this.mnuVideo.addSeparator();
        this.mnuFullScreen = new JMenuItem("Fullscreen");
        this.mnuFullScreen.addActionListener(this);
        this.mnuVideo.add(this.mnuFullScreen);
        this.mnuSound = new JMenu("Sound");
        this.topMenu.add(this.mnuSound);
        this.mnuSound.addMenuListener(this);
        this.mnuSoundEnable = new JCheckBoxMenuItem("Enable Sound");
        this.mnuSoundEnable.addActionListener(this);
        this.mnuSoundEnable.setState(true);
        this.mnuSound.add(this.mnuSoundEnable);
        this.mnuSound.addSeparator();
        this.mnuSampleRateParent = new JMenu("Sample Rate");
        this.mnuSound.add(this.mnuSampleRateParent);
        this.mnuSampleRate = new JCheckBoxMenuItem[3];
        this.mnuSampleRate[0] = new JCheckBoxMenuItem("44100 Hz");
        this.mnuSampleRate[1] = new JCheckBoxMenuItem("22050 Hz");
        this.mnuSampleRate[2] = new JCheckBoxMenuItem("11025 Hz");
        for (n = 0; n < 3; ++n) {
            this.mnuSampleRate[n].setState(false);
            this.mnuSampleRate[n].addActionListener(this);
            this.mnuSampleRateParent.add(this.mnuSampleRate[n]);
        }
        this.mnuSampleRate[0].setState(true);
        this.mnuSoundChannelParent = new JMenu("Sound Channels");
        this.mnuSound.add(this.mnuSoundChannelParent);
        this.mnuSoundChannel = new JCheckBoxMenuItem[5];
        this.mnuSoundChannel[0] = new JCheckBoxMenuItem("Square 1");
        this.mnuSoundChannel[1] = new JCheckBoxMenuItem("Square 2");
        this.mnuSoundChannel[2] = new JCheckBoxMenuItem("Triangle");
        this.mnuSoundChannel[3] = new JCheckBoxMenuItem("Noise");
        this.mnuSoundChannel[4] = new JCheckBoxMenuItem("DMC");
        for (n = 0; n < 5; ++n) {
            this.mnuSoundChannel[n].setState(true);
            this.mnuSoundChannel[n].addActionListener(this);
            this.mnuSoundChannelParent.add(this.mnuSoundChannel[n]);
        }
        this.mnuSound.addSeparator();
        this.mnuSoundStereo = new JCheckBoxMenuItem("Enable Stereo");
        this.mnuSoundStereo.setState(true);
        this.mnuSoundStereo.addActionListener(this);
        this.mnuSound.add(this.mnuSoundStereo);
        this.mnuSoundStereoSettings = new JMenuItem("   Panning..");
        this.mnuSoundStereoSettings.addActionListener(this);
        this.mnuSound.add(this.mnuSoundStereoSettings);
        this.mnuSound.addSeparator();
        this.mnuSoundRecord = new JMenuItem("Start Recording..");
        this.mnuSoundRecord.addActionListener(this);
        this.mnuSound.add(this.mnuSoundRecord);
        this.mnuDebug = new JMenu("Debug");
        this.topMenu.add(this.mnuDebug);
        this.mnuDebug.addMenuListener(this);
        this.mnuTimeEmulation = new JCheckBoxMenuItem("Time Emulation");
        this.mnuTimeEmulation.addActionListener(this);
        this.mnuTimeEmulation.setState(true);
        this.mnuDebug.add(this.mnuTimeEmulation);
        this.mnuDebug.addSeparator();
        this.mnuMemFlushValue = new JMenu("Mem Flush Value");
        this.mnuDebug.add(this.mnuMemFlushValue);
        this.mnuMemFlush0xFF = new JCheckBoxMenuItem("Flush to 0xFF", true);
        this.mnuMemFlush0x00 = new JCheckBoxMenuItem("Flush to 0x00");
        this.mnuMemFlush0xFF.addActionListener(this);
        this.mnuMemFlush0x00.addActionListener(this);
        this.mnuMemFlushValue.add(this.mnuMemFlush0xFF);
        this.mnuMemFlushValue.add(this.mnuMemFlush0x00);
        this.mnuDebug.addSeparator();
        this.mnuShowFPS = new JCheckBoxMenuItem("Show FPS");
        this.mnuShowFPS.setState(false);
        this.mnuShowFPS.addActionListener(this);
        this.mnuDebug.add(this.mnuShowFPS);
        this.mnuShowSoundBuffer = new JCheckBoxMenuItem("Show Sound Buffer");
        this.mnuShowSoundBuffer.addActionListener(this);
        this.mnuDebug.add(this.mnuShowSoundBuffer);
        this.mnuShowPatterns = new JCheckBoxMenuItem("Show Pattern Tables");
        this.mnuShowPatterns.addActionListener(this);
        this.mnuDebug.add(this.mnuShowPatterns);
        this.mnuShowNameTables = new JCheckBoxMenuItem("Show Name Tables");
        this.mnuShowNameTables.addActionListener(this);
        this.mnuDebug.add(this.mnuShowNameTables);
        this.mnuShowPalettes = new JCheckBoxMenuItem("Show Palettes");
        this.mnuShowPalettes.addActionListener(this);
        this.mnuDebug.add(this.mnuShowPalettes);
        this.mnuShowSpr0Hit = new JCheckBoxMenuItem("Show Spr#0 Hit Pos");
        this.mnuShowSpr0Hit.addActionListener(this);
        this.mnuDebug.add(this.mnuShowSpr0Hit);
        this.mnuDebug.addSeparator();
        this.mnuDoNMI = new JMenuItem("Do NMI (VBlank)");
        this.mnuDoNMI.addActionListener(this);
        this.mnuDebug.add(this.mnuDoNMI);
        this.mnuDumpTile0 = new JMenuItem("Dump Sprite #0 Tile data");
        this.mnuDumpTile0.addActionListener(this);
        this.mnuDebug.add(this.mnuDumpTile0);
        this.disableComponents();
    }

    public void imageReady(boolean bl) {
        if (!bl && this.isFullScreen) {
            this.fullScreenGraphics.drawImage(this.panelScreen.getImage(), this.screenW - this.panelScreen.getWidth() >> 1, this.screenH - this.panelScreen.getHeight() >> 1, null);
            this.panelScreen.paintFPS((this.screenW - this.panelScreen.getWidth()) / 2 + 10, (this.screenH - this.panelScreen.getHeight()) / 2 + 20, this.fullScreenGraphics);
        }
        int n = this.nes.getPapu().bufferIndex;
        if (Globals.enableSound && Globals.timeEmulation && n > 0) {
            if (Globals.nsfMode) {
                int n2 = this.nes.getPapu().line.getBufferSize() / 2;
                this.timer.sleepMillisIdle(this.nes.papu.getMillisToAvailableAbove(n2));
                while (this.nes.getPapu().line.available() < n2) {
                    this.timer.sleepMillisIdle(10);
                }
            } else {
                int n3 = this.nes.getPapu().line.getBufferSize() - 3 * n;
                int n4 = this.nes.papu.getMillisToAvailableAbove(n3);
                this.timer.sleepMicros(0L);
                while (this.nes.getPapu().line.available() < n3) {
                    this.timer.yield();
                }
            }
            this.nes.getPapu().writeBuffer();
        }
        if (Globals.frameStep) {
            this.nes.stopEmulation();
        }
        if (Globals.timeEmulation && !Globals.enableSound) {
            this.sleepTime = Globals.frameTime;
            this.t2 = this.timer.currentMicros();
            if (this.t2 - this.t1 < (long)this.sleepTime) {
                this.timer.sleepMicros((long)this.sleepTime - (this.t2 - this.t1));
            }
        }
        this.t1 = this.t2;
    }

    public void frameStep() {
        Globals.frameStep = true;
        this.nes.startEmulation();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ActionHandlerThread actionHandlerThread = new ActionHandlerThread(actionEvent);
        actionHandlerThread.start();
    }

    public void actionPerformed_(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        Thread.currentThread().setPriority(1);
        this.nes.ppu.invalidateFrameCache();
        if (object == this.btnRun) {
            if (this.btnRun.getText().equals("Run")) {
                Globals.frameStep = false;
                this.startEmulation();
            } else {
                this.stopEmulation();
            }
        } else if (object == this.btnReset) {
            this.stopEmulation();
            this.nes.reset();
            this.nes.reloadRom();
            this.startEmulation();
        } else if (object == this.mnuLoad) {
            this.loadRom();
        } else if (object == this.mnuLoadState) {
            boolean bl = this.nes.cpu.isRunning();
            this.nes.stopEmulation();
            this.loadState(0);
            if (bl) {
                this.nes.startEmulation();
            }
        } else if (object == this.mnuSaveState) {
            this.saveState(0);
        } else if (object == this.mnuExit) {
            GUI.stopDbgLogging();
            this.stopEmulation();
            this.nes.getPapu().stop();
            if (this.nes.getRom() != null) {
                this.nes.getRom().closeRom();
            }
            this.destroy();
            System.exit(0);
        } else if (object == this.mnuSoundEnable) {
            int n;
            this.nes.enableSound(this.mnuSoundEnable.getState());
            for (n = 0; n < this.mnuSoundChannel.length; ++n) {
                this.mnuSoundChannel[n].setEnabled(this.mnuSoundEnable.getState());
            }
            for (n = 0; n < this.mnuSampleRate.length; ++n) {
                this.mnuSampleRate[n].setEnabled(this.mnuSoundEnable.getState());
            }
            this.mnuSoundStereo.setEnabled(this.mnuSoundEnable.getState());
            this.mnuSoundChannelParent.setEnabled(this.mnuSoundEnable.getState());
            this.mnuSampleRateParent.setEnabled(this.mnuSoundEnable.getState());
            this.mnuSoundRecord.setEnabled(this.mnuSoundEnable.getState());
        } else if (object == this.mnuSoundStereo) {
            this.nes.getPapu().setStereo(this.mnuSoundStereo.getState(), true);
        } else if (object == this.mnuSoundStereoSettings) {
            this.panelSound.setVisible(true);
        } else if (object == this.mnuSoundRecord) {
            if (!Globals.recordingAudio) {
                if (this.startRecordingAudio()) {
                    this.mnuSoundRecord.setText("- Stop Recording -");
                }
            } else {
                this.stopRecordingAudio();
                this.mnuSoundRecord.setText("Start Recording..");
            }
        } else if (object == this.mnuRomInfo) {
            this.romInfoDlg.init(this.nes.getRom());
            this.romInfoDlg.setVisible(true);
        } else if (object == this.mnuGameGenie) {
            this.gameGenieDlg.setVisible(true);
            this.gameGenieDlg.setLocation(this.getX() + this.getWidth(), this.getY());
        } else if (object == this.mnuEnableScaling) {
            this.mnuHW2XScaling.setEnabled(this.mnuEnableScaling.getState());
            this.mnuHW3XScaling.setEnabled(this.mnuEnableScaling.getState());
            this.mnuNormalScaling.setEnabled(this.mnuEnableScaling.getState());
            this.mnuScanlineScaling.setEnabled(this.mnuEnableScaling.getState());
            this.mnuRasterScaling.setEnabled(this.mnuEnableScaling.getState());
            if (this.mnuEnableScaling.getState()) {
                int n = 2;
                if (this.mnuHW2XScaling.getState()) {
                    this.panelScreen.setScaleMode(1);
                } else if (this.mnuHW3XScaling.getState()) {
                    this.panelScreen.setScaleMode(2);
                    n = 3;
                } else if (this.mnuNormalScaling.getState()) {
                    this.panelScreen.setScaleMode(3);
                } else if (this.mnuScanlineScaling.getState()) {
                    this.panelScreen.setScaleMode(4);
                } else if (this.mnuRasterScaling.getState()) {
                    this.panelScreen.setScaleMode(5);
                }
                if (!Globals.guiMaximized) {
                    this.setSize(17 + 256 * n, 103 + 240 * n);
                }
            } else {
                if (!Globals.guiMaximized) {
                    this.setSize(273, 343);
                }
                this.panelScreen.setScaleMode(0);
            }
            this.validate();
        } else if (object == this.mnuHW2XScaling) {
            this.mnuHW2XScaling.setState(true);
            this.mnuHW3XScaling.setState(false);
            this.mnuNormalScaling.setState(false);
            this.mnuScanlineScaling.setState(false);
            this.mnuRasterScaling.setState(false);
            this.setSize(529, 583);
            this.panelScreen.setScaleMode(1);
        } else if (object == this.mnuHW3XScaling) {
            this.mnuHW2XScaling.setState(false);
            this.mnuHW3XScaling.setState(true);
            this.mnuNormalScaling.setState(false);
            this.mnuScanlineScaling.setState(false);
            this.mnuRasterScaling.setState(false);
            this.setSize(785, 823);
            this.panelScreen.setScaleMode(2);
        } else if (object == this.mnuNormalScaling) {
            this.mnuHW2XScaling.setState(false);
            this.mnuHW3XScaling.setState(false);
            this.mnuNormalScaling.setState(true);
            this.mnuScanlineScaling.setState(false);
            this.mnuRasterScaling.setState(false);
            this.setSize(529, 583);
            this.panelScreen.setScaleMode(3);
        } else if (object == this.mnuScanlineScaling) {
            this.mnuHW2XScaling.setState(false);
            this.mnuHW3XScaling.setState(false);
            this.mnuNormalScaling.setState(false);
            this.mnuScanlineScaling.setState(true);
            this.mnuRasterScaling.setState(false);
            this.setSize(529, 583);
            this.panelScreen.setScaleMode(4);
        } else if (object == this.mnuRasterScaling) {
            this.mnuHW2XScaling.setState(false);
            this.mnuHW3XScaling.setState(false);
            this.mnuNormalScaling.setState(false);
            this.mnuScanlineScaling.setState(false);
            this.mnuRasterScaling.setState(true);
            this.setSize(529, 583);
            this.panelScreen.setScaleMode(5);
        } else if (object == this.mnuFramerate50) {
            this.mnuFramerate50.setState(true);
            this.mnuFramerate60.setState(false);
            this.mnuFramerate70.setState(false);
            this.nes.setFramerate(50);
        } else if (object == this.mnuFramerate60) {
            this.mnuFramerate50.setState(false);
            this.mnuFramerate60.setState(true);
            this.mnuFramerate70.setState(false);
            this.nes.setFramerate(60);
        } else if (object == this.mnuFramerate70) {
            this.mnuFramerate50.setState(false);
            this.mnuFramerate60.setState(false);
            this.mnuFramerate70.setState(true);
            this.nes.setFramerate(70);
        } else if (object == this.mnuColorSettings) {
            this.colorDlg.setVisible(true);
            this.colorDlg.setLocation(this.getX() + this.getWidth(), this.getY());
        } else if (object == this.mnuPalNTSC) {
            if (this.nes.palTable.loadNTSCPalette()) {
                this.mnuPalNTSC.setSelected(true);
                this.mnuPalPAL.setSelected(false);
                this.mnuPalCustom.setSelected(false);
                this.nes.ppu.updatePalettes();
            }
        } else if (object == this.mnuPalPAL) {
            if (this.nes.palTable.loadPALPalette()) {
                this.mnuPalNTSC.setSelected(false);
                this.mnuPalPAL.setSelected(true);
                this.mnuPalCustom.setSelected(false);
                this.nes.ppu.updatePalettes();
            }
        } else if (object == this.mnuPalCustom) {
            if (this.loadCustomPalette()) {
                this.mnuPalNTSC.setSelected(false);
                this.mnuPalPAL.setSelected(false);
                this.mnuPalCustom.setSelected(true);
                this.nes.ppu.updatePalettes();
            }
        } else if (object == this.mnuClipToTvSize) {
            this.nes.ppu.clipToTvSize = this.mnuClipToTvSize.getState();
        } else if (object == this.mnuFullScreen) {
            if (this.videoModeChooser == null) {
                this.videoModeChooser = new VideoModeChooser(this);
            }
            this.videoModeChooser.setModal(true);
            this.videoModeChooser.setVisible(true);
            if (!this.fullscreenCanceled) {
                this.setFullScreen(true);
            }
        } else if (object == this.mnuMemFlush0xFF) {
            Globals.memoryFlushValue = (short)255;
            this.mnuMemFlush0xFF.setSelected(true);
            this.mnuMemFlush0x00.setSelected(false);
        } else if (object == this.mnuMemFlush0x00) {
            Globals.memoryFlushValue = 0;
            this.mnuMemFlush0xFF.setSelected(false);
            this.mnuMemFlush0x00.setSelected(true);
        } else if (object == this.mnuTimeEmulation) {
            Globals.timeEmulation = this.mnuTimeEmulation.getState();
        } else if (object == this.mnuShowPatterns) {
            Globals.showPatterns = this.mnuShowPatterns.getState();
            if (Globals.showPatterns) {
                this.ppuView.setVisible(true);
            }
        } else if (object == this.mnuShowNameTables) {
            Globals.showNameTables = this.mnuShowNameTables.getState();
            if (Globals.showNameTables) {
                this.ppuView.setVisible(true);
            }
        } else if (object == this.mnuShowPalettes) {
            Globals.showPalettes = this.mnuShowPalettes.getState();
            if (Globals.showPalettes) {
                this.ppuView.setVisible(true);
            }
        } else if (object == this.mnuDoNMI) {
            this.nes.getPpu().doNMI();
        } else if (object == this.mnuDumpTile0) {
            this.nes.getPpu().ptTile[this.nes.getPpu().sprTile[0]].dumpData("tile0data.txt");
            this.nes.getPpu().ptTile[this.nes.getPpu().sprTile[0] + 256].dumpData("tile0data2.txt");
        } else if (object == this.mnuShowSpr0Hit) {
            this.nes.getPpu().showSpr0Hit = this.mnuShowSpr0Hit.getState();
        } else if (object == this.mnuShowFPS) {
            this.panelScreen.setFPSEnabled(this.mnuShowFPS.getState());
            if (!this.mnuShowFPS.getState()) {
                this.setTitle(this.windowCaption);
            }
        } else if (object == this.mnuShowSoundBuffer) {
            this.nes.getPpu().showSoundBuffer = this.mnuShowSoundBuffer.getState();
        } else {
            int n;
            for (n = 0; n < this.mnuSoundChannel.length; ++n) {
                if (object != this.mnuSoundChannel[n]) continue;
                this.nes.getPapu().setChannelEnabled(n, this.mnuSoundChannel[n].getState());
                return;
            }
            for (n = 0; n < this.mnuSampleRate.length; ++n) {
                if (object != this.mnuSampleRate[n]) continue;
                this.mnuSampleRate[n].setState(true);
                for (int i = 0; i < this.mnuSampleRate.length; ++i) {
                    if (i == n) continue;
                    this.mnuSampleRate[i].setState(false);
                }
                this.nes.papu.setSampleRate(11025 << this.mnuSampleRate.length - n - 1, true);
                return;
            }
        }
    }

    public void loadRom() {
        if (this.filechooser == null) {
            this.filechooser = new JFileChooser();
        }
        this.filechooser.setDialogTitle("Load ROM File..");
        this.filechooser.setAcceptAllFileFilterUsed(true);
        MyRomFileFilter myRomFileFilter = new MyRomFileFilter();
        this.filechooser.addChoosableFileFilter(myRomFileFilter);
        if (this.lastDirectory != null) {
            this.filechooser.setCurrentDirectory(this.lastDirectory);
        }
        int n = this.filechooser.showOpenDialog(this);
        this.filechooser.removeChoosableFileFilter(myRomFileFilter);
        if (n == 0 && this.filechooser.getSelectedFile() != null) {
            this.lastDirectory = this.filechooser.getCurrentDirectory();
            String string = this.filechooser.getSelectedFile().getAbsolutePath();
            boolean bl = this.nes.isRunning();
            this.stopEmulation();
            if (!this.nes.loadRom(string)) {
                this.showErrorMsg("Invalid ROM file!");
                this.disableComponents();
                return;
            }
            this.windowCaption = "vNES - " + this.filechooser.getSelectedFile().getName();
            this.setTitle(this.windowCaption);
            this.enableComponents();
            if (bl) {
                this.startEmulation();
            }
        }
    }

    public boolean loadCustomPalette() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Open palette file..");
        int n = jFileChooser.showOpenDialog((GUI)Globals.nes.getGui());
        if (n == 0 && jFileChooser.getSelectedFile() != null) {
            return this.nes.palTable.loadPalette(jFileChooser.getSelectedFile().getAbsolutePath());
        }
        return true;
    }

    public boolean startRecordingAudio() {
        if (this.filechooser == null) {
            this.filechooser = new JFileChooser();
        }
        this.filechooser.setDialogTitle("Choose file for audio recording..");
        this.filechooser.setFileFilter(new MyWavFileFilter());
        int n = this.filechooser.showSaveDialog(this);
        if (n == 0 && this.filechooser.getSelectedFile() != null && this.nes.papu.startRecording(this.filechooser.getSelectedFile())) {
            Globals.recordingAudio = true;
            return true;
        }
        return false;
    }

    public void stopRecordingAudio() {
        this.nes.papu.stopRecording();
        Globals.recordingAudio = false;
    }

    public NES getNES() {
        return this.nes;
    }

    public BufferView getScreenView() {
        return this.panelScreen;
    }

    public BufferView getPatternView() {
        return this.panelPatterns;
    }

    public BufferView getSprPalView() {
        return this.sprPalView;
    }

    public BufferView getNameTableView() {
        return this.nameTableView;
    }

    public BufferView getImgPalView() {
        return this.imgPalView;
    }

    public String getWindowCaption() {
        return this.windowCaption;
    }

    public void setWindowCaption(String string) {
        this.windowCaption = string;
    }

    public void setTitle(String string) {
        super.setTitle(string);
    }

    public InputHandler getJoy1() {
        return this.kbJoy1;
    }

    public InputHandler getJoy2() {
        return this.kbJoy2;
    }

    public void startEmulation() {
        this.nes.startEmulation();
        this.btnRun.setText("Stop");
        this.btnReset.setEnabled(true);
        this.cPane.setBackground(Color.black);
        this.mnuSaveState.setEnabled(true);
        this.panelScreen.setUsingMenu(false);
        this.panelScreen.requestFocus();
    }

    public void stopEmulation() {
        this.nes.stopEmulation();
        this.btnRun.setText("Run");
        this.cPane.setBackground(Color.gray);
        this.btnReset.setEnabled(false);
    }

    public void enableComponents() {
        this.btnRun.setEnabled(true);
        this.mnuRomInfo.setEnabled(true);
        this.mnuLoadState.setEnabled(true);
    }

    public void disableComponents() {
        this.btnRun.setEnabled(false);
        this.btnReset.setEnabled(false);
        this.mnuRomInfo.setEnabled(false);
        this.mnuLoadState.setEnabled(false);
        this.mnuSaveState.setEnabled(false);
    }

    public void setFullScreen(boolean bl) {
        if (bl) {
            if (!this.isFullScreen() && this.fullscreenMode != null) {
                int n = this.fullscreenMode.getWidth();
                int n2 = this.fullscreenMode.getHeight();
                int n3 = this.fullscreenMode.getBitDepth();
                int n4 = this.fullscreenMode.getRefreshRate();
                this.switchToFullScreen(this.fullscreenMode);
            }
        } else if (this.isFullScreen()) {
            this.switchFromFullScreen();
        }
    }

    public void showLoadProgress(int n) {
        this.setWindowCaption("Loading.. " + n + "%");
    }

    public int getRomFileSize() {
        return 0;
    }

    public void println(String string) {
    }

    public static void stopDbgLogging() {
    }

    public void switchToFullScreen(DisplayMode displayMode) {
        if (this.myDevice.isFullScreenSupported()) {
            this.fullScreenWindow = new FullScreenWindow(displayMode.getWidth(), displayMode.getHeight());
            this.fullScreenWindow.addKbInput((InputHandler)this.kbJoy1);
            this.fullScreenWindow.setBackground(Color.darkGray);
            this.fullScreenWindow.setIgnoreRepaint(false);
            this.fullScreenWindow.setResizable(false);
            this.fullScreenWindow.setLayout(null);
            this.fullScreenWindow.setSize(displayMode.getWidth(), displayMode.getHeight());
            this.fullScreenWindow.setUndecorated(true);
            this.fullScreenWindow.setBackground(Color.black);
            this.fullScreenWindow.setVisible(true);
            this.fullScreenWindow.toFront();
            this.fullScreenGraphics = this.fullScreenWindow.getGraphics();
            try {
                this.myDevice.setFullScreenWindow((Window)this.fullScreenWindow);
                this.fullScreenWindow.validate();
            }
            catch (Exception exception) {
                this.fullScreenWindow.removeKeyListener((KeyListener)this.kbJoy1);
                this.fullScreenWindow.dispose();
                this.fullScreenWindow = null;
                this.isFullScreen = false;
                return;
            }
            if (this.myDevice.isDisplayChangeSupported()) {
                this.isDisplayChanged = true;
                this.oldDisplayMode = this.myDevice.getDisplayMode();
                try {
                    this.myDevice.setDisplayMode(displayMode);
                }
                catch (Exception exception) {
                    this.myDevice.setFullScreenWindow(null);
                    this.fullScreenWindow.removeKeyListener((KeyListener)this.kbJoy1);
                    this.fullScreenWindow.dispose();
                    this.fullScreenWindow = null;
                    this.isFullScreen = false;
                    return;
                }
            } else {
                this.fullScreenWindow.removeKeyListener((KeyListener)this.kbJoy1);
                this.fullScreenWindow.dispose();
                this.fullScreenWindow = null;
                this.isFullScreen = false;
                return;
            }
            this.screenW = displayMode.getWidth();
            this.screenH = displayMode.getHeight();
            this.fullScreenWindow.setVisible(true);
            this.isFullScreen = true;
            Graphics graphics = this.fullScreenWindow.getGraphics();
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, this.screenW, this.screenH);
        } else {
            this.isFullScreen = false;
        }
    }

    public void switchFromFullScreen() {
        if (this.isFullScreen) {
            this.myDevice.setDisplayMode(this.oldDisplayMode);
            this.myDevice.setFullScreenWindow(null);
            this.fullScreenWindow.setSize(400, 300);
            this.fullScreenWindow.setVisible(false);
            this.isFullScreen = false;
        }
    }

    public void showErrorMsg(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    public boolean isFullScreen() {
        return this.isFullScreen;
    }

    public HiResTimer getTimer() {
        return this.timer;
    }

    public void menuCanceled(MenuEvent menuEvent) {
        this.panelScreen.setUsingMenu(false);
    }

    public void menuSelected(MenuEvent menuEvent) {
        this.panelScreen.setUsingMenu(true);
    }

    public void menuDeselected(MenuEvent menuEvent) {
        this.panelScreen.setUsingMenu(false);
    }

    public void loadState(int n) {
        ByteBuffer byteBuffer;
        if (this.nes.getRom() == null) {
            return;
        }
        String string = this.nes.getRom().getFileName();
        String string2 = "state/" + string.substring(0, string.length() - 4) + n + ".sta";
        File file = new File(string2);
        if (!file.exists() || this.nes.stateLoad(byteBuffer = ByteBuffer.readFromZipFile(file))) {
            // empty if block
        }
    }

    public void saveState(int n) {
        if (this.nes.getRom() == null) {
            return;
        }
        String string = this.nes.getRom().getFileName();
        String string2 = "state/" + string.substring(0, string.length() - 4) + n + ".sta";
        File file = new File(string2);
        File file2 = new File("./state/");
        if (!file2.exists()) {
            file2.mkdir();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        }
        ByteBuffer byteBuffer = new ByteBuffer(500000, 0);
        byteBuffer.setExpandable(true);
        this.nes.stateSave(byteBuffer);
        byteBuffer.resizeToCurrentPos();
        ByteBuffer.saveToZipFile(file, byteBuffer);
    }

    public void destroy() {
        if (this.nes != null) {
            this.nes.destroy();
        }
        if (this.romInfoDlg != null) {
            this.romInfoDlg.destroy();
        }
        if (this.gameGenieDlg != null) {
            this.gameGenieDlg.destroy();
        }
        if (this.ppuView != null) {
            this.ppuView.destroy();
        }
        if (this.colorDlg != null) {
            this.colorDlg.destroy();
        }
        if (this.panelScreen != null) {
            this.panelScreen.destroy();
        }
        if (this.panelPatterns != null) {
            this.panelPatterns.destroy();
        }
        if (this.imgPalView != null) {
            this.imgPalView.destroy();
        }
        if (this.sprPalView != null) {
            this.sprPalView.destroy();
        }
        if (this.nameTableView != null) {
            this.nameTableView.destroy();
        }
        if (this.kbJoy1 != null) {
            this.kbJoy1.destroy();
        }
        if (this.kbJoy2 != null) {
            this.kbJoy2.destroy();
        }
        this.nes = null;
        this.romInfoDlg = null;
        this.gameGenieDlg = null;
        this.ppuView = null;
        this.colorDlg = null;
        this.timer = null;
        this.panelScreen = null;
        this.panelPatterns = null;
        this.imgPalView = null;
        this.sprPalView = null;
        this.nameTableView = null;
        this.kbJoy1 = null;
        this.kbJoy2 = null;
    }

    private class MyLayoutManager
    extends ViewportLayout {
        private MyLayoutManager() {
        }

        public void layoutContainer(Container container) {
            boolean bl = (GUI.this.getExtendedState() & 6) != 0;
            boolean bl2 = (GUI.this.getExtendedState() & 1) != 0;
            Globals.guiMaximized = bl;
            Globals.guiIconified = bl2;
            int n = GUI.this.getWidth() - 8;
            int n2 = GUI.this.getHeight() - 34;
            GUI.this.cPane.setSize(n, n2);
            if (GUI.this.getWidth() < GUI.this.panelScreen.getWidth() + 17 || GUI.this.getHeight() < GUI.this.panelScreen.getHeight() + 108) {
                n = GUI.this.panelScreen.getWidth() + 17;
                n2 = GUI.this.panelScreen.getHeight() + 108;
                GUI.this.setSize(n, n2);
                GUI.this.getRootPane().invalidate();
                GUI.this.getRootPane().getLayout().layoutContainer(GUI.this.cPane);
                this.layoutContainer(null);
                return;
            }
            GUI.this.panelScreen.setBounds((n - GUI.this.panelScreen.getWidth()) / 2, 65 + (n2 - 65 - GUI.this.panelScreen.getHeight()) / 2, GUI.this.panelScreen.getWidth(), GUI.this.panelScreen.getHeight());
            GUI.this.topMenu.setBounds(0, 0, n, 30);
            GUI.this.btnReset.setBounds(n - 105, 35, 100, 25);
        }
    }

    private class ActionHandlerThread
    extends Thread {
        ActionEvent ev;

        public ActionHandlerThread(ActionEvent actionEvent) {
            this.ev = actionEvent;
        }

        public void run() {
            GUI.this.actionPerformed_(this.ev);
        }
    }

    private class MyWinAdapter
    extends WindowAdapter {
        private MyWinAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            GUI.stopDbgLogging();
            GUI.this.stopEmulation();
            GUI.this.nes.getPapu().stop();
            if (GUI.this.nes.getRom() != null) {
                GUI.this.nes.getRom().closeRom();
            }
            GUI.this.destroy();
            System.exit(0);
        }

        public void windowIconified(WindowEvent windowEvent) {
            GUI.this.getContentPane().getLayout().layoutContainer(null);
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            GUI.this.getContentPane().getLayout().layoutContainer(null);
        }
    }

    private class MyWavFileFilter
    extends FileFilter {
        private MyWavFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".wav");
        }

        public String getDescription() {
            return "Wave Files";
        }
    }

    private class MyRomFileFilter
    extends FileFilter {
        private MyRomFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".nes") || file.getName().toLowerCase().endsWith(".nsf");
        }

        public String getDescription() {
            return "NES ROMs & NSFs";
        }
    }
}

