/*
 * Decompiled with CFR 0.152.
 */
public class CpuInfo {
    private static int[] opdata;
    private static String[] instname;
    private static String[] addrDesc;
    public static int[] cycTable;
    public static final int INS_ADC = 0;
    public static final int INS_AND = 1;
    public static final int INS_ASL = 2;
    public static final int INS_BCC = 3;
    public static final int INS_BCS = 4;
    public static final int INS_BEQ = 5;
    public static final int INS_BIT = 6;
    public static final int INS_BMI = 7;
    public static final int INS_BNE = 8;
    public static final int INS_BPL = 9;
    public static final int INS_BRK = 10;
    public static final int INS_BVC = 11;
    public static final int INS_BVS = 12;
    public static final int INS_CLC = 13;
    public static final int INS_CLD = 14;
    public static final int INS_CLI = 15;
    public static final int INS_CLV = 16;
    public static final int INS_CMP = 17;
    public static final int INS_CPX = 18;
    public static final int INS_CPY = 19;
    public static final int INS_DEC = 20;
    public static final int INS_DEX = 21;
    public static final int INS_DEY = 22;
    public static final int INS_EOR = 23;
    public static final int INS_INC = 24;
    public static final int INS_INX = 25;
    public static final int INS_INY = 26;
    public static final int INS_JMP = 27;
    public static final int INS_JSR = 28;
    public static final int INS_LDA = 29;
    public static final int INS_LDX = 30;
    public static final int INS_LDY = 31;
    public static final int INS_LSR = 32;
    public static final int INS_NOP = 33;
    public static final int INS_ORA = 34;
    public static final int INS_PHA = 35;
    public static final int INS_PHP = 36;
    public static final int INS_PLA = 37;
    public static final int INS_PLP = 38;
    public static final int INS_ROL = 39;
    public static final int INS_ROR = 40;
    public static final int INS_RTI = 41;
    public static final int INS_RTS = 42;
    public static final int INS_SBC = 43;
    public static final int INS_SEC = 44;
    public static final int INS_SED = 45;
    public static final int INS_SEI = 46;
    public static final int INS_STA = 47;
    public static final int INS_STX = 48;
    public static final int INS_STY = 49;
    public static final int INS_TAX = 50;
    public static final int INS_TAY = 51;
    public static final int INS_TSX = 52;
    public static final int INS_TXA = 53;
    public static final int INS_TXS = 54;
    public static final int INS_TYA = 55;
    public static final int INS_DUMMY = 56;
    public static final int ADDR_ZP = 0;
    public static final int ADDR_REL = 1;
    public static final int ADDR_IMP = 2;
    public static final int ADDR_ABS = 3;
    public static final int ADDR_ACC = 4;
    public static final int ADDR_IMM = 5;
    public static final int ADDR_ZPX = 6;
    public static final int ADDR_ZPY = 7;
    public static final int ADDR_ABSX = 8;
    public static final int ADDR_ABSY = 9;
    public static final int ADDR_PREIDXIND = 10;
    public static final int ADDR_POSTIDXIND = 11;
    public static final int ADDR_INDABS = 12;

    public static int[] getOpData() {
        if (opdata == null) {
            CpuInfo.initOpData();
        }
        return opdata;
    }

    public static String[] getInstNames() {
        if (instname == null) {
            CpuInfo.initInstNames();
        }
        return instname;
    }

    public static String getInstName(int n) {
        if (instname == null) {
            CpuInfo.initInstNames();
        }
        if (n < instname.length) {
            return instname[n];
        }
        return "???";
    }

    public static String[] getAddressModeNames() {
        if (addrDesc == null) {
            CpuInfo.initAddrDesc();
        }
        return addrDesc;
    }

    public static String getAddressModeName(int n) {
        if (addrDesc == null) {
            CpuInfo.initAddrDesc();
        }
        if (n >= 0 && n < addrDesc.length) {
            return addrDesc[n];
        }
        return "???";
    }

    private static void initOpData() {
        opdata = new int[256];
        for (int i = 0; i < 256; ++i) {
            CpuInfo.opdata[i] = 255;
        }
        CpuInfo.setOp(0, 105, 5, 2, 2);
        CpuInfo.setOp(0, 101, 0, 2, 3);
        CpuInfo.setOp(0, 117, 6, 2, 4);
        CpuInfo.setOp(0, 109, 3, 3, 4);
        CpuInfo.setOp(0, 125, 8, 3, 4);
        CpuInfo.setOp(0, 121, 9, 3, 4);
        CpuInfo.setOp(0, 97, 10, 2, 6);
        CpuInfo.setOp(0, 113, 11, 2, 5);
        CpuInfo.setOp(1, 41, 5, 2, 2);
        CpuInfo.setOp(1, 37, 0, 2, 3);
        CpuInfo.setOp(1, 53, 6, 2, 4);
        CpuInfo.setOp(1, 45, 3, 3, 4);
        CpuInfo.setOp(1, 61, 8, 3, 4);
        CpuInfo.setOp(1, 57, 9, 3, 4);
        CpuInfo.setOp(1, 33, 10, 2, 6);
        CpuInfo.setOp(1, 49, 11, 2, 5);
        CpuInfo.setOp(2, 10, 4, 1, 2);
        CpuInfo.setOp(2, 6, 0, 2, 5);
        CpuInfo.setOp(2, 22, 6, 2, 6);
        CpuInfo.setOp(2, 14, 3, 3, 6);
        CpuInfo.setOp(2, 30, 8, 3, 7);
        CpuInfo.setOp(3, 144, 1, 2, 2);
        CpuInfo.setOp(4, 176, 1, 2, 2);
        CpuInfo.setOp(5, 240, 1, 2, 2);
        CpuInfo.setOp(6, 36, 0, 2, 3);
        CpuInfo.setOp(6, 44, 3, 3, 4);
        CpuInfo.setOp(7, 48, 1, 2, 2);
        CpuInfo.setOp(8, 208, 1, 2, 2);
        CpuInfo.setOp(9, 16, 1, 2, 2);
        CpuInfo.setOp(10, 0, 2, 1, 7);
        CpuInfo.setOp(11, 80, 1, 2, 2);
        CpuInfo.setOp(12, 112, 1, 2, 2);
        CpuInfo.setOp(13, 24, 2, 1, 2);
        CpuInfo.setOp(14, 216, 2, 1, 2);
        CpuInfo.setOp(15, 88, 2, 1, 2);
        CpuInfo.setOp(16, 184, 2, 1, 2);
        CpuInfo.setOp(17, 201, 5, 2, 2);
        CpuInfo.setOp(17, 197, 0, 2, 3);
        CpuInfo.setOp(17, 213, 6, 2, 4);
        CpuInfo.setOp(17, 205, 3, 3, 4);
        CpuInfo.setOp(17, 221, 8, 3, 4);
        CpuInfo.setOp(17, 217, 9, 3, 4);
        CpuInfo.setOp(17, 193, 10, 2, 6);
        CpuInfo.setOp(17, 209, 11, 2, 5);
        CpuInfo.setOp(18, 224, 5, 2, 2);
        CpuInfo.setOp(18, 228, 0, 2, 3);
        CpuInfo.setOp(18, 236, 3, 3, 4);
        CpuInfo.setOp(19, 192, 5, 2, 2);
        CpuInfo.setOp(19, 196, 0, 2, 3);
        CpuInfo.setOp(19, 204, 3, 3, 4);
        CpuInfo.setOp(20, 198, 0, 2, 5);
        CpuInfo.setOp(20, 214, 6, 2, 6);
        CpuInfo.setOp(20, 206, 3, 3, 6);
        CpuInfo.setOp(20, 222, 8, 3, 7);
        CpuInfo.setOp(21, 202, 2, 1, 2);
        CpuInfo.setOp(22, 136, 2, 1, 2);
        CpuInfo.setOp(23, 73, 5, 2, 2);
        CpuInfo.setOp(23, 69, 0, 2, 3);
        CpuInfo.setOp(23, 85, 6, 2, 4);
        CpuInfo.setOp(23, 77, 3, 3, 4);
        CpuInfo.setOp(23, 93, 8, 3, 4);
        CpuInfo.setOp(23, 89, 9, 3, 4);
        CpuInfo.setOp(23, 65, 10, 2, 6);
        CpuInfo.setOp(23, 81, 11, 2, 5);
        CpuInfo.setOp(24, 230, 0, 2, 5);
        CpuInfo.setOp(24, 246, 6, 2, 6);
        CpuInfo.setOp(24, 238, 3, 3, 6);
        CpuInfo.setOp(24, 254, 8, 3, 7);
        CpuInfo.setOp(25, 232, 2, 1, 2);
        CpuInfo.setOp(26, 200, 2, 1, 2);
        CpuInfo.setOp(27, 76, 3, 3, 3);
        CpuInfo.setOp(27, 108, 12, 3, 5);
        CpuInfo.setOp(28, 32, 3, 3, 6);
        CpuInfo.setOp(29, 169, 5, 2, 2);
        CpuInfo.setOp(29, 165, 0, 2, 3);
        CpuInfo.setOp(29, 181, 6, 2, 4);
        CpuInfo.setOp(29, 173, 3, 3, 4);
        CpuInfo.setOp(29, 189, 8, 3, 4);
        CpuInfo.setOp(29, 185, 9, 3, 4);
        CpuInfo.setOp(29, 161, 10, 2, 6);
        CpuInfo.setOp(29, 177, 11, 2, 5);
        CpuInfo.setOp(30, 162, 5, 2, 2);
        CpuInfo.setOp(30, 166, 0, 2, 3);
        CpuInfo.setOp(30, 182, 7, 2, 4);
        CpuInfo.setOp(30, 174, 3, 3, 4);
        CpuInfo.setOp(30, 190, 9, 3, 4);
        CpuInfo.setOp(31, 160, 5, 2, 2);
        CpuInfo.setOp(31, 164, 0, 2, 3);
        CpuInfo.setOp(31, 180, 6, 2, 4);
        CpuInfo.setOp(31, 172, 3, 3, 4);
        CpuInfo.setOp(31, 188, 8, 3, 4);
        CpuInfo.setOp(32, 74, 4, 1, 2);
        CpuInfo.setOp(32, 70, 0, 2, 5);
        CpuInfo.setOp(32, 86, 6, 2, 6);
        CpuInfo.setOp(32, 78, 3, 3, 6);
        CpuInfo.setOp(32, 94, 8, 3, 7);
        CpuInfo.setOp(33, 234, 2, 1, 2);
        CpuInfo.setOp(34, 9, 5, 2, 2);
        CpuInfo.setOp(34, 5, 0, 2, 3);
        CpuInfo.setOp(34, 21, 6, 2, 4);
        CpuInfo.setOp(34, 13, 3, 3, 4);
        CpuInfo.setOp(34, 29, 8, 3, 4);
        CpuInfo.setOp(34, 25, 9, 3, 4);
        CpuInfo.setOp(34, 1, 10, 2, 6);
        CpuInfo.setOp(34, 17, 11, 2, 5);
        CpuInfo.setOp(35, 72, 2, 1, 3);
        CpuInfo.setOp(36, 8, 2, 1, 3);
        CpuInfo.setOp(37, 104, 2, 1, 4);
        CpuInfo.setOp(38, 40, 2, 1, 4);
        CpuInfo.setOp(39, 42, 4, 1, 2);
        CpuInfo.setOp(39, 38, 0, 2, 5);
        CpuInfo.setOp(39, 54, 6, 2, 6);
        CpuInfo.setOp(39, 46, 3, 3, 6);
        CpuInfo.setOp(39, 62, 8, 3, 7);
        CpuInfo.setOp(40, 106, 4, 1, 2);
        CpuInfo.setOp(40, 102, 0, 2, 5);
        CpuInfo.setOp(40, 118, 6, 2, 6);
        CpuInfo.setOp(40, 110, 3, 3, 6);
        CpuInfo.setOp(40, 126, 8, 3, 7);
        CpuInfo.setOp(41, 64, 2, 1, 6);
        CpuInfo.setOp(42, 96, 2, 1, 6);
        CpuInfo.setOp(43, 233, 5, 2, 2);
        CpuInfo.setOp(43, 229, 0, 2, 3);
        CpuInfo.setOp(43, 245, 6, 2, 4);
        CpuInfo.setOp(43, 237, 3, 3, 4);
        CpuInfo.setOp(43, 253, 8, 3, 4);
        CpuInfo.setOp(43, 249, 9, 3, 4);
        CpuInfo.setOp(43, 225, 10, 2, 6);
        CpuInfo.setOp(43, 241, 11, 2, 5);
        CpuInfo.setOp(44, 56, 2, 1, 2);
        CpuInfo.setOp(45, 248, 2, 1, 2);
        CpuInfo.setOp(46, 120, 2, 1, 2);
        CpuInfo.setOp(47, 133, 0, 2, 3);
        CpuInfo.setOp(47, 149, 6, 2, 4);
        CpuInfo.setOp(47, 141, 3, 3, 4);
        CpuInfo.setOp(47, 157, 8, 3, 5);
        CpuInfo.setOp(47, 153, 9, 3, 5);
        CpuInfo.setOp(47, 129, 10, 2, 6);
        CpuInfo.setOp(47, 145, 11, 2, 6);
        CpuInfo.setOp(48, 134, 0, 2, 3);
        CpuInfo.setOp(48, 150, 7, 2, 4);
        CpuInfo.setOp(48, 142, 3, 3, 4);
        CpuInfo.setOp(49, 132, 0, 2, 3);
        CpuInfo.setOp(49, 148, 6, 2, 4);
        CpuInfo.setOp(49, 140, 3, 3, 4);
        CpuInfo.setOp(50, 170, 2, 1, 2);
        CpuInfo.setOp(51, 168, 2, 1, 2);
        CpuInfo.setOp(52, 186, 2, 1, 2);
        CpuInfo.setOp(53, 138, 2, 1, 2);
        CpuInfo.setOp(54, 154, 2, 1, 2);
        CpuInfo.setOp(55, 152, 2, 1, 2);
        cycTable = new int[]{7, 6, 2, 8, 3, 3, 5, 5, 3, 2, 2, 2, 4, 4, 6, 6, 2, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 4, 4, 7, 7, 6, 6, 2, 8, 3, 3, 5, 5, 4, 2, 2, 2, 4, 4, 6, 6, 2, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 4, 4, 7, 7, 6, 6, 2, 8, 3, 3, 5, 5, 3, 2, 2, 2, 3, 4, 6, 6, 2, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 4, 4, 7, 7, 6, 6, 2, 8, 3, 3, 5, 5, 4, 2, 2, 2, 5, 4, 6, 6, 2, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 4, 4, 7, 7, 2, 6, 2, 6, 3, 3, 3, 3, 2, 2, 2, 2, 4, 4, 4, 4, 2, 6, 2, 6, 4, 4, 4, 4, 2, 5, 2, 5, 5, 5, 5, 5, 2, 6, 2, 6, 3, 3, 3, 3, 2, 2, 2, 2, 4, 4, 4, 4, 2, 5, 2, 5, 4, 4, 4, 4, 2, 4, 2, 4, 4, 4, 4, 4, 2, 6, 2, 8, 3, 3, 5, 5, 2, 2, 2, 2, 4, 4, 6, 6, 2, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 4, 4, 7, 7, 2, 6, 3, 8, 3, 3, 5, 5, 2, 2, 2, 2, 4, 4, 6, 6, 2, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 4, 4, 7, 7};
    }

    private static void setOp(int n, int n2, int n3, int n4, int n5) {
        CpuInfo.opdata[n2] = n & 0xFF | (n3 & 0xFF) << 8 | (n4 & 0xFF) << 16 | (n5 & 0xFF) << 24;
    }

    private static void initInstNames() {
        instname = new String[56];
        CpuInfo.instname[0] = "ADC";
        CpuInfo.instname[1] = "AND";
        CpuInfo.instname[2] = "ASL";
        CpuInfo.instname[3] = "BCC";
        CpuInfo.instname[4] = "BCS";
        CpuInfo.instname[5] = "BEQ";
        CpuInfo.instname[6] = "BIT";
        CpuInfo.instname[7] = "BMI";
        CpuInfo.instname[8] = "BNE";
        CpuInfo.instname[9] = "BPL";
        CpuInfo.instname[10] = "BRK";
        CpuInfo.instname[11] = "BVC";
        CpuInfo.instname[12] = "BVS";
        CpuInfo.instname[13] = "CLC";
        CpuInfo.instname[14] = "CLD";
        CpuInfo.instname[15] = "CLI";
        CpuInfo.instname[16] = "CLV";
        CpuInfo.instname[17] = "CMP";
        CpuInfo.instname[18] = "CPX";
        CpuInfo.instname[19] = "CPY";
        CpuInfo.instname[20] = "DEC";
        CpuInfo.instname[21] = "DEX";
        CpuInfo.instname[22] = "DEY";
        CpuInfo.instname[23] = "EOR";
        CpuInfo.instname[24] = "INC";
        CpuInfo.instname[25] = "INX";
        CpuInfo.instname[26] = "INY";
        CpuInfo.instname[27] = "JMP";
        CpuInfo.instname[28] = "JSR";
        CpuInfo.instname[29] = "LDA";
        CpuInfo.instname[30] = "LDX";
        CpuInfo.instname[31] = "LDY";
        CpuInfo.instname[32] = "LSR";
        CpuInfo.instname[33] = "NOP";
        CpuInfo.instname[34] = "ORA";
        CpuInfo.instname[35] = "PHA";
        CpuInfo.instname[36] = "PHP";
        CpuInfo.instname[37] = "PLA";
        CpuInfo.instname[38] = "PLP";
        CpuInfo.instname[39] = "ROL";
        CpuInfo.instname[40] = "ROR";
        CpuInfo.instname[41] = "RTI";
        CpuInfo.instname[42] = "RTS";
        CpuInfo.instname[43] = "SBC";
        CpuInfo.instname[44] = "SEC";
        CpuInfo.instname[45] = "SED";
        CpuInfo.instname[46] = "SEI";
        CpuInfo.instname[47] = "STA";
        CpuInfo.instname[48] = "STX";
        CpuInfo.instname[49] = "STY";
        CpuInfo.instname[50] = "TAX";
        CpuInfo.instname[51] = "TAY";
        CpuInfo.instname[52] = "TSX";
        CpuInfo.instname[53] = "TXA";
        CpuInfo.instname[54] = "TXS";
        CpuInfo.instname[55] = "TYA";
    }

    private static void initAddrDesc() {
        addrDesc = new String[]{"Zero Page           ", "Relative            ", "Implied             ", "Absolute            ", "Accumulator         ", "Immediate           ", "Zero Page,X         ", "Zero Page,Y         ", "Absolute,X          ", "Absolute,Y          ", "Preindexed Indirect ", "Postindexed Indirect", "Indirect Absolute   "};
    }
}

