/*
 * Decompiled with CFR 0.152.
 */
public class ChannelTriangle
implements PapuChannel {
    PAPU papu;
    boolean isEnabled;
    boolean sampleCondition;
    boolean lengthCounterEnable;
    boolean lcHalt;
    boolean lcControl;
    int progTimerCount;
    int progTimerMax;
    int triangleCounter;
    int lengthCounter;
    int linearCounter;
    int lcLoadValue;
    int sampleValue;
    int tmp;

    public ChannelTriangle(PAPU pAPU) {
        this.papu = pAPU;
    }

    public void clockLengthCounter() {
        if (this.lengthCounterEnable && this.lengthCounter > 0) {
            --this.lengthCounter;
            if (this.lengthCounter == 0) {
                this.updateSampleCondition();
            }
        }
    }

    public void clockLinearCounter() {
        if (this.lcHalt) {
            this.linearCounter = this.lcLoadValue;
            this.updateSampleCondition();
        } else if (this.linearCounter > 0) {
            --this.linearCounter;
            this.updateSampleCondition();
        }
        if (!this.lcControl) {
            this.lcHalt = false;
        }
    }

    public int getLengthStatus() {
        return this.lengthCounter == 0 || !this.isEnabled ? 0 : 1;
    }

    public int readReg(int n) {
        return 0;
    }

    public void writeReg(int n, int n2) {
        if (n == 16392) {
            this.lcControl = (n2 & 0x80) != 0;
            this.lcLoadValue = n2 & 0x7F;
            this.lengthCounterEnable = !this.lcControl;
        } else if (n == 16394) {
            this.progTimerMax &= 0x700;
            this.progTimerMax |= n2;
        } else if (n == 16395) {
            this.progTimerMax &= 0xFF;
            this.progTimerMax |= (n2 & 7) << 8;
            this.lengthCounter = this.papu.getLengthMax(n2 & 0xF8);
            this.lcHalt = true;
        }
        this.updateSampleCondition();
    }

    public void clockProgrammableTimer(int n) {
        if (this.progTimerMax > 0) {
            this.progTimerCount += n;
            while (this.progTimerMax > 0 && this.progTimerCount >= this.progTimerMax) {
                this.progTimerCount -= this.progTimerMax;
                if (!this.isEnabled || this.lengthCounter <= 0 || this.linearCounter <= 0) continue;
                this.clockTriangleGenerator();
            }
        }
    }

    public void clockTriangleGenerator() {
        ++this.triangleCounter;
        this.triangleCounter &= 0x1F;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
        if (!bl) {
            this.lengthCounter = 0;
        }
        this.updateSampleCondition();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void updateSampleCondition() {
        this.sampleCondition = this.isEnabled && this.progTimerMax > 7 && this.linearCounter > 0 && this.lengthCounter > 0;
    }

    public void reset() {
        this.progTimerCount = 0;
        this.progTimerMax = 0;
        this.triangleCounter = 0;
        this.isEnabled = false;
        this.sampleCondition = false;
        this.lengthCounter = 0;
        this.lengthCounterEnable = false;
        this.linearCounter = 0;
        this.lcLoadValue = 0;
        this.lcHalt = true;
        this.lcControl = false;
        this.tmp = 0;
        this.sampleValue = 15;
    }

    public void destroy() {
        this.papu = null;
    }
}

