/*
 * Decompiled with CFR 0.152.
 */
public class ChannelSquare
implements PapuChannel {
    PAPU papu;
    static int[] dutyLookup = new int[]{0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1};
    static int[] impLookup = new int[]{1, -1, 0, 0, 0, 0, 0, 0, 1, 0, -1, 0, 0, 0, 0, 0, 1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0, 0};
    boolean sqr1;
    boolean isEnabled;
    boolean lengthCounterEnable;
    boolean sweepActive;
    boolean envDecayDisable;
    boolean envDecayLoopEnable;
    boolean envReset;
    boolean sweepCarry;
    boolean updateSweepPeriod;
    int progTimerCount;
    int progTimerMax;
    int lengthCounter;
    int squareCounter;
    int sweepCounter;
    int sweepCounterMax;
    int sweepMode;
    int sweepShiftAmount;
    int envDecayRate;
    int envDecayCounter;
    int envVolume;
    int masterVolume;
    int dutyMode;
    int sweepResult;
    int sampleValue;
    int vol;

    public ChannelSquare(PAPU pAPU, boolean bl) {
        this.papu = pAPU;
        this.sqr1 = bl;
    }

    public void clockLengthCounter() {
        if (this.lengthCounterEnable && this.lengthCounter > 0) {
            --this.lengthCounter;
            if (this.lengthCounter == 0) {
                this.updateSampleValue();
            }
        }
    }

    public void clockEnvDecay() {
        if (this.envReset) {
            this.envReset = false;
            this.envDecayCounter = this.envDecayRate + 1;
            this.envVolume = 15;
        } else if (--this.envDecayCounter <= 0) {
            this.envDecayCounter = this.envDecayRate + 1;
            this.envVolume = this.envVolume > 0 ? --this.envVolume : (this.envDecayLoopEnable ? 15 : 0);
        }
        this.masterVolume = this.envDecayDisable ? this.envDecayRate : this.envVolume;
        this.updateSampleValue();
    }

    public void clockSweep() {
        if (--this.sweepCounter <= 0) {
            this.sweepCounter = this.sweepCounterMax + 1;
            if (this.sweepActive && this.sweepShiftAmount > 0 && this.progTimerMax > 7) {
                this.sweepCarry = false;
                if (this.sweepMode == 0) {
                    this.progTimerMax += this.progTimerMax >> this.sweepShiftAmount;
                    if (this.progTimerMax > 4095) {
                        this.progTimerMax = 4095;
                        this.sweepCarry = true;
                    }
                } else {
                    this.progTimerMax -= (this.progTimerMax >> this.sweepShiftAmount) - (this.sqr1 ? 1 : 0);
                }
            }
        }
        if (this.updateSweepPeriod) {
            this.updateSweepPeriod = false;
            this.sweepCounter = this.sweepCounterMax + 1;
        }
    }

    public void updateSampleValue() {
        this.sampleValue = this.isEnabled && this.lengthCounter > 0 && this.progTimerMax > 7 ? (this.sweepMode == 0 && this.progTimerMax + (this.progTimerMax >> this.sweepShiftAmount) > 4095 ? 0 : this.masterVolume * dutyLookup[(this.dutyMode << 3) + this.squareCounter]) : 0;
    }

    public void writeReg(int n, int n2) {
        int n3;
        int n4 = n3 = this.sqr1 ? 0 : 4;
        if (n == 16384 + n3) {
            this.envDecayDisable = (n2 & 0x10) != 0;
            this.envDecayRate = n2 & 0xF;
            this.envDecayLoopEnable = (n2 & 0x20) != 0;
            this.dutyMode = n2 >> 6 & 3;
            this.lengthCounterEnable = (n2 & 0x20) == 0;
            this.masterVolume = this.envDecayDisable ? this.envDecayRate : this.envVolume;
            this.updateSampleValue();
        } else if (n == 16385 + n3) {
            this.sweepActive = (n2 & 0x80) != 0;
            this.sweepCounterMax = n2 >> 4 & 7;
            this.sweepMode = n2 >> 3 & 1;
            this.sweepShiftAmount = n2 & 7;
            this.updateSweepPeriod = true;
        } else if (n == 16386 + n3) {
            this.progTimerMax &= 0x700;
            this.progTimerMax |= n2;
        } else if (n == 16387 + n3) {
            this.progTimerMax &= 0xFF;
            this.progTimerMax |= (n2 & 7) << 8;
            if (this.isEnabled) {
                this.lengthCounter = this.papu.getLengthMax(n2 & 0xF8);
            }
            this.envReset = true;
        }
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
        if (!bl) {
            this.lengthCounter = 0;
        }
        this.updateSampleValue();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public int getLengthStatus() {
        return this.lengthCounter == 0 || !this.isEnabled ? 0 : 1;
    }

    public void reset() {
        this.progTimerCount = 0;
        this.progTimerMax = 0;
        this.lengthCounter = 0;
        this.squareCounter = 0;
        this.sweepCounter = 0;
        this.sweepCounterMax = 0;
        this.sweepMode = 0;
        this.sweepShiftAmount = 0;
        this.envDecayRate = 0;
        this.envDecayCounter = 0;
        this.envVolume = 0;
        this.masterVolume = 0;
        this.dutyMode = 0;
        this.vol = 0;
        this.isEnabled = false;
        this.lengthCounterEnable = false;
        this.sweepActive = false;
        this.sweepCarry = false;
        this.envDecayDisable = false;
        this.envDecayLoopEnable = false;
    }

    public void destroy() {
        this.papu = null;
    }
}

