/*
 * Decompiled with CFR 0.152.
 */
public class ChannelNoise
implements PapuChannel {
    PAPU papu;
    public boolean isEnabled;
    public boolean envDecayDisable;
    public boolean envDecayLoopEnable;
    public boolean lengthCounterEnable;
    public boolean envReset;
    public boolean shiftNow;
    public int lengthCounter;
    public int progTimerCount;
    public int progTimerMax;
    public int envDecayRate;
    public int envDecayCounter;
    public int envVolume;
    public int masterVolume;
    public int shiftReg;
    public int randomBit;
    public int randomMode;
    public int sampleValue;
    public long accValue = 0L;
    public long accCount = 1L;
    public int tmp;

    public ChannelNoise(PAPU pAPU) {
        this.papu = pAPU;
        this.shiftReg = 16384;
    }

    public void clockLengthCounter() {
        if (this.lengthCounterEnable && this.lengthCounter > 0) {
            --this.lengthCounter;
            if (this.lengthCounter == 0) {
                this.updateSampleValue();
            }
        }
    }

    public void clockEnvDecay() {
        if (this.envReset) {
            this.envReset = false;
            this.envDecayCounter = this.envDecayRate + 1;
            this.envVolume = 15;
        } else if (--this.envDecayCounter <= 0) {
            this.envDecayCounter = this.envDecayRate + 1;
            this.envVolume = this.envVolume > 0 ? --this.envVolume : (this.envDecayLoopEnable ? 15 : 0);
        }
        this.masterVolume = this.envDecayDisable ? this.envDecayRate : this.envVolume;
        this.updateSampleValue();
    }

    public void updateSampleValue() {
        if (this.isEnabled && this.lengthCounter > 0) {
            this.sampleValue = this.randomBit * this.masterVolume;
        }
    }

    public void writeReg(int n, int n2) {
        if (n == 16396) {
            this.envDecayDisable = (n2 & 0x10) != 0;
            this.envDecayRate = n2 & 0xF;
            this.envDecayLoopEnable = (n2 & 0x20) != 0;
            this.lengthCounterEnable = (n2 & 0x20) == 0;
            this.masterVolume = this.envDecayDisable ? this.envDecayRate : this.envVolume;
        } else if (n == 16398) {
            this.progTimerMax = this.papu.getNoiseWaveLength(n2 & 0xF);
            this.randomMode = n2 >> 7;
        } else if (n == 16399) {
            this.lengthCounter = this.papu.getLengthMax(n2 & 0xF8);
            this.envReset = true;
        }
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
        if (!bl) {
            this.lengthCounter = 0;
        }
        this.updateSampleValue();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public int getLengthStatus() {
        return this.lengthCounter == 0 || !this.isEnabled ? 0 : 1;
    }

    public void reset() {
        this.progTimerCount = 0;
        this.progTimerMax = 0;
        this.isEnabled = false;
        this.lengthCounter = 0;
        this.lengthCounterEnable = false;
        this.envDecayDisable = false;
        this.envDecayLoopEnable = false;
        this.shiftNow = false;
        this.envDecayRate = 0;
        this.envDecayCounter = 0;
        this.envVolume = 0;
        this.masterVolume = 0;
        this.shiftReg = 1;
        this.randomBit = 0;
        this.randomMode = 0;
        this.sampleValue = 0;
        this.tmp = 0;
    }

    public void destroy() {
        this.papu = null;
    }
}

