/*
 * Decompiled with CFR 0.152.
 */
public class ChannelDM
implements PapuChannel {
    public static final int MODE_NORMAL = 0;
    public static final int MODE_LOOP = 1;
    public static final int MODE_IRQ = 2;
    PAPU papu;
    boolean isEnabled;
    boolean hasSample;
    boolean irqGenerated = false;
    int playMode;
    int dmaFrequency;
    int dmaCounter;
    int deltaCounter;
    int playStartAddress;
    int playAddress;
    int playLength;
    int playLengthCounter;
    int shiftCounter;
    int reg4012;
    int reg4013;
    int status;
    int sample;
    int dacLsb;
    int data;

    public ChannelDM(PAPU pAPU) {
        this.papu = pAPU;
    }

    public void clockDmc() {
        if (this.hasSample) {
            if ((this.data & 1) == 0) {
                if (this.deltaCounter > 0) {
                    --this.deltaCounter;
                }
            } else if (this.deltaCounter < 63) {
                ++this.deltaCounter;
            }
            this.sample = this.isEnabled ? (this.deltaCounter << 1) + this.dacLsb : 0;
            this.data >>= 1;
        }
        --this.dmaCounter;
        if (this.dmaCounter <= 0) {
            this.hasSample = false;
            this.endOfSample();
            this.dmaCounter = 8;
        }
        if (this.irqGenerated) {
            this.papu.nes.cpu.requestIrq(0);
        }
    }

    private void endOfSample() {
        if (this.playLengthCounter == 0 && this.playMode == 1) {
            this.playAddress = this.playStartAddress;
            this.playLengthCounter = this.playLength;
        }
        if (this.playLengthCounter > 0) {
            this.nextSample();
            if (this.playLengthCounter == 0 && this.playMode == 2) {
                this.irqGenerated = true;
            }
        }
    }

    private void nextSample() {
        this.data = this.papu.getNes().getMemoryMapper().load(this.playAddress);
        this.papu.getNes().cpu.haltCycles(4);
        --this.playLengthCounter;
        ++this.playAddress;
        if (this.playAddress > 65535) {
            this.playAddress = 32768;
        }
        this.hasSample = true;
    }

    public void writeReg(int n, int n2) {
        if (n == 16400) {
            if (n2 >> 6 == 0) {
                this.playMode = 0;
            } else if ((n2 >> 6 & 1) == 1) {
                this.playMode = 1;
            } else if (n2 >> 6 == 2) {
                this.playMode = 2;
            }
            if ((n2 & 0x80) == 0) {
                this.irqGenerated = false;
            }
            this.dmaFrequency = this.papu.getDmcFrequency(n2 & 0xF);
        } else if (n == 16401) {
            this.deltaCounter = n2 >> 1 & 0x3F;
            this.dacLsb = n2 & 1;
            if (this.papu.userEnableDmc) {
                this.sample = (this.deltaCounter << 1) + this.dacLsb;
            }
        } else if (n == 16402) {
            this.playAddress = this.playStartAddress = n2 << 6 | 0xC000;
            this.reg4012 = n2;
        } else if (n == 16403) {
            this.playLengthCounter = this.playLength = (n2 << 4) + 1;
            this.reg4013 = n2;
        } else if (n == 16405) {
            if ((n2 >> 4 & 1) == 0) {
                this.playLengthCounter = 0;
            } else {
                this.playAddress = this.playStartAddress;
                this.playLengthCounter = this.playLength;
            }
            this.irqGenerated = false;
        }
    }

    public void setEnabled(boolean bl) {
        if (!this.isEnabled && bl) {
            this.playLengthCounter = this.playLength;
        }
        this.isEnabled = bl;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public int getLengthStatus() {
        return this.playLengthCounter == 0 || !this.isEnabled ? 0 : 1;
    }

    public int getIrqStatus() {
        return this.irqGenerated ? 1 : 0;
    }

    public void reset() {
        this.isEnabled = false;
        this.irqGenerated = false;
        this.playMode = 0;
        this.dmaFrequency = 0;
        this.dmaCounter = 0;
        this.deltaCounter = 0;
        this.playStartAddress = 0;
        this.playAddress = 0;
        this.playLength = 0;
        this.playLengthCounter = 0;
        this.status = 0;
        this.sample = 0;
        this.dacLsb = 0;
        this.shiftCounter = 0;
        this.reg4012 = 0;
        this.reg4013 = 0;
        this.data = 0;
    }

    public void destroy() {
        this.papu = null;
    }
}

