/*
 * Decompiled with CFR 0.152.
 */
public final class CPU
implements Runnable {
    Thread myThread;
    private NES nes;
    private MemoryMapper mmap;
    private short[] mem;
    public int REG_ACC_NEW;
    public int REG_X_NEW;
    public int REG_Y_NEW;
    public int REG_STATUS_NEW;
    public int REG_PC_NEW;
    public int REG_SP;
    private int F_CARRY_NEW;
    private int F_ZERO_NEW;
    private int F_INTERRUPT_NEW;
    private int F_DECIMAL_NEW;
    private int F_BRK_NEW;
    private int F_NOTUSED_NEW;
    private int F_OVERFLOW_NEW;
    private int F_SIGN_NEW;
    public static final int IRQ_NORMAL = 0;
    public static final int IRQ_NMI = 1;
    public static final int IRQ_RESET = 2;
    public boolean irqRequested;
    private int irqType;
    private int[] opdata;
    public int cyclesToHalt;
    public int nsfCycles;
    public boolean nsfInit;
    public boolean stopRunning;
    public boolean crash;

    public CPU(NES nES) {
        this.nes = nES;
    }

    public void init() {
        this.opdata = CpuInfo.getOpData();
        this.mmap = this.nes.getMemoryMapper();
        this.crash = false;
        this.F_BRK_NEW = 1;
        this.F_NOTUSED_NEW = 1;
        this.F_INTERRUPT_NEW = 1;
        this.irqRequested = false;
    }

    public void stateLoad(ByteBuffer byteBuffer) {
        if (byteBuffer.readByte() == 1) {
            this.setStatus(byteBuffer.readInt());
            this.REG_ACC_NEW = byteBuffer.readInt();
            this.REG_PC_NEW = byteBuffer.readInt();
            this.REG_SP = byteBuffer.readInt();
            this.REG_X_NEW = byteBuffer.readInt();
            this.REG_Y_NEW = byteBuffer.readInt();
            this.cyclesToHalt = byteBuffer.readInt();
        }
    }

    public void stateSave(ByteBuffer byteBuffer) {
        byteBuffer.putByte((short)1);
        byteBuffer.putInt(this.getStatus());
        byteBuffer.putInt(this.REG_ACC_NEW);
        byteBuffer.putInt(this.REG_PC_NEW);
        byteBuffer.putInt(this.REG_SP);
        byteBuffer.putInt(this.REG_X_NEW);
        byteBuffer.putInt(this.REG_Y_NEW);
        byteBuffer.putInt(this.cyclesToHalt);
    }

    public void reset() {
        this.REG_ACC_NEW = 0;
        this.REG_X_NEW = 0;
        this.REG_Y_NEW = 0;
        this.irqRequested = false;
        this.irqType = 0;
        this.REG_SP = 511;
        this.REG_PC_NEW = Short.MAX_VALUE;
        this.REG_STATUS_NEW = 40;
        this.setStatus(40);
        this.crash = false;
        this.F_CARRY_NEW = 0;
        this.F_DECIMAL_NEW = 0;
        this.F_INTERRUPT_NEW = 1;
        this.F_OVERFLOW_NEW = 0;
        this.F_SIGN_NEW = 0;
        this.F_ZERO_NEW = 0;
        this.F_NOTUSED_NEW = 1;
        this.F_BRK_NEW = 1;
        this.cyclesToHalt = 0;
        this.nsfCycles = 0;
    }

    public synchronized void beginExecution() {
        if (this.myThread != null && this.myThread.isAlive()) {
            this.endExecution();
        }
        this.myThread = new Thread(this);
        this.myThread.start();
        this.myThread.setPriority(1);
    }

    public synchronized void endExecution() {
        if (this.myThread != null && this.myThread.isAlive()) {
            try {
                this.stopRunning = true;
                if (!Globals.frameStep) {
                    this.myThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public boolean isRunning() {
        return this.myThread != null && this.myThread.isAlive();
    }

    public void run() {
        this.initRun();
        this.emulate();
    }

    public synchronized void initRun() {
        this.nsfCycles = 0;
        this.stopRunning = false;
    }

    public void emulate() {
        this.mem = this.nes.cpuMem.mem;
        MemoryMapper memoryMapper = this.nes.memMapper;
        PPU pPU = this.nes.ppu;
        PAPU pAPU = this.nes.papu;
        int n = this.REG_ACC_NEW;
        int n2 = this.REG_X_NEW;
        int n3 = this.REG_Y_NEW;
        int n4 = this.REG_STATUS_NEW;
        int n5 = this.REG_PC_NEW;
        int n6 = this.F_CARRY_NEW;
        int n7 = this.F_ZERO_NEW == 0 ? 1 : 0;
        int n8 = this.F_INTERRUPT_NEW;
        int n9 = this.F_DECIMAL_NEW;
        int n10 = this.F_NOTUSED_NEW;
        int n11 = this.F_BRK_NEW;
        int n12 = this.F_OVERFLOW_NEW;
        int n13 = this.F_SIGN_NEW;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 3573680;
        int n20 = 29780;
        boolean bl = Globals.palEmulation;
        boolean bl2 = Globals.enableSound;
        boolean bl3 = Globals.nsfMode;
        this.stopRunning = false;
        while (!this.stopRunning) {
            int n21;
            if (this.cyclesToHalt > 0 && !Globals.nsfMode) {
                while (this.cyclesToHalt > 8) {
                    pPU.cycles = 24;
                    pPU.emulateCycles();
                    if (bl2) {
                        pAPU.clockFrameCounter(8);
                    }
                    this.cyclesToHalt -= 8;
                }
                if (this.cyclesToHalt > 0) {
                    pPU.cycles = this.cyclesToHalt * 3;
                    pPU.emulateCycles();
                    if (bl2) {
                        pAPU.clockFrameCounter(this.cyclesToHalt);
                    }
                    this.cyclesToHalt = 0;
                }
            }
            if (this.irqRequested) {
                n21 = n6 | (n7 == 0 ? 1 : 0) << 1 | n8 << 2 | n9 << 3 | n11 << 4 | n10 << 5 | n12 << 6 | n13 << 7;
                this.REG_PC_NEW = n5;
                this.F_INTERRUPT_NEW = n8;
                switch (this.irqType) {
                    case 0: {
                        if (n8 != 0) break;
                        this.doIrq(n21);
                        break;
                    }
                    case 1: {
                        this.doNonMaskableInterrupt(n21);
                        break;
                    }
                    case 2: {
                        this.doResetInterrupt();
                    }
                }
                n5 = this.REG_PC_NEW;
                n8 = this.F_INTERRUPT_NEW;
                n11 = this.F_BRK_NEW;
                this.irqRequested = false;
            }
            n14 = this.opdata[memoryMapper.load(n5 + 1)];
            int n22 = n14 >> 24;
            int n23 = 0;
            n16 = n14 >> 8 & 0xFF;
            n15 = n5;
            n5 += n14 >> 16 & 0xFF;
            switch (n16) {
                case 0: {
                    n17 = this.load(n15 + 2);
                    break;
                }
                case 1: {
                    n17 = this.load(n15 + 2);
                    if (n17 < 128) {
                        n17 += n5;
                        break;
                    }
                    n17 += n5 - 256;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    n17 = this.load16bit(n15 + 2);
                    break;
                }
                case 4: {
                    n17 = n;
                    break;
                }
                case 5: {
                    n17 = n5;
                    break;
                }
                case 6: {
                    n17 = this.load(n15 + 2) + n2 & 0xFF;
                    break;
                }
                case 7: {
                    n17 = this.load(n15 + 2) + n3 & 0xFF;
                    break;
                }
                case 8: {
                    n17 = this.load16bit(n15 + 2);
                    if ((n17 & 0xFF00) != (n17 + n2 & 0xFF00)) {
                        n23 = 1;
                    }
                    n17 += n2;
                    break;
                }
                case 9: {
                    n17 = this.load16bit(n15 + 2);
                    if ((n17 & 0xFF00) != (n17 + n3 & 0xFF00)) {
                        n23 = 1;
                    }
                    n17 += n3;
                    break;
                }
                case 10: {
                    n17 = this.load(n15 + 2);
                    if ((n17 & 0xFF00) != (n17 + n2 & 0xFF00)) {
                        n23 = 1;
                    }
                    n17 += n2;
                    n17 &= 0xFF;
                    n17 = this.load16bit(n17);
                    break;
                }
                case 11: {
                    n17 = this.load16bit(this.load(n15 + 2));
                    if ((n17 & 0xFF00) != (n17 + n3 & 0xFF00)) {
                        n23 = 1;
                    }
                    n17 += n3;
                    break;
                }
                case 12: {
                    n17 = this.load16bit(n15 + 2);
                    n17 = n17 < 8191 ? this.mem[n17] + (this.mem[n17 & 0xFF00 | (n17 & 0xFF) + 1 & 0xFF] << 8) : memoryMapper.load(n17) + (memoryMapper.load(n17 & 0xFF00 | (n17 & 0xFF) + 1 & 0xFF) << 8);
                }
            }
            n17 &= 0xFFFF;
            switch (n14 & 0xFF) {
                case 0: {
                    n21 = n + this.load(n17) + n6;
                    n12 = ((n ^ this.load(n17)) & 0x80) == 0 && ((n ^ n21) & 0x80) != 0 ? 1 : 0;
                    n6 = n21 > 255 ? 1 : 0;
                    n13 = n21 >> 7 & 1;
                    n7 = n21 & 0xFF;
                    n = n21 & 0xFF;
                    n22 += n23;
                    break;
                }
                case 1: {
                    n13 = (n &= this.load(n17)) >> 7 & 1;
                    n7 = n;
                    if (n16 == 11) break;
                    n22 += n23;
                    break;
                }
                case 2: {
                    if (n16 == 4) {
                        n6 = n >> 7 & 1;
                        n = n << 1 & 0xFF;
                        n13 = n >> 7 & 1;
                        n7 = n;
                        break;
                    }
                    n21 = this.load(n17);
                    n6 = n21 >> 7 & 1;
                    n21 = n21 << 1 & 0xFF;
                    n13 = n21 >> 7 & 1;
                    n7 = n21;
                    this.write(n17, (short)n21);
                    break;
                }
                case 3: {
                    if (n6 != 0) break;
                    n22 += (n15 & 0xFF00) != (n17 & 0xFF00) ? 2 : 1;
                    n5 = n17;
                    break;
                }
                case 4: {
                    if (n6 != 1) break;
                    n22 += (n15 & 0xFF00) != (n17 & 0xFF00) ? 2 : 1;
                    n5 = n17;
                    break;
                }
                case 5: {
                    if (n7 != 0) break;
                    n22 += (n15 & 0xFF00) != (n17 & 0xFF00) ? 2 : 1;
                    n5 = n17;
                    break;
                }
                case 6: {
                    n21 = this.load(n17);
                    n13 = n21 >> 7 & 1;
                    n12 = n21 >> 6 & 1;
                    n7 = n21 &= n;
                    break;
                }
                case 7: {
                    if (n13 != 1) break;
                    ++n22;
                    n5 = n17;
                    break;
                }
                case 8: {
                    if (n7 == 0) break;
                    n22 += (n15 & 0xFF00) != (n17 & 0xFF00) ? 2 : 1;
                    n5 = n17;
                    break;
                }
                case 9: {
                    if (n13 != 0) break;
                    n22 += (n15 & 0xFF00) != (n17 & 0xFF00) ? 2 : 1;
                    n5 = n17;
                    break;
                }
                case 10: {
                    this.push((n5 += 2) >> 8 & 0xFF);
                    this.push(n5 & 0xFF);
                    n11 = 1;
                    this.push(n6 | (n7 == 0 ? 1 : 0) << 1 | n8 << 2 | n9 << 3 | n11 << 4 | n10 << 5 | n12 << 6 | n13 << 7);
                    n8 = 1;
                    n5 = this.load16bit(65534);
                    --n5;
                    break;
                }
                case 11: {
                    if (n12 != 0) break;
                    n22 += (n15 & 0xFF00) != (n17 & 0xFF00) ? 2 : 1;
                    n5 = n17;
                    break;
                }
                case 12: {
                    if (n12 != 1) break;
                    n22 += (n15 & 0xFF00) != (n17 & 0xFF00) ? 2 : 1;
                    n5 = n17;
                    break;
                }
                case 13: {
                    n6 = 0;
                    break;
                }
                case 14: {
                    n9 = 0;
                    break;
                }
                case 15: {
                    n8 = 0;
                    break;
                }
                case 16: {
                    n12 = 0;
                    break;
                }
                case 17: {
                    n21 = n - this.load(n17);
                    n6 = n21 >= 0 ? 1 : 0;
                    n13 = n21 >> 7 & 1;
                    n7 = n21 & 0xFF;
                    n22 += n23;
                    break;
                }
                case 18: {
                    n21 = n2 - this.load(n17);
                    n6 = n21 >= 0 ? 1 : 0;
                    n13 = n21 >> 7 & 1;
                    n7 = n21 & 0xFF;
                    break;
                }
                case 19: {
                    n21 = n3 - this.load(n17);
                    n6 = n21 >= 0 ? 1 : 0;
                    n13 = n21 >> 7 & 1;
                    n7 = n21 & 0xFF;
                    break;
                }
                case 20: {
                    n21 = this.load(n17) - 1 & 0xFF;
                    n13 = n21 >> 7 & 1;
                    n7 = n21;
                    this.write(n17, (short)n21);
                    break;
                }
                case 21: {
                    n2 = n2 - 1 & 0xFF;
                    n13 = n2 >> 7 & 1;
                    n7 = n2;
                    break;
                }
                case 22: {
                    n3 = n3 - 1 & 0xFF;
                    n13 = n3 >> 7 & 1;
                    n7 = n3;
                    break;
                }
                case 23: {
                    n = (this.load(n17) ^ n) & 0xFF;
                    n13 = n >> 7 & 1;
                    n7 = n;
                    n22 += n23;
                    break;
                }
                case 24: {
                    n21 = this.load(n17) + 1 & 0xFF;
                    n13 = n21 >> 7 & 1;
                    n7 = n21;
                    this.write(n17, (short)(n21 & 0xFF));
                    break;
                }
                case 25: {
                    n2 = n2 + 1 & 0xFF;
                    n13 = n2 >> 7 & 1;
                    n7 = n2;
                    break;
                }
                case 26: {
                    ++n3;
                    n13 = (n3 &= 0xFF) >> 7 & 1;
                    n7 = n3;
                    break;
                }
                case 27: {
                    n5 = n17 - 1;
                    break;
                }
                case 28: {
                    this.push(n5 >> 8 & 0xFF);
                    this.push(n5 & 0xFF);
                    n5 = n17 - 1;
                    break;
                }
                case 29: {
                    n = this.load(n17);
                    n13 = n >> 7 & 1;
                    n7 = n;
                    n22 += n23;
                    break;
                }
                case 30: {
                    n2 = this.load(n17);
                    n13 = n2 >> 7 & 1;
                    n7 = n2;
                    n22 += n23;
                    break;
                }
                case 31: {
                    n3 = this.load(n17);
                    n13 = n3 >> 7 & 1;
                    n7 = n3;
                    n22 += n23;
                    break;
                }
                case 32: {
                    if (n16 == 4) {
                        n21 = n & 0xFF;
                        n6 = n21 & 1;
                        n = n21 >>= 1;
                    } else {
                        n21 = this.load(n17) & 0xFF;
                        n6 = n21 & 1;
                        this.write(n17, (short)(n21 >>= 1));
                    }
                    n13 = 0;
                    n7 = n21;
                    break;
                }
                case 33: {
                    break;
                }
                case 34: {
                    n21 = (this.load(n17) | n) & 0xFF;
                    n13 = n21 >> 7 & 1;
                    n7 = n21;
                    n = n21;
                    if (n16 == 11) break;
                    n22 += n23;
                    break;
                }
                case 35: {
                    this.push(n);
                    break;
                }
                case 36: {
                    n11 = 1;
                    this.push(n6 | (n7 == 0 ? 1 : 0) << 1 | n8 << 2 | n9 << 3 | n11 << 4 | n10 << 5 | n12 << 6 | n13 << 7);
                    break;
                }
                case 37: {
                    n = this.pull();
                    n13 = n >> 7 & 1;
                    n7 = n;
                    break;
                }
                case 38: {
                    n21 = this.pull();
                    n6 = n21 & 1;
                    n7 = (n21 >> 1 & 1) == 1 ? 0 : 1;
                    n8 = n21 >> 2 & 1;
                    n9 = n21 >> 3 & 1;
                    n11 = n21 >> 4 & 1;
                    n10 = n21 >> 5 & 1;
                    n12 = n21 >> 6 & 1;
                    n13 = n21 >> 7 & 1;
                    n10 = 1;
                    break;
                }
                case 39: {
                    int n24;
                    if (n16 == 4) {
                        n21 = n;
                        n24 = n6;
                        n6 = n21 >> 7 & 1;
                        n = n21 = (n21 << 1 & 0xFF) + n24;
                    } else {
                        n21 = this.load(n17);
                        n24 = n6;
                        n6 = n21 >> 7 & 1;
                        n21 = (n21 << 1 & 0xFF) + n24;
                        this.write(n17, (short)n21);
                    }
                    n13 = n21 >> 7 & 1;
                    n7 = n21;
                    break;
                }
                case 40: {
                    int n24;
                    if (n16 == 4) {
                        n24 = n6 << 7;
                        n6 = n & 1;
                        n = n21 = (n >> 1) + n24;
                    } else {
                        n21 = this.load(n17);
                        n24 = n6 << 7;
                        n6 = n21 & 1;
                        n21 = (n21 >> 1) + n24;
                        this.write(n17, (short)n21);
                    }
                    n13 = n21 >> 7 & 1;
                    n7 = n21;
                    break;
                }
                case 41: {
                    n21 = this.pull();
                    n6 = n21 & 1;
                    n7 = (n21 >> 1 & 1) == 0 ? 1 : 0;
                    n8 = n21 >> 2 & 1;
                    n9 = n21 >> 3 & 1;
                    n11 = n21 >> 4 & 1;
                    n10 = n21 >> 5 & 1;
                    n12 = n21 >> 6 & 1;
                    n13 = n21 >> 7 & 1;
                    n5 = this.pull();
                    if ((n5 += this.pull() << 8) == 65535) {
                        return;
                    }
                    --n5;
                    n10 = 1;
                    break;
                }
                case 42: {
                    n5 = this.pull();
                    if ((n5 += this.pull() << 8) != 65535) break;
                    return;
                }
                case 43: {
                    n21 = n - this.load(n17) - (1 - n6);
                    n13 = n21 >> 7 & 1;
                    n7 = n21 & 0xFF;
                    n12 = ((n ^ n21) & 0x80) != 0 && ((n ^ this.load(n17)) & 0x80) != 0 ? 1 : 0;
                    n6 = n21 < 0 ? 0 : 1;
                    n = n21 & 0xFF;
                    if (n16 == 11) break;
                    n22 += n23;
                    break;
                }
                case 44: {
                    n6 = 1;
                    break;
                }
                case 45: {
                    n9 = 1;
                    break;
                }
                case 46: {
                    n8 = 1;
                    break;
                }
                case 47: {
                    this.write(n17, (short)n);
                    break;
                }
                case 48: {
                    this.write(n17, (short)n2);
                    break;
                }
                case 49: {
                    this.write(n17, (short)n3);
                    break;
                }
                case 50: {
                    n2 = n;
                    n13 = n >> 7 & 1;
                    n7 = n;
                    break;
                }
                case 51: {
                    n3 = n;
                    n13 = n >> 7 & 1;
                    n7 = n;
                    break;
                }
                case 52: {
                    n2 = this.REG_SP - 256;
                    n13 = this.REG_SP >> 7 & 1;
                    n7 = n2;
                    break;
                }
                case 53: {
                    n = n2;
                    n13 = n2 >> 7 & 1;
                    n7 = n2;
                    break;
                }
                case 54: {
                    this.REG_SP = n2 + 256;
                    this.stackWrap();
                    break;
                }
                case 55: {
                    n = n3;
                    n13 = n3 >> 7 & 1;
                    n7 = n3;
                    break;
                }
                default: {
                    if (bl3) {
                        this.pull();
                        this.pull();
                        return;
                    }
                    if (this.crash) break;
                    this.crash = true;
                    this.stopRunning = true;
                    this.nes.gui.showErrorMsg("Game crashed, invalid opcode at address $" + Misc.hex16(n15));
                }
            }
            if (bl && ++n18 == 5) {
                n18 = 0;
                ++n22;
            }
            if (bl3) {
                this.nes.nsf.ppuCycles += n22;
                if (this.nes.nsf.ppuCycles >= 89342) {
                    this.nes.nsf.ppuCycles -= 89342;
                    this.nes.nsf.frameFinished();
                }
                this.nsfCycles += n22;
            } else {
                pPU.cycles = n22 * 3;
                pPU.emulateCycles();
            }
            if (!bl2) continue;
            if (Globals.nsfMode) {
                for (int i = 0; i < n22; ++i) {
                    pAPU.clockFrameCounter(1);
                }
                continue;
            }
            pAPU.clockFrameCounter(n22);
        }
        this.REG_ACC_NEW = n;
        this.REG_X_NEW = n2;
        this.REG_Y_NEW = n3;
        this.REG_STATUS_NEW = n4;
        this.REG_PC_NEW = n5;
        this.F_CARRY_NEW = n6;
        this.F_ZERO_NEW = n7 == 0 ? 1 : 0;
        this.F_INTERRUPT_NEW = n8;
        this.F_DECIMAL_NEW = n9;
        this.F_BRK_NEW = n11;
        this.F_NOTUSED_NEW = n10;
        this.F_OVERFLOW_NEW = n12;
        this.F_SIGN_NEW = n13;
    }

    private int load(int n) {
        return n < 8192 ? this.mem[n & 0x7FF] : this.mmap.load(n);
    }

    private int load16bit(int n) {
        return n < 8191 ? this.mem[n & 0x7FF] | this.mem[n + 1 & 0x7FF] << 8 : this.mmap.load(n) | this.mmap.load(n + 1) << 8;
    }

    private void write(int n, short s) {
        if (n < 8192) {
            this.mem[n & 0x7FF] = s;
        } else {
            this.mmap.write(n, s);
        }
    }

    public void requestIrq(int n) {
        if (this.irqRequested && n == 0) {
            return;
        }
        this.irqRequested = true;
        this.irqType = n;
    }

    public void push(int n) {
        this.mmap.write(this.REG_SP, (short)n);
        --this.REG_SP;
        this.REG_SP = 0x100 | this.REG_SP & 0xFF;
    }

    public void stackWrap() {
        this.REG_SP = 0x100 | this.REG_SP & 0xFF;
    }

    public short pull() {
        ++this.REG_SP;
        this.REG_SP = 0x100 | this.REG_SP & 0xFF;
        return this.mmap.load(this.REG_SP);
    }

    public boolean pageCrossed(int n, int n2) {
        return (n & 0xFF00) != (n2 & 0xFF00);
    }

    public void haltCycles(int n) {
        this.cyclesToHalt += n;
    }

    private void doNonMaskableInterrupt(int n) {
        short s = this.mmap.load(8192);
        if ((s & 0x80) != 0) {
            ++this.REG_PC_NEW;
            this.push(this.REG_PC_NEW >> 8 & 0xFF);
            this.push(this.REG_PC_NEW & 0xFF);
            this.push(n);
            this.REG_PC_NEW = this.mmap.load(65530) | this.mmap.load(65531) << 8;
            --this.REG_PC_NEW;
        }
    }

    private void doResetInterrupt() {
        this.REG_PC_NEW = this.mmap.load(65532) | this.mmap.load(65533) << 8;
        --this.REG_PC_NEW;
    }

    private void doIrq(int n) {
        ++this.REG_PC_NEW;
        this.push(this.REG_PC_NEW >> 8 & 0xFF);
        this.push(this.REG_PC_NEW & 0xFF);
        this.push(n);
        this.F_INTERRUPT_NEW = 1;
        this.F_BRK_NEW = 0;
        this.REG_PC_NEW = this.mmap.load(65534) | this.mmap.load(65535) << 8;
        --this.REG_PC_NEW;
    }

    private int getStatus() {
        return this.F_CARRY_NEW | this.F_ZERO_NEW << 1 | this.F_INTERRUPT_NEW << 2 | this.F_DECIMAL_NEW << 3 | this.F_BRK_NEW << 4 | this.F_NOTUSED_NEW << 5 | this.F_OVERFLOW_NEW << 6 | this.F_SIGN_NEW << 7;
    }

    private void setStatus(int n) {
        this.F_CARRY_NEW = n & 1;
        this.F_ZERO_NEW = n >> 1 & 1;
        this.F_INTERRUPT_NEW = n >> 2 & 1;
        this.F_DECIMAL_NEW = n >> 3 & 1;
        this.F_BRK_NEW = n >> 4 & 1;
        this.F_NOTUSED_NEW = n >> 5 & 1;
        this.F_OVERFLOW_NEW = n >> 6 & 1;
        this.F_SIGN_NEW = n >> 7 & 1;
    }

    public void setCrashed(boolean bl) {
        this.crash = bl;
    }

    public void setMapper(MemoryMapper memoryMapper) {
        this.mmap = memoryMapper;
    }

    public void destroy() {
        this.nes = null;
        this.mmap = null;
    }
}

