/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ByteBuffer {
    public static final boolean DEBUG = false;
    public static final int BO_BIG_ENDIAN = 0;
    public static final int BO_LITTLE_ENDIAN = 1;
    private int byteOrder = 0;
    private short[] buf;
    private int size;
    private int curPos;
    private boolean hasBeenErrors;
    private boolean expandable = true;
    private int expandBy = 4096;

    public ByteBuffer(int n, int n2) {
        if (n < 1) {
            n = 1;
        }
        this.buf = new short[n];
        this.size = n;
        this.byteOrder = n2;
        this.curPos = 0;
        this.hasBeenErrors = false;
    }

    public ByteBuffer(byte[] byArray, int n) {
        try {
            this.buf = new short[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                this.buf[i] = (short)(byArray[i] & 0xFF);
            }
            this.size = byArray.length;
            this.byteOrder = n;
            this.curPos = 0;
            this.hasBeenErrors = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setExpandable(boolean bl) {
        this.expandable = bl;
    }

    public void setExpandBy(int n) {
        if (n > 1024) {
            this.expandBy = n;
        }
    }

    public void setByteOrder(int n) {
        if (n >= 0 && n < 2) {
            this.byteOrder = n;
        }
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.buf.length];
        for (int i = 0; i < this.buf.length; ++i) {
            byArray[i] = (byte)this.buf[i];
        }
        return byArray;
    }

    public int getSize() {
        return this.size;
    }

    public int getPos() {
        return this.curPos;
    }

    private void error() {
        this.hasBeenErrors = true;
    }

    public boolean hasHadErrors() {
        return this.hasBeenErrors;
    }

    public void clear() {
        for (int i = 0; i < this.buf.length; ++i) {
            this.buf[i] = 0;
        }
        this.curPos = 0;
    }

    public void fill(byte by) {
        for (int i = 0; i < this.size; ++i) {
            this.buf[i] = by;
        }
    }

    public boolean fillRange(int n, int n2, byte by) {
        if (this.inRange(n, n2)) {
            for (int i = n; i < n + n2; ++i) {
                this.buf[i] = by;
            }
            return true;
        }
        this.error();
        return false;
    }

    public void resize(int n) {
        short[] sArray = new short[n];
        System.arraycopy(this.buf, 0, sArray, 0, Math.min(n, this.size));
        this.buf = sArray;
        this.size = n;
    }

    public void resizeToCurrentPos() {
        this.resize(this.curPos);
    }

    public void expand() {
        this.expand(this.expandBy);
    }

    public void expand(int n) {
        this.resize(this.size + n);
    }

    public void goTo(int n) {
        if (this.inRange(n)) {
            this.curPos = n;
        } else {
            this.error();
        }
    }

    public void move(int n) {
        this.curPos += n;
        if (!this.inRange(this.curPos)) {
            this.curPos = this.size - 1;
        }
    }

    public boolean inRange(int n) {
        if (n >= 0 && n < this.size) {
            return true;
        }
        if (this.expandable) {
            this.expand(Math.max(n + 1 - this.size, this.expandBy));
            return true;
        }
        return false;
    }

    public boolean inRange(int n, int n2) {
        if (n >= 0 && n + (n2 - 1) < this.size) {
            return true;
        }
        if (this.expandable) {
            this.expand(Math.max(n + n2 - this.size, this.expandBy));
            return true;
        }
        return false;
    }

    public boolean putBoolean(boolean bl) {
        boolean bl2 = this.putBoolean(bl, this.curPos);
        this.move(1);
        return bl2;
    }

    public boolean putBoolean(boolean bl, int n) {
        if (bl) {
            return this.putByte((short)1, n);
        }
        return this.putByte((short)0, n);
    }

    public boolean putByte(short s) {
        if (this.inRange(this.curPos, 1)) {
            this.buf[this.curPos] = s;
            this.move(1);
            return true;
        }
        this.error();
        return false;
    }

    public boolean putByte(short s, int n) {
        if (this.inRange(n, 1)) {
            this.buf[n] = s;
            return true;
        }
        this.error();
        return false;
    }

    public boolean putShort(short s) {
        boolean bl = this.putShort(s, this.curPos);
        if (bl) {
            this.move(2);
        }
        return bl;
    }

    public boolean putShort(short s, int n) {
        if (this.inRange(n, 2)) {
            if (this.byteOrder == 0) {
                this.buf[n + 0] = (short)(s >> 8 & 0xFF);
                this.buf[n + 1] = (short)(s & 0xFF);
            } else {
                this.buf[n + 1] = (short)(s >> 8 & 0xFF);
                this.buf[n + 0] = (short)(s & 0xFF);
            }
            return true;
        }
        this.error();
        return false;
    }

    public boolean putInt(int n) {
        boolean bl = this.putInt(n, this.curPos);
        if (bl) {
            this.move(4);
        }
        return bl;
    }

    public boolean putInt(int n, int n2) {
        if (this.inRange(n2, 4)) {
            if (this.byteOrder == 0) {
                this.buf[n2 + 0] = (short)(n >> 24 & 0xFF);
                this.buf[n2 + 1] = (short)(n >> 16 & 0xFF);
                this.buf[n2 + 2] = (short)(n >> 8 & 0xFF);
                this.buf[n2 + 3] = (short)(n & 0xFF);
            } else {
                this.buf[n2 + 3] = (short)(n >> 24 & 0xFF);
                this.buf[n2 + 2] = (short)(n >> 16 & 0xFF);
                this.buf[n2 + 1] = (short)(n >> 8 & 0xFF);
                this.buf[n2 + 0] = (short)(n & 0xFF);
            }
            return true;
        }
        this.error();
        return false;
    }

    public boolean putString(String string) {
        boolean bl = this.putString(string, this.curPos);
        if (bl) {
            this.move(2 * string.length());
        }
        return bl;
    }

    public boolean putString(String string, int n) {
        char[] cArray = string.toCharArray();
        if (this.inRange(n, string.length() * 2)) {
            for (int i = 0; i < string.length(); ++i) {
                short s = (short)cArray[i];
                this.buf[n + 0] = (short)(s >> 8 & 0xFF);
                this.buf[n + 1] = (short)(s & 0xFF);
                n += 2;
            }
            return true;
        }
        this.error();
        return false;
    }

    public boolean putChar(char c) {
        boolean bl = this.putChar(c, this.curPos);
        if (bl) {
            this.move(2);
        }
        return bl;
    }

    public boolean putChar(char c, int n) {
        char c2 = c;
        if (this.inRange(n, 2)) {
            if (this.byteOrder == 0) {
                this.buf[n + 0] = (short)(c2 >> 8 & 0xFF);
                this.buf[n + 1] = (short)(c2 & 0xFF);
            } else {
                this.buf[n + 1] = (short)(c2 >> 8 & 0xFF);
                this.buf[n + 0] = (short)(c2 & 0xFF);
            }
            return true;
        }
        this.error();
        return false;
    }

    public boolean putCharAscii(char c) {
        boolean bl = this.putCharAscii(c, this.curPos);
        if (bl) {
            this.move(1);
        }
        return bl;
    }

    public boolean putCharAscii(char c, int n) {
        if (this.inRange(n)) {
            this.buf[n] = (short)c;
            return true;
        }
        this.error();
        return false;
    }

    public boolean putStringAscii(String string) {
        boolean bl = this.putStringAscii(string, this.curPos);
        if (bl) {
            this.move(string.length());
        }
        return bl;
    }

    public boolean putStringAscii(String string, int n) {
        char[] cArray = string.toCharArray();
        if (this.inRange(n, string.length())) {
            for (int i = 0; i < string.length(); ++i) {
                this.buf[n] = (short)cArray[i];
                ++n;
            }
            return true;
        }
        this.error();
        return false;
    }

    public boolean putByteArray(short[] sArray) {
        if (sArray == null) {
            return false;
        }
        if (this.buf.length - this.curPos < sArray.length) {
            this.resize(this.curPos + sArray.length);
        }
        for (int i = 0; i < sArray.length; ++i) {
            this.buf[this.curPos + i] = (byte)sArray[i];
        }
        this.curPos += sArray.length;
        return true;
    }

    public boolean readByteArray(short[] sArray) {
        if (sArray == null) {
            return false;
        }
        if (this.buf.length - this.curPos < sArray.length) {
            return false;
        }
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)(this.buf[this.curPos + i] & 0xFF);
        }
        this.curPos += sArray.length;
        return true;
    }

    public boolean putShortArray(short[] sArray) {
        if (sArray == null) {
            return false;
        }
        if (this.buf.length - this.curPos < sArray.length * 2) {
            this.resize(this.curPos + sArray.length * 2);
        }
        if (this.byteOrder == 0) {
            for (int i = 0; i < sArray.length; ++i) {
                this.buf[this.curPos + 0] = (short)(sArray[i] >> 8 & 0xFF);
                this.buf[this.curPos + 1] = (short)(sArray[i] & 0xFF);
                this.curPos += 2;
            }
        } else {
            for (int i = 0; i < sArray.length; ++i) {
                this.buf[this.curPos + 1] = (short)(sArray[i] >> 8 & 0xFF);
                this.buf[this.curPos + 0] = (short)(sArray[i] & 0xFF);
                this.curPos += 2;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size - 1; i += 2) {
            short s = (short)(this.buf[i] << 8 | this.buf[i + 1]);
            stringBuffer.append((char)s);
        }
        return stringBuffer.toString();
    }

    public String toStringAscii() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size; ++i) {
            stringBuffer.append((char)this.buf[i]);
        }
        return stringBuffer.toString();
    }

    public boolean readBoolean() {
        boolean bl = this.readBoolean(this.curPos);
        this.move(1);
        return bl;
    }

    public boolean readBoolean(int n) {
        return this.readByte(n) == 1;
    }

    public short readByte() throws ArrayIndexOutOfBoundsException {
        short s = this.readByte(this.curPos);
        this.move(1);
        return s;
    }

    public short readByte(int n) throws ArrayIndexOutOfBoundsException {
        if (this.inRange(n)) {
            return this.buf[n];
        }
        this.error();
        throw new ArrayIndexOutOfBoundsException();
    }

    public short readShort() throws ArrayIndexOutOfBoundsException {
        short s = this.readShort(this.curPos);
        this.move(2);
        return s;
    }

    public short readShort(int n) throws ArrayIndexOutOfBoundsException {
        if (this.inRange(n, 2)) {
            if (this.byteOrder == 0) {
                return (short)(this.buf[n] << 8 | this.buf[n + 1]);
            }
            return (short)(this.buf[n + 1] << 8 | this.buf[n]);
        }
        this.error();
        throw new ArrayIndexOutOfBoundsException();
    }

    public int readInt() throws ArrayIndexOutOfBoundsException {
        int n = this.readInt(this.curPos);
        this.move(4);
        return n;
    }

    public int readInt(int n) throws ArrayIndexOutOfBoundsException {
        int n2 = 0;
        if (this.inRange(n, 4)) {
            if (this.byteOrder == 0) {
                n2 |= this.buf[n + 0] << 24;
                n2 |= this.buf[n + 1] << 16;
                n2 |= this.buf[n + 2] << 8;
                n2 |= this.buf[n + 3];
            } else {
                n2 |= this.buf[n + 3] << 24;
                n2 |= this.buf[n + 2] << 16;
                n2 |= this.buf[n + 1] << 8;
                n2 |= this.buf[n + 0];
            }
            return n2;
        }
        this.error();
        throw new ArrayIndexOutOfBoundsException();
    }

    public char readChar() throws ArrayIndexOutOfBoundsException {
        char c = this.readChar(this.curPos);
        this.move(2);
        return c;
    }

    public char readChar(int n) throws ArrayIndexOutOfBoundsException {
        if (this.inRange(n, 2)) {
            return (char)this.readShort(n);
        }
        this.error();
        throw new ArrayIndexOutOfBoundsException();
    }

    public char readCharAscii() throws ArrayIndexOutOfBoundsException {
        char c = this.readCharAscii(this.curPos);
        this.move(1);
        return c;
    }

    public char readCharAscii(int n) throws ArrayIndexOutOfBoundsException {
        if (this.inRange(n, 1)) {
            return (char)(this.readByte(n) & 0xFF);
        }
        this.error();
        throw new ArrayIndexOutOfBoundsException();
    }

    public String readString(int n) throws ArrayIndexOutOfBoundsException {
        if (n > 0) {
            String string = this.readString(this.curPos, n);
            this.move(string.length() * 2);
            return string;
        }
        return new String("");
    }

    public String readString(int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (this.inRange(n, n2 * 2) && n2 > 0) {
            char[] cArray = new char[n2];
            for (int i = 0; i < n2; ++i) {
                cArray[i] = this.readChar(n + i * 2);
            }
            return new String(cArray);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public String readStringWithShortLength() throws ArrayIndexOutOfBoundsException {
        String string = this.readStringWithShortLength(this.curPos);
        this.move(string.length() * 2 + 2);
        return string;
    }

    public String readStringWithShortLength(int n) throws ArrayIndexOutOfBoundsException {
        if (this.inRange(n, 2)) {
            short s = this.readShort(n);
            if (s > 0) {
                return this.readString(n + 2, s);
            }
            return new String("");
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public String readStringAscii(int n) throws ArrayIndexOutOfBoundsException {
        String string = this.readStringAscii(this.curPos, n);
        this.move(string.length());
        return string;
    }

    public String readStringAscii(int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (this.inRange(n, n2) && n2 > 0) {
            char[] cArray = new char[n2];
            for (int i = 0; i < n2; ++i) {
                cArray[i] = this.readCharAscii(n + i);
            }
            return new String(cArray);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public String readStringAsciiWithShortLength() throws ArrayIndexOutOfBoundsException {
        String string = this.readStringAsciiWithShortLength(this.curPos);
        this.move(string.length() + 2);
        return string;
    }

    public String readStringAsciiWithShortLength(int n) throws ArrayIndexOutOfBoundsException {
        if (this.inRange(n, 2)) {
            short s = this.readShort(n);
            if (s > 0) {
                return this.readStringAscii(n + 2, s);
            }
            return new String("");
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    private short[] expandShortArray(short[] sArray, int n) {
        short[] sArray2 = new short[sArray.length + n];
        if (n > 0) {
            System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
        } else {
            System.arraycopy(sArray, 0, sArray2, 0, sArray2.length);
        }
        return sArray2;
    }

    public void crop() {
        if (this.curPos > 0 && this.curPos < this.buf.length) {
            short[] sArray = new short[this.curPos];
            System.arraycopy(this.buf, 0, sArray, 0, this.curPos);
            this.buf = sArray;
        }
    }

    public static ByteBuffer asciiEncode(ByteBuffer byteBuffer) {
        short[] sArray = byteBuffer.buf;
        byte[] byArray = new byte[byteBuffer.getSize() * 2];
        int n = 0;
        for (int i = 0; i < sArray.length; ++i) {
            short s = sArray[i];
            byArray[n] = (byte)(65 + s & 0xF);
            byArray[n + 1] = (byte)(65 + (s >> 4) & 0xF);
            n += 2;
        }
        return new ByteBuffer(byArray, 0);
    }

    public static ByteBuffer asciiDecode(ByteBuffer byteBuffer) {
        return null;
    }

    public static void saveToZipFile(File file, ByteBuffer byteBuffer) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            zipOutputStream.putNextEntry(new ZipEntry("contents"));
            zipOutputStream.write(byteBuffer.getBytes());
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static ByteBuffer readFromZipFile(File file) {
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry("contents");
            int n2 = (int)zipEntry.getSize();
            byte[] byArray = new byte[n2];
            zipInputStream.getNextEntry();
            for (int i = 0; i < n2 && (n = zipInputStream.read(byArray, i, n2 - i)) >= 0; i += n) {
            }
            zipInputStream.closeEntry();
            zipInputStream.close();
            fileInputStream.close();
            zipFile.close();
            return new ByteBuffer(byArray, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

