/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.VolatileImage;
import javax.swing.JPanel;

public class BufferView
extends JPanel {
    public static final int SCALE_NONE = 0;
    public static final int SCALE_HW2X = 1;
    public static final int SCALE_HW3X = 2;
    public static final int SCALE_NORMAL = 3;
    public static final int SCALE_SCANLINE = 4;
    public static final int SCALE_RASTER = 5;
    protected NES nes;
    private BufferedImage img;
    private VolatileImage vimg;
    private boolean usingMenu = false;
    private Graphics gfx;
    private int width;
    private int height;
    private int[] pix;
    private int[] pix_scaled;
    private int scaleMode;
    private boolean showFPS = false;
    private long prevFrameTime;
    private String fps;
    private int fpsCounter;
    private Font fpsFont = new Font("Verdana", 1, 10);
    private int bgColor = Color.white.darker().getRGB();

    public BufferView(NES nES, int n, int n2) {
        super(false);
        this.nes = nES;
        this.width = n;
        this.height = n2;
        this.scaleMode = -1;
    }

    public void setBgColor(int n) {
        this.bgColor = n;
    }

    public void setScaleMode(int n) {
        if (n != this.scaleMode) {
            boolean bl = this.useHWScaling(n) != this.useHWScaling(this.scaleMode);
            boolean bl2 = this.getScaleModeScale(n) != this.getScaleModeScale(this.scaleMode);
            this.scaleMode = n;
            if (bl || bl2) {
                this.createView();
            }
        }
    }

    public void init() {
        this.setScaleMode(0);
    }

    private void createView() {
        Graphics2D graphics2D;
        int n = this.getScaleModeScale(this.scaleMode);
        if (!this.useHWScaling(this.scaleMode)) {
            this.img = new BufferedImage(this.width * n, this.height * n, 1);
        } else {
            this.img = new BufferedImage(this.width, this.height, 1);
            this.gfx = this.img.createGraphics();
            this.gfx.setFont(this.fpsFont);
            graphics2D = (Graphics2D)this.gfx;
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            try {
                this.vimg = this.createVolatileImage(this.width, this.height, new ImageCapabilities(true));
            }
            catch (Exception exception) {
                this.scaleMode = 3;
                this.img = new BufferedImage(this.width * n, this.height * n, 1);
            }
        }
        this.gfx = this.img.createGraphics();
        this.gfx.setFont(this.fpsFont);
        graphics2D = (Graphics2D)this.gfx;
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        DataBufferInt dataBufferInt = (DataBufferInt)this.img.getRaster().getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        if (this.scaleMode == 0 || this.scaleMode == 1 || this.scaleMode == 2) {
            this.pix = nArray;
            if (this.nes.usePPU()) {
                this.nes.ppu.buffer = nArray;
            }
        } else {
            this.pix_scaled = nArray;
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.bgColor;
        }
        this.setSize(this.width * n, this.height * n);
        this.setBounds(this.getX(), this.getY(), this.width * n, this.height * n);
        this.invalidate();
        this.repaint();
    }

    public void imageReady(boolean bl) {
        if (!bl && !Globals.guiIconified) {
            if (this.scaleMode != 0) {
                if (this.scaleMode == 3) {
                    Scale.doNormalScaling(this.pix, this.pix_scaled, this.nes.ppu.scanlineChanged);
                } else if (this.scaleMode == 4) {
                    Scale.doScanlineScaling(this.pix, this.pix_scaled, this.nes.ppu.scanlineChanged);
                } else if (this.scaleMode == 5) {
                    Scale.doRasterScaling(this.pix, this.pix_scaled, this.nes.ppu.scanlineChanged);
                }
            }
            if (this.nes.usePPU()) {
                this.nes.ppu.requestRenderAll = false;
            }
            if (!this.nes.getGui().isFullScreen()) {
                this.paint(this.getGraphics());
            }
        }
    }

    public Image getImage() {
        return this.img;
    }

    public int[] getBuffer() {
        return this.pix;
    }

    public void update(Graphics graphics) {
    }

    public boolean scalingEnabled() {
        return this.scaleMode != 0;
    }

    public int getScaleMode() {
        return this.scaleMode;
    }

    public boolean useNormalScaling() {
        return this.scaleMode == 3;
    }

    public void paint(Graphics graphics) {
        if (this.usingMenu) {
            return;
        }
        if (Globals.guiIconified) {
            return;
        }
        if (this.scaleMode != 0) {
            this.paintFPS(0, 14, graphics);
            this.paint_scaled(graphics);
        } else if (this.img != null && graphics != null) {
            this.paintFPS(0, 14, graphics);
            graphics.drawImage(this.img, 0, 0, null);
        }
    }

    public void paint_scaled(Graphics graphics) {
        if (this.usingMenu) {
            return;
        }
        if (Globals.guiIconified) {
            return;
        }
        if (this.scaleMode == 1) {
            if (graphics != null && this.img != null && this.vimg != null) {
                this.vimg.getGraphics().drawImage(this.img, 0, 0, null);
                graphics.drawImage(this.vimg, 0, 0, this.width * 2, this.height * 2, null);
            }
        } else if (this.scaleMode == 2) {
            if (graphics != null && this.img != null && this.vimg != null) {
                this.vimg.getGraphics().drawImage(this.img, 0, 0, null);
                graphics.drawImage(this.vimg, 0, 0, this.width * 3, this.height * 3, null);
            }
        } else if (graphics != null && this.img != null) {
            graphics.drawImage(this.img, 0, 0, this.width * 2, this.height * 2, null);
        }
    }

    public void setFPSEnabled(boolean bl) {
        this.showFPS = bl;
    }

    public void paintFPS(int n, int n2, Graphics graphics) {
        if (this.usingMenu) {
            return;
        }
        if (Globals.guiIconified) {
            return;
        }
        if (this.showFPS) {
            if (--this.fpsCounter <= 0) {
                long l = this.nes.getGui().getTimer().currentMicros();
                long l2 = (l - this.prevFrameTime) / 45L;
                this.fps = l2 == 0L ? "FPS: -" : "FPS: " + 1000000L / l2;
                this.fpsCounter = 45;
                this.prevFrameTime = l;
            }
            this.gfx.setColor(Color.black);
            this.gfx.fillRect(n, n2 - this.gfx.getFontMetrics().getAscent(), this.gfx.getFontMetrics().stringWidth(this.fps) + 3, this.gfx.getFontMetrics().getHeight());
            this.gfx.setColor(Color.cyan);
            this.gfx.drawString(this.fps, n, n2);
        }
    }

    public int getBufferWidth() {
        return this.width;
    }

    public int getBufferHeight() {
        return this.height;
    }

    public void setUsingMenu(boolean bl) {
        this.usingMenu = bl;
    }

    public boolean useHWScaling() {
        return this.useHWScaling(this.scaleMode);
    }

    public boolean useHWScaling(int n) {
        return n == 1 || n == 2;
    }

    public int getScaleModeScale(int n) {
        if (n == -1) {
            return -1;
        }
        if (n == 0) {
            return 1;
        }
        if (n == 2) {
            return 3;
        }
        return 2;
    }

    public void destroy() {
        this.nes = null;
        this.img = null;
    }
}

