/*
 * Decompiled with CFR 0.152.
 */
public class BlipBuffer {
    public int win_size;
    public int smp_period;
    public int sinc_periods;
    public int[][] imp;
    public int[] diff;
    int lastChanged;
    int prevSum;
    int dc_prev;
    int dc_diff;
    int dc_acc;

    public void init(int n, int n2, int n3, int n4) {
        int n5;
        this.win_size = n2;
        this.smp_period = n3;
        this.sinc_periods = n4;
        double[] dArray = new double[this.smp_period * this.win_size];
        double d = this.sinc_periods;
        for (n5 = 0; n5 < dArray.length; ++n5) {
            dArray[n5] = BlipBuffer.sinc(-d * Math.PI + d * 2.0 * (double)n5 * Math.PI / (double)dArray.length);
        }
        this.imp = new int[this.smp_period][this.win_size];
        for (n5 = 0; n5 < this.smp_period; ++n5) {
            double d2 = 0.0;
            for (int i = 0; i < this.win_size; ++i) {
                this.imp[this.smp_period - 1 - n5][i] = (int)(d2 += 32768.0 * dArray[i * this.smp_period + n5]);
            }
        }
        this.diff = new int[n];
        this.lastChanged = 0;
        this.prevSum = 0;
        this.dc_prev = 0;
        this.dc_diff = 0;
        this.dc_acc = 0;
    }

    public void impulse(int n, int n2, int n3) {
        int n4;
        for (n4 = this.lastChanged; n4 < n + this.win_size; ++n4) {
            this.diff[n4] = this.prevSum;
        }
        for (n4 = 0; n4 < this.win_size; ++n4) {
            int n5 = n + n4;
            this.diff[n5] = this.diff[n5] + (this.imp[n2][n4] * n3 >> 8);
        }
        this.lastChanged = n + this.win_size;
        this.prevSum = this.diff[n + this.win_size - 1];
    }

    public int integrate() {
        int n = this.prevSum;
        for (int i = 0; i < this.diff.length; ++i) {
            this.dc_diff = (n += this.diff[i]) - this.dc_prev;
            this.dc_prev += this.dc_diff;
            this.dc_acc += this.dc_diff - (this.dc_acc >> 10);
            this.diff[i] = this.dc_acc;
        }
        this.prevSum = n;
        return this.lastChanged;
    }

    public void clear() {
        for (int i = 0; i < this.diff.length; ++i) {
            this.diff[i] = 0;
        }
        this.lastChanged = 0;
    }

    public static double sinc(double d) {
        if (d == 0.0) {
            return 1.0;
        }
        return Math.sin(d) / d;
    }
}

