/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;

public class AppletUI
implements UI {
    vNES applet;
    NES nes;
    KbInputHandler kbJoy1;
    KbInputHandler kbJoy2;
    ScreenView vScreen;
    HiResTimer timer = new HiResTimer();
    long t1;
    long t2;
    int sleepTime;

    public AppletUI(vNES vNES2) {
        this.applet = vNES2;
        this.nes = new NES(this);
    }

    public void init(boolean bl) {
        this.vScreen = new ScreenView(this.nes, 256, 240);
        this.vScreen.setBgColor(this.applet.bgColor.getRGB());
        this.vScreen.init();
        this.vScreen.setNotifyImageReady(true);
        this.kbJoy1 = new KbInputHandler(this.nes, 0);
        this.kbJoy2 = new KbInputHandler(this.nes, 1);
        this.kbJoy1.mapKey(0, 88);
        this.kbJoy1.mapKey(1, 90);
        this.kbJoy1.mapKey(2, 10);
        this.kbJoy1.mapKey(3, 17);
        this.kbJoy1.mapKey(4, 38);
        this.kbJoy1.mapKey(5, 40);
        this.kbJoy1.mapKey(6, 37);
        this.kbJoy1.mapKey(7, 39);
        this.vScreen.addKeyListener(this.kbJoy1);
        this.kbJoy2.mapKey(0, 103);
        this.kbJoy2.mapKey(1, 105);
        this.kbJoy2.mapKey(2, 97);
        this.kbJoy2.mapKey(3, 99);
        this.kbJoy2.mapKey(4, 104);
        this.kbJoy2.mapKey(5, 98);
        this.kbJoy2.mapKey(6, 100);
        this.kbJoy2.mapKey(7, 102);
        this.vScreen.addKeyListener(this.kbJoy2);
    }

    public void imageReady(boolean bl) {
        int n = this.nes.getPapu().bufferIndex;
        if (Globals.enableSound && Globals.timeEmulation && n > 0) {
            int n2 = this.nes.getPapu().line.getBufferSize() - 4 * n;
            this.timer.sleepMicros(this.nes.papu.getMillisToAvailableAbove(n2));
            while (this.nes.getPapu().line.available() < n2) {
                this.timer.yield();
            }
            this.nes.getPapu().writeBuffer();
        }
        if (Globals.timeEmulation && !Globals.enableSound) {
            this.sleepTime = Globals.frameTime;
            this.t2 = this.timer.currentMicros();
            if (this.t2 - this.t1 < (long)this.sleepTime) {
                this.timer.sleepMicros((long)this.sleepTime - (this.t2 - this.t1));
            }
        }
        this.t1 = this.t2;
    }

    public int getRomFileSize() {
        return this.applet.romSize;
    }

    public void showLoadProgress(int n) {
        this.applet.showLoadProgress(n);
        this.timer.sleepMicros(20000L);
    }

    public void destroy() {
        if (this.vScreen != null) {
            this.vScreen.destroy();
        }
        if (this.kbJoy1 != null) {
            this.kbJoy1.destroy();
        }
        if (this.kbJoy2 != null) {
            this.kbJoy2.destroy();
        }
        this.nes = null;
        this.applet = null;
        this.kbJoy1 = null;
        this.kbJoy2 = null;
        this.vScreen = null;
        this.timer = null;
    }

    public NES getNES() {
        return this.nes;
    }

    public InputHandler getJoy1() {
        return this.kbJoy1;
    }

    public InputHandler getJoy2() {
        return this.kbJoy2;
    }

    public BufferView getScreenView() {
        return this.vScreen;
    }

    public BufferView getPatternView() {
        return null;
    }

    public BufferView getSprPalView() {
        return null;
    }

    public BufferView getNameTableView() {
        return null;
    }

    public BufferView getImgPalView() {
        return null;
    }

    public HiResTimer getTimer() {
        return this.timer;
    }

    public boolean isFullScreen() {
        return false;
    }

    public String getWindowCaption() {
        return "";
    }

    public void setWindowCaption(String string) {
    }

    public void setTitle(String string) {
    }

    public void setFullScreen(boolean bl) {
    }

    public Point getLocation() {
        return new Point(0, 0);
    }

    public int getWidth() {
        return this.applet.getWidth();
    }

    public int getHeight() {
        return this.applet.getHeight();
    }

    public void frameStep() {
    }

    public void println(String string) {
    }

    public void showErrorMsg(String string) {
        System.out.println(string);
    }
}

