/*----------------------------------*/
/*		  JQUERY START HERE
/*----------------------------------*/

jQuery(document).ready(function(){

/*----------------------------------*/
/*		    Navigation
/*----------------------------------*/

	jQuery("#nav > li:first-child").addClass('home-page'); // remove this if You don't want to have a house icon instead of text in homepage
	
	jQuery("#nav ul").css({display: "none"}); // Opera Fix
	jQuery("#nav li").hover(function(){
		jQuery(this).find('ul:first').css({visibility: "visible",display: "none"}).slideDown(200);
	},function(){
		jQuery(this).find('ul:first').css({visibility: "hidden"});
	});

/*----------------------------------*/
/*		   Image overlay
/*----------------------------------*/

	jQuery('.image-overlay a').hover(function () {
			jQuery(this).find('.image-overlay-bg').stop(true, true).animate({opacity: 0.6}, 300 );
		}, function () {
			jQuery(this).find('.image-overlay-bg').stop(true, true).animate({opacity: 0}, 300 );
		}
	);
	jQuery('.video-overlay a').hover(function () {
			jQuery(this).find('.video-overlay-bg').stop(true, true).animate({opacity: 0.6}, 300 );
		}, function () {
			jQuery(this).find('.video-overlay-bg').stop(true, true).animate({opacity: 0}, 300 );
		}
	);
	jQuery('.audio-overlay a').hover(function () {
			jQuery(this).find('.audio-overlay-bg').stop(true, true).animate({opacity: 0.6}, 300 );
		}, function () {
			jQuery(this).find('.audio-overlay-bg').stop(true, true).animate({opacity: 0}, 300 );
		}
	);
	jQuery('.link-overlay a').hover(function () {
			jQuery(this).find('.link-overlay-bg').stop(true, true).animate({opacity: 0.6}, 300 );
		}, function () {
			jQuery(this).find('.link-overlay-bg').stop(true, true).animate({opacity: 0}, 300 );
		}
	);
	jQuery('.gallery-overlay a').hover(function () {
			jQuery(this).find('.gallery-overlay-bg').stop(true, true).animate({opacity: 0.6}, 300 );
		}, function () {
			jQuery(this).find('.gallery-overlay-bg').stop(true, true).animate({opacity: 0}, 300 );
		}
	);

	jQuery('.lightbox-photo a').hover(function () {
			jQuery(this).find('img').stop(true, true).animate({opacity: 0.6}, 300 );
		}, function () {
			jQuery(this).find('img').stop(true, true).animate({opacity: 1}, 300 );
		}
	);

/*----------------------------------*/
/*		Adding classes to lists
/*----------------------------------*/

	jQuery("ul li:first-child").addClass("first-child");
	jQuery("ul li:last-child").addClass("last-child");

/*----------------------------------*/
/*		 TipTip plugin
/*----------------------------------*/

	jQuery(".tipped-top").tipTip({
		delay: 0,
		defaultPosition: "top"
	});
	jQuery(".tipped-bottom").tipTip({
		delay: 0,
		defaultPosition: "bottom"
	});
	jQuery(".tipped-left").tipTip({
		delay: 0,
		defaultPosition: "left"
	});
	jQuery(".tipped-right").tipTip({
		delay: 0,
		defaultPosition: "right"
	});

/*----------------------------------*/
/*		  Preloader
/*----------------------------------*/

	jQuery(".latest-projects, .gallery, .portfolio-boxed, .portfolio, .portfolio-single-photo, .blog-masonry-post").preloader();

/*----------------------------------*/
/*		      Twitter
/*----------------------------------*/

	jQuery('#tweets').tweetable({
		username: 'mthemes',
		time: true,
		limit: 1,
		replies: true,
		position: 'append'
	});

/*----------------------------------*/
/*		    Flickr Feed
/*----------------------------------*/

	jQuery('#flickr-feed ul').jflickrfeed({
		limit: 8,
		qstrings: {
			id: '67664457@N06'
		},
		itemTemplate:
		'<li>' +
			'<a rel="prettyPhoto[flickr-feed]" href="{{image_b}}" title="{{title}}">' +
				'<img src="{{image_s}}" alt="{{title}}" width="44" height="44" />' +
			'</a>' +
		'</li>'
	}, function(data) {
		jQuery("a[rel^='prettyPhoto']").prettyPhoto({
			overlay_gallery: false
		});
	});

/*----------------------------------*/
/*		GoToTop plugin
/*----------------------------------*/

	jQuery().UItoTop({
		easingType: 'easeOutQuart',
		scrollSpeed: 500,
	});

/*----------------------------------*/
/*	   UI Accordion and toggle
/*----------------------------------*/

	jQuery(".accordion").accordion ({
		header: "h3"
	});

	jQuery(".toggle div").hide(); // hide div on default
	jQuery(".toggle h3").click(function(){ // set the trigger
		jQuery(this).toggleClass("active").next().slideToggle(300); // add class active and toggle speed
		return false;
	});

/*----------------------------------*/
/*		FancyBox plugin
/*----------------------------------*/

	jQuery("a[rel^='prettyPhoto']").prettyPhoto({
		overlay_gallery:false
	});

/*----------------------------------*/
/*		Gallery Image Overlay
/*----------------------------------*/

	jQuery(".image-overlay a[rel^='prettyPhoto']").append("<span class='image-overlay-bg'></span>");
	jQuery(".video-overlay a[rel^='prettyPhoto']").append("<span class='video-overlay-bg'></span>");
	jQuery(".audio-overlay a[rel^='prettyPhoto']").append("<span class='audio-overlay-bg'></span>");
	jQuery(".link-overlay a[rel^='prettyPhoto']").append("<span class='link-overlay-bg'></span>");
	jQuery(".gallery-overlay a[rel^='prettyPhoto']").append("<span class='gallery-overlay-bg'></span>");

/*----------------------------------*/
/*		  FitVids plugin
/*----------------------------------*/

	jQuery(".container").fitVids();

/*----------------------------------*/
/*		  Skeleton Tabs
/*----------------------------------*/

/*
* Skeleton V1.1
* Copyright 2011, Dave Gamache
* www.getskeleton.com
* Free to use under the MIT license.
* http://www.opensource.org/licenses/mit-license.php
* 8/17/2011
*/

	/* Tabs Activiation
	================================================== */

	var tabs = $('ul.tabs');

	tabs.each(function(i) {

		//Get all tabs
		var tab = $(this).find('> li > a');
		tab.click(function(e) {

			//Get Location of tab's content
			var contentLocation = $(this).attr('href');

			//Let go if not a hashed one
			if(contentLocation.charAt(0)=="#") {

				e.preventDefault();

				//Make Tab Active
				tab.removeClass('active');
				$(this).addClass('active');

				//Show Tab Content & add active class
				$(contentLocation).fadeIn().addClass('active').siblings().hide().removeClass('active');

			}
		});
	});

/*----------------------------------*/
/*		  JQUERY ENDS HERE
/*----------------------------------*/

});